/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.text.pattern;

import org.hamcrest.text.pattern.FromTo;
import org.hamcrest.text.pattern.PatternComponent;
import org.hamcrest.text.pattern.SeparablePatternComponent;
import org.hamcrest.text.pattern.internal.ast.AnyCharacter;
import org.hamcrest.text.pattern.internal.ast.CaptureGroup;
import org.hamcrest.text.pattern.internal.ast.CharacterInRange;
import org.hamcrest.text.pattern.internal.ast.CharacterInUnicodeCategory;
import org.hamcrest.text.pattern.internal.ast.CharacterNotInRange;
import org.hamcrest.text.pattern.internal.ast.CharacterNotInUnicodeCategory;
import org.hamcrest.text.pattern.internal.ast.Choice;
import org.hamcrest.text.pattern.internal.ast.Exactly;
import org.hamcrest.text.pattern.internal.ast.GroupReference;
import org.hamcrest.text.pattern.internal.ast.ListOf;
import org.hamcrest.text.pattern.internal.ast.Literal;
import org.hamcrest.text.pattern.internal.ast.OneOrMore;
import org.hamcrest.text.pattern.internal.ast.Optional;
import org.hamcrest.text.pattern.internal.ast.Sequence;
import org.hamcrest.text.pattern.internal.ast.ZeroOrMore;

public abstract class Patterns {
    public static PatternComponent text(String text) {
        return new Literal(text);
    }

    public static PatternComponent anyCharacter() {
        return AnyCharacter.INSTANCE;
    }

    public static PatternComponent anyCharacterIn(String range) {
        return new CharacterInRange(range);
    }

    public static PatternComponent anyCharacterNotIn(String range) {
        return new CharacterNotInRange(range);
    }

    public static PatternComponent anyCharacterInCategory(String category) {
        return new CharacterInUnicodeCategory(category);
    }

    public static PatternComponent anyCharacterNotInCategory(String category) {
        return new CharacterNotInUnicodeCategory(category);
    }

    public static PatternComponent either(Object ... alternatives) {
        return new Choice(Patterns.toPatterns(alternatives));
    }

    public static PatternComponent sequence(Object ... elements) {
        return new Sequence(Patterns.toPatterns(elements));
    }

    public static PatternComponent optional(Object o) {
        return new Optional(Patterns.toPattern(o));
    }

    public static PatternComponent zeroOrMore(Object o) {
        return new ZeroOrMore(Patterns.toPattern(o));
    }

    public static PatternComponent oneOrMore(Object o) {
        return new OneOrMore(Patterns.toPattern(o));
    }

    public static PatternComponent group(String name, PatternComponent pattern) {
        return new CaptureGroup(name, pattern);
    }

    public static PatternComponent valueOf(String name) {
        return new GroupReference(name);
    }

    public static PatternComponent exactly(int requiredCount, Object o) {
        return new Exactly(requiredCount, Patterns.toPattern(o));
    }

    public static PatternComponent from(int minimumCount, int maximumCount, Object o) {
        return new FromTo(minimumCount, maximumCount, Patterns.toPattern(o));
    }

    public static SeparablePatternComponent listOf(Object element) {
        return new ListOf(Patterns.toPattern(element), Patterns.toPattern(","));
    }

    public static PatternComponent[] toPatterns(Object ... alternatives) {
        PatternComponent[] patterns = new PatternComponent[alternatives.length];
        for (int i = 0; i < patterns.length; ++i) {
            patterns[i] = Patterns.toPattern(alternatives[i]);
        }
        return patterns;
    }

    public static PatternComponent toPattern(Object object) {
        if (object instanceof PatternComponent) {
            return (PatternComponent)object;
        }
        return Patterns.text(object.toString());
    }
}

