/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge.ext;

import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringEscapeUtils;

public class XSSRequestWrapper
extends HttpServletRequestWrapper {
    public XSSRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String getParameter(String name) {
        String parameter = super.getParameter(name);
        return this.stripXSS(parameter);
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        return this.stripXSS(values);
    }

    public String getQueryString() {
        String query = super.getQueryString();
        return this.stripXSS(query);
    }

    public Map<String, String[]> getParameterMap() {
        Map parameterMap = super.getParameterMap();
        return this.stripXSS(parameterMap);
    }

    public String getHeader(String name) {
        String header = super.getHeader(name);
        return this.stripXSS(header);
    }

    private String stripXSS(String value) {
        if (value != null) {
            value = StringEscapeUtils.escapeHtml((String)value);
            value = StringEscapeUtils.escapeJavaScript((String)value);
            value = value.replaceAll("", "");
        }
        return value;
    }

    private String[] stripXSS(String[] values) {
        String[] encodedValues = new String[values.length];
        int i = 0;
        while (i < values.length) {
            encodedValues[i] = this.stripXSS(values[i]);
            ++i;
        }
        return encodedValues;
    }

    private Map<String, String[]> stripXSS(Map<String, String[]> parameterMap) {
        TreeMap<String, String[]> encodedMap = new TreeMap<String, String[]>();
        for (Map.Entry<String, String[]> next : parameterMap.entrySet()) {
            String key = next.getKey();
            String[] values = next.getValue();
            encodedMap.put(this.stripXSS(key), this.stripXSS(values));
        }
        return encodedMap;
    }
}

