/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.expandbarkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IExpandBarAdapter;
import org.eclipse.swt.internal.widgets.ScrollBarLCAUtil;
import org.eclipse.swt.internal.widgets.expandbarkit.ExpandBarOperationHandler;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Widget;

public final class ExpandBarLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.ExpandBar";
    private static final String[] ALLOWED_STYLES = new String[]{"NO_RADIO_GROUP", "BORDER"};
    private static final String PROP_BOTTOM_SPACING_BOUNDS = "bottomSpacingBounds";
    private static final String PROP_VSCROLLBAR_MAX = "vScrollBarMax";
    private static final String PROP_EXPAND_LISTENER = "Expand";
    private static final String PROP_COLLAPSE_LISTENER = "Collapse";

    public void preserveValues(Widget widget) {
        ExpandBar expandBar = (ExpandBar)widget;
        ControlLCAUtil.preserveValues(expandBar);
        WidgetLCAUtil.preserveCustomVariant(expandBar);
        WidgetLCAUtil.preserveProperty((Widget)expandBar, PROP_BOTTOM_SPACING_BOUNDS, ExpandBarLCA.getBottomSpacingBounds(expandBar));
        WidgetLCAUtil.preserveProperty((Widget)expandBar, PROP_VSCROLLBAR_MAX, ExpandBarLCA.getVScrollBarMax(expandBar));
        ScrollBarLCAUtil.preserveValues(expandBar);
    }

    public void readData(Widget widget) {
        super.readData(widget);
        ScrollBarLCAUtil.processSelectionEvent((ExpandBar)widget);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ExpandBar expandBar = (ExpandBar)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(expandBar, TYPE);
        remoteObject.setHandler(new ExpandBarOperationHandler(expandBar));
        remoteObject.set("parent", WidgetUtil.getId(expandBar.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(expandBar, ALLOWED_STYLES)));
        remoteObject.listen(PROP_EXPAND_LISTENER, true);
        remoteObject.listen(PROP_COLLAPSE_LISTENER, true);
        ScrollBarLCAUtil.renderInitialization(expandBar);
    }

    public void renderChanges(Widget widget) throws IOException {
        ExpandBar expandBar = (ExpandBar)widget;
        ControlLCAUtil.renderChanges(expandBar);
        WidgetLCAUtil.renderCustomVariant(expandBar);
        WidgetLCAUtil.renderProperty((Widget)expandBar, PROP_BOTTOM_SPACING_BOUNDS, ExpandBarLCA.getBottomSpacingBounds(expandBar), null);
        WidgetLCAUtil.renderProperty((Widget)expandBar, PROP_VSCROLLBAR_MAX, ExpandBarLCA.getVScrollBarMax(expandBar), 0);
        ScrollBarLCAUtil.renderChanges(expandBar);
    }

    private static Rectangle getBottomSpacingBounds(ExpandBar bar) {
        return ExpandBarLCA.getExpandBarAdapter(bar).getBottomSpacingBounds();
    }

    private static int getVScrollBarMax(ExpandBar bar) {
        int result = 0;
        if ((bar.getStyle() & 0x200) != 0) {
            IExpandBarAdapter expandBarAdapter = ExpandBarLCA.getExpandBarAdapter(bar);
            ExpandItem[] items = bar.getItems();
            int i = 0;
            while (i < items.length) {
                result += expandBarAdapter.getBounds((ExpandItem)items[i]).height;
                ++i;
            }
            result += bar.getSpacing() * (items.length + 1);
        }
        return result;
    }

    public static IExpandBarAdapter getExpandBarAdapter(ExpandBar bar) {
        return bar.getAdapter(IExpandBarAdapter.class);
    }
}

