/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class ObjectChecker {
    public static final byte[] tree = Constants.encodeASCII("tree ");
    public static final byte[] parent = Constants.encodeASCII("parent ");
    public static final byte[] author = Constants.encodeASCII("author ");
    public static final byte[] committer = Constants.encodeASCII("committer ");
    public static final byte[] encoding = Constants.encodeASCII("encoding ");
    public static final byte[] object = Constants.encodeASCII("object ");
    public static final byte[] type = Constants.encodeASCII("type ");
    public static final byte[] tag = Constants.encodeASCII("tag ");
    public static final byte[] tagger = Constants.encodeASCII("tagger ");
    private final MutableObjectId tempId = new MutableObjectId();
    private final MutableInteger ptrout = new MutableInteger();
    private boolean allowZeroMode;
    private boolean allowInvalidPersonIdent;
    private boolean windows;
    private boolean macosx;

    public ObjectChecker setAllowLeadingZeroFileMode(boolean allow) {
        this.allowZeroMode = allow;
        return this;
    }

    public ObjectChecker setAllowInvalidPersonIdent(boolean allow) {
        this.allowInvalidPersonIdent = allow;
        return this;
    }

    public ObjectChecker setSafeForWindows(boolean win) {
        this.windows = win;
        return this;
    }

    public ObjectChecker setSafeForMacOS(boolean mac) {
        this.macosx = mac;
        return this;
    }

    public void check(int objType, byte[] raw) throws CorruptObjectException {
        switch (objType) {
            case 1: {
                this.checkCommit(raw);
                break;
            }
            case 4: {
                this.checkTag(raw);
                break;
            }
            case 2: {
                this.checkTree(raw);
                break;
            }
            case 3: {
                this.checkBlob(raw);
                break;
            }
            default: {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidType2, objType));
            }
        }
    }

    private int id(byte[] raw, int ptr) {
        try {
            this.tempId.fromString(raw, ptr);
            return ptr + 40;
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
    }

    private int personIdent(byte[] raw, int ptr) {
        if (this.allowInvalidPersonIdent) {
            return RawParseUtils.nextLF(raw, ptr) - 1;
        }
        int emailB = RawParseUtils.nextLF(raw, ptr, '<');
        if (emailB == ptr || raw[emailB - 1] != 60) {
            return -1;
        }
        int emailE = RawParseUtils.nextLF(raw, emailB, '>');
        if (emailE == emailB || raw[emailE - 1] != 62) {
            return -1;
        }
        if (emailE == raw.length || raw[emailE] != 32) {
            return -1;
        }
        RawParseUtils.parseBase10(raw, emailE + 1, this.ptrout);
        ptr = this.ptrout.value;
        if (emailE + 1 == ptr) {
            return -1;
        }
        if (ptr == raw.length || raw[ptr] != 32) {
            return -1;
        }
        RawParseUtils.parseBase10(raw, ptr + 1, this.ptrout);
        if (ptr + 1 == this.ptrout.value) {
            return -1;
        }
        return this.ptrout.value;
    }

    public void checkCommit(byte[] raw) throws CorruptObjectException {
        int ptr = 0;
        if ((ptr = RawParseUtils.match(raw, ptr, tree)) < 0) {
            throw new CorruptObjectException(JGitText.get().corruptObjectNotreeHeader);
        }
        if ((ptr = this.id(raw, ptr)) < 0 || raw[ptr++] != 10) {
            throw new CorruptObjectException(JGitText.get().corruptObjectInvalidTree);
        }
        while (RawParseUtils.match(raw, ptr, parent) >= 0) {
            ptr += parent.length;
            if ((ptr = this.id(raw, ptr)) >= 0 && raw[ptr++] == 10) continue;
            throw new CorruptObjectException(JGitText.get().corruptObjectInvalidParent);
        }
        if ((ptr = RawParseUtils.match(raw, ptr, author)) < 0) {
            throw new CorruptObjectException(JGitText.get().corruptObjectNoAuthor);
        }
        if ((ptr = this.personIdent(raw, ptr)) < 0 || raw[ptr++] != 10) {
            throw new CorruptObjectException(JGitText.get().corruptObjectInvalidAuthor);
        }
        if ((ptr = RawParseUtils.match(raw, ptr, committer)) < 0) {
            throw new CorruptObjectException(JGitText.get().corruptObjectNoCommitter);
        }
        if ((ptr = this.personIdent(raw, ptr)) < 0 || raw[ptr++] != 10) {
            throw new CorruptObjectException(JGitText.get().corruptObjectInvalidCommitter);
        }
    }

    public void checkTag(byte[] raw) throws CorruptObjectException {
        int ptr = 0;
        if ((ptr = RawParseUtils.match(raw, ptr, object)) < 0) {
            throw new CorruptObjectException(JGitText.get().corruptObjectNoObjectHeader);
        }
        if ((ptr = this.id(raw, ptr)) < 0 || raw[ptr++] != 10) {
            throw new CorruptObjectException(JGitText.get().corruptObjectInvalidObject);
        }
        if ((ptr = RawParseUtils.match(raw, ptr, type)) < 0) {
            throw new CorruptObjectException(JGitText.get().corruptObjectNoTypeHeader);
        }
        ptr = RawParseUtils.nextLF(raw, ptr);
        if ((ptr = RawParseUtils.match(raw, ptr, tag)) < 0) {
            throw new CorruptObjectException(JGitText.get().corruptObjectNoTagHeader);
        }
        ptr = RawParseUtils.nextLF(raw, ptr);
        if ((ptr = RawParseUtils.match(raw, ptr, tagger)) > 0 && ((ptr = this.personIdent(raw, ptr)) < 0 || raw[ptr++] != 10)) {
            throw new CorruptObjectException(JGitText.get().corruptObjectInvalidTagger);
        }
    }

    private static int lastPathChar(int mode) {
        return FileMode.TREE.equals(mode) ? 47 : 0;
    }

    private static int pathCompare(byte[] raw, int aPos, int aEnd, int aMode, int bPos, int bEnd, int bMode) {
        while (aPos < aEnd && bPos < bEnd) {
            int cmp;
            if ((cmp = (raw[aPos++] & 0xFF) - (raw[bPos++] & 0xFF)) == 0) continue;
            return cmp;
        }
        if (aPos < aEnd) {
            return (raw[aPos] & 0xFF) - ObjectChecker.lastPathChar(bMode);
        }
        if (bPos < bEnd) {
            return ObjectChecker.lastPathChar(aMode) - (raw[bPos] & 0xFF);
        }
        return 0;
    }

    private static boolean duplicateName(byte[] raw, int thisNamePos, int thisNameEnd) {
        int sz = raw.length;
        int nextPtr = thisNameEnd + 1 + 20;
        while (true) {
            byte c;
            int nextMode = 0;
            while (true) {
                byte c2;
                if (nextPtr >= sz) {
                    return false;
                }
                if (32 == (c2 = raw[nextPtr++])) break;
                nextMode <<= 3;
                nextMode += c2 - 48;
            }
            int nextNamePos = nextPtr;
            do {
                if (nextPtr != sz) continue;
                return false;
            } while ((c = raw[nextPtr++]) != 0);
            if (nextNamePos + 1 == nextPtr) {
                return false;
            }
            int cmp = ObjectChecker.pathCompare(raw, thisNamePos, thisNameEnd, FileMode.TREE.getBits(), nextNamePos, nextPtr - 1, nextMode);
            if (cmp < 0) {
                return false;
            }
            if (cmp == 0) {
                return true;
            }
            nextPtr += 20;
        }
    }

    public void checkTree(byte[] raw) throws CorruptObjectException {
        HashSet<String> normalized;
        int sz = raw.length;
        int ptr = 0;
        int lastNameB = 0;
        int lastNameE = 0;
        int lastMode = 0;
        HashSet<String> hashSet = normalized = this.windows || this.macosx ? new HashSet<String>() : null;
        while (ptr < sz) {
            int cmp;
            int thisMode = 0;
            while (true) {
                byte c;
                if (ptr == sz) {
                    throw new CorruptObjectException(JGitText.get().corruptObjectTruncatedInMode);
                }
                if (32 == (c = raw[ptr++])) break;
                if (c < 48 || c > 55) {
                    throw new CorruptObjectException(JGitText.get().corruptObjectInvalidModeChar);
                }
                if (thisMode == 0 && c == 48 && !this.allowZeroMode) {
                    throw new CorruptObjectException(JGitText.get().corruptObjectInvalidModeStartsZero);
                }
                thisMode <<= 3;
                thisMode += c - 48;
            }
            if (FileMode.fromBits(thisMode).getObjectType() == -1) {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode2, thisMode));
            }
            int thisNameB = ptr;
            if ((ptr = this.scanPathSegment(raw, ptr, sz)) == sz || raw[ptr] != 0) {
                throw new CorruptObjectException(JGitText.get().corruptObjectTruncatedInName);
            }
            this.checkPathSegment2(raw, thisNameB, ptr);
            if (normalized != null ? !normalized.add(this.normalize(raw, thisNameB, ptr)) : ObjectChecker.duplicateName(raw, thisNameB, ptr)) {
                throw new CorruptObjectException(JGitText.get().corruptObjectDuplicateEntryNames);
            }
            if (lastNameB != 0 && (cmp = ObjectChecker.pathCompare(raw, lastNameB, lastNameE, lastMode, thisNameB, ptr, thisMode)) > 0) {
                throw new CorruptObjectException(JGitText.get().corruptObjectIncorrectSorting);
            }
            lastNameB = thisNameB;
            lastNameE = ptr;
            lastMode = thisMode;
            if ((ptr += 21) <= sz) continue;
            throw new CorruptObjectException(JGitText.get().corruptObjectTruncatedInObjectId);
        }
    }

    private int scanPathSegment(byte[] raw, int ptr, int end) throws CorruptObjectException {
        while (ptr < end) {
            byte c = raw[ptr];
            if (c == 0) {
                return ptr;
            }
            if (c == 47) {
                throw new CorruptObjectException(JGitText.get().corruptObjectNameContainsSlash);
            }
            if (this.windows && ObjectChecker.isInvalidOnWindows(c)) {
                if (c > 31) {
                    throw new CorruptObjectException(String.format(JGitText.get().corruptObjectNameContainsChar, c));
                }
                throw new CorruptObjectException(String.format(JGitText.get().corruptObjectNameContainsByte, c & 0xFF));
            }
            ++ptr;
        }
        return ptr;
    }

    public void checkPath(String path) throws CorruptObjectException {
        byte[] buf = Constants.encode(path);
        this.checkPath(buf, 0, buf.length);
    }

    public void checkPath(byte[] raw, int ptr, int end) throws CorruptObjectException {
        int start = ptr;
        while (ptr < end) {
            if (raw[ptr] == 47) {
                this.checkPathSegment(raw, start, ptr);
                start = ptr + 1;
            }
            ++ptr;
        }
        this.checkPathSegment(raw, start, end);
    }

    public void checkPathSegment(byte[] raw, int ptr, int end) throws CorruptObjectException {
        int e = this.scanPathSegment(raw, ptr, end);
        if (e < end && raw[e] == 0) {
            throw new CorruptObjectException(JGitText.get().corruptObjectNameContainsNullByte);
        }
        this.checkPathSegment2(raw, ptr, end);
    }

    private void checkPathSegment2(byte[] raw, int ptr, int end) throws CorruptObjectException {
        block15: {
            block14: {
                if (ptr == end) {
                    throw new CorruptObjectException(JGitText.get().corruptObjectNameZeroLength);
                }
                if (raw[ptr] != 46) break block14;
                switch (end - ptr) {
                    case 1: {
                        throw new CorruptObjectException(JGitText.get().corruptObjectNameDot);
                    }
                    case 2: {
                        if (raw[ptr + 1] == 46) {
                            throw new CorruptObjectException(JGitText.get().corruptObjectNameDotDot);
                        }
                        break block15;
                    }
                    case 4: {
                        if (ObjectChecker.isGit(raw, ptr + 1)) {
                            throw new CorruptObjectException(String.format(JGitText.get().corruptObjectInvalidName, RawParseUtils.decode(raw, ptr, end)));
                        }
                        break block15;
                    }
                    default: {
                        if (end - ptr > 4 && ObjectChecker.isNormalizedGit(raw, ptr + 1, end)) {
                            throw new CorruptObjectException(String.format(JGitText.get().corruptObjectInvalidName, RawParseUtils.decode(raw, ptr, end)));
                        }
                        break block15;
                    }
                }
            }
            if (ObjectChecker.isGitTilde1(raw, ptr, end)) {
                throw new CorruptObjectException(String.format(JGitText.get().corruptObjectInvalidName, RawParseUtils.decode(raw, ptr, end)));
            }
        }
        if (this.macosx && ObjectChecker.isMacHFSGit(raw, ptr, end)) {
            throw new CorruptObjectException(String.format(JGitText.get().corruptObjectInvalidNameIgnorableUnicode, RawParseUtils.decode(raw, ptr, end)));
        }
        if (this.windows) {
            if (raw[end - 1] == 32 || raw[end - 1] == 46) {
                throw new CorruptObjectException(String.format(JGitText.get().corruptObjectInvalidNameEnd, Character.valueOf((char)raw[end - 1])));
            }
            if (end - ptr >= 3) {
                ObjectChecker.checkNotWindowsDevice(raw, ptr, end);
            }
        }
    }

    private static boolean isMacHFSGit(byte[] raw, int ptr, int end) throws CorruptObjectException {
        boolean ignorable = false;
        byte[] git = new byte[]{46, 103, 105, 116};
        int g = 0;
        block14: while (ptr < end) {
            switch (raw[ptr]) {
                case -30: {
                    ObjectChecker.checkTruncatedIgnorableUTF8(raw, ptr, end);
                    switch (raw[ptr + 1]) {
                        case -128: {
                            switch (raw[ptr + 2]) {
                                case -116: 
                                case -115: 
                                case -114: 
                                case -113: 
                                case -86: 
                                case -85: 
                                case -84: 
                                case -83: 
                                case -82: {
                                    ignorable = true;
                                    ptr += 3;
                                    continue block14;
                                }
                            }
                            return false;
                        }
                        case -127: {
                            switch (raw[ptr + 2]) {
                                case -86: 
                                case -85: 
                                case -84: 
                                case -83: 
                                case -82: 
                                case -81: {
                                    ignorable = true;
                                    ptr += 3;
                                    continue block14;
                                }
                            }
                            return false;
                        }
                    }
                    return false;
                }
                case -17: {
                    ObjectChecker.checkTruncatedIgnorableUTF8(raw, ptr, end);
                    if (raw[ptr + 1] == -69 && raw[ptr + 2] == -65) {
                        ignorable = true;
                        ptr += 3;
                        continue block14;
                    }
                    return false;
                }
            }
            if (g == 4) {
                return false;
            }
            if (raw[ptr++] == git[g++]) continue;
            return false;
        }
        return g == 4 && ignorable;
    }

    private static void checkTruncatedIgnorableUTF8(byte[] raw, int ptr, int end) throws CorruptObjectException {
        if (ptr + 2 >= end) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidNameInvalidUtf8, ObjectChecker.toHexString(raw, ptr, end)));
        }
    }

    private static String toHexString(byte[] raw, int ptr, int end) {
        StringBuilder b = new StringBuilder("0x");
        for (int i = ptr; i < end; ++i) {
            b.append(String.format("%02x", raw[i]));
        }
        return b.toString();
    }

    private static void checkNotWindowsDevice(byte[] raw, int ptr, int end) throws CorruptObjectException {
        switch (ObjectChecker.toLower(raw[ptr])) {
            case 'a': {
                if (end - ptr < 3 || ObjectChecker.toLower(raw[ptr + 1]) != 'u' || ObjectChecker.toLower(raw[ptr + 2]) != 'x' || end - ptr != 3 && raw[ptr + 3] != 46) break;
                throw new CorruptObjectException(JGitText.get().corruptObjectInvalidNameAux);
            }
            case 'c': {
                if (end - ptr >= 3 && ObjectChecker.toLower(raw[ptr + 2]) == 'n' && ObjectChecker.toLower(raw[ptr + 1]) == 'o' && (end - ptr == 3 || raw[ptr + 3] == 46)) {
                    throw new CorruptObjectException(JGitText.get().corruptObjectInvalidNameCon);
                }
                if (end - ptr < 4 || ObjectChecker.toLower(raw[ptr + 2]) != 'm' || ObjectChecker.toLower(raw[ptr + 1]) != 'o' || !ObjectChecker.isPositiveDigit(raw[ptr + 3]) || end - ptr != 4 && raw[ptr + 4] != 46) break;
                throw new CorruptObjectException(String.format(JGitText.get().corruptObjectInvalidNameCom, Character.valueOf((char)raw[ptr + 3])));
            }
            case 'l': {
                if (end - ptr < 4 || ObjectChecker.toLower(raw[ptr + 1]) != 'p' || ObjectChecker.toLower(raw[ptr + 2]) != 't' || !ObjectChecker.isPositiveDigit(raw[ptr + 3]) || end - ptr != 4 && raw[ptr + 4] != 46) break;
                throw new CorruptObjectException(String.format(JGitText.get().corruptObjectInvalidNameLpt, Character.valueOf((char)raw[ptr + 3])));
            }
            case 'n': {
                if (end - ptr < 3 || ObjectChecker.toLower(raw[ptr + 1]) != 'u' || ObjectChecker.toLower(raw[ptr + 2]) != 'l' || end - ptr != 3 && raw[ptr + 3] != 46) break;
                throw new CorruptObjectException(JGitText.get().corruptObjectInvalidNameNul);
            }
            case 'p': {
                if (end - ptr < 3 || ObjectChecker.toLower(raw[ptr + 1]) != 'r' || ObjectChecker.toLower(raw[ptr + 2]) != 'n' || end - ptr != 3 && raw[ptr + 3] != 46) break;
                throw new CorruptObjectException(JGitText.get().corruptObjectInvalidNamePrn);
            }
        }
    }

    private static boolean isInvalidOnWindows(byte c) {
        switch (c) {
            case 34: 
            case 42: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 92: 
            case 124: {
                return true;
            }
        }
        return 1 <= c && c <= 31;
    }

    private static boolean isGit(byte[] buf, int p) {
        return ObjectChecker.toLower(buf[p]) == 'g' && ObjectChecker.toLower(buf[p + 1]) == 'i' && ObjectChecker.toLower(buf[p + 2]) == 't';
    }

    private static boolean isGitTilde1(byte[] buf, int p, int end) {
        if (end - p != 5) {
            return false;
        }
        return ObjectChecker.toLower(buf[p]) == 'g' && ObjectChecker.toLower(buf[p + 1]) == 'i' && ObjectChecker.toLower(buf[p + 2]) == 't' && buf[p + 3] == 126 && buf[p + 4] == 49;
    }

    private static boolean isNormalizedGit(byte[] raw, int ptr, int end) {
        if (ObjectChecker.isGit(raw, ptr)) {
            int p;
            int dots = 0;
            boolean space = false;
            for (p = end - 1; ptr + 2 < p; --p) {
                if (raw[p] == 46) {
                    ++dots;
                    continue;
                }
                if (raw[p] != 32) break;
                space = true;
            }
            return p == ptr + 2 && (dots == 1 || space);
        }
        return false;
    }

    private static char toLower(byte b) {
        if (65 <= b && b <= 90) {
            return (char)(b + 32);
        }
        return (char)b;
    }

    private static boolean isPositiveDigit(byte b) {
        return 49 <= b && b <= 57;
    }

    public void checkBlob(byte[] raw) throws CorruptObjectException {
    }

    private String normalize(byte[] raw, int ptr, int end) {
        String n = RawParseUtils.decode(raw, ptr, end).toLowerCase(Locale.US);
        return this.macosx ? Normalizer.normalize(n) : n;
    }

    private static class Normalizer {
        private static final Method normalize;
        private static final Object nfc;

        private Normalizer() {
        }

        static String normalize(String in) {
            if (normalize == null) {
                return in;
            }
            try {
                return (String)normalize.invoke(null, in, nfc);
            }
            catch (IllegalAccessException e) {
                return in;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                return in;
            }
        }

        static {
            Method method;
            Object formNfc;
            try {
                Class<?> formClazz = Class.forName("java.text.Normalizer$Form");
                formNfc = formClazz.getField("NFC").get(null);
                method = Class.forName("java.text.Normalizer").getMethod("normalize", CharSequence.class, formClazz);
            }
            catch (ClassNotFoundException e) {
                method = null;
                formNfc = null;
            }
            catch (NoSuchFieldException e) {
                method = null;
                formNfc = null;
            }
            catch (NoSuchMethodException e) {
                method = null;
                formNfc = null;
            }
            catch (SecurityException e) {
                method = null;
                formNfc = null;
            }
            catch (IllegalArgumentException e) {
                method = null;
                formNfc = null;
            }
            catch (IllegalAccessException e) {
                method = null;
                formNfc = null;
            }
            normalize = method;
            nfc = formNfc;
        }
    }
}

