/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks.restadapter;

import com.google.common.base.Objects;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.project.RESTTask;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RequiredPortWorkerGenerator {
    public static void generate(CommaFileSystemAccess fsa, Signature signature, RESTTask task) {
        fsa.generateFile(RequiredPortWorkerGenerator.workerFileName(signature), RequiredPortWorkerGenerator.workerClassContent(signature, task));
    }

    public static String workerFileName(Signature signature) {
        String _name = signature.getName();
        return String.valueOf(_name) + "Worker.java";
    }

    public static CharSequence workerClassContent(Signature signature, RESTTask task) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package org.eclipse.comma.restadapter;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import java.util.HashMap;");
        _builder.newLine();
        _builder.append("import org.eclipse.comma.restadapter.TestAppToSUT;");
        _builder.newLine();
        _builder.append("import com.google.gson.JsonElement;");
        _builder.newLine();
        _builder.append("import com.google.gson.JsonObject;");
        _builder.newLine();
        _builder.append("import com.google.gson.JsonPrimitive;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        String _name = signature.getName();
        _builder.append(_name);
        _builder.append("Worker {");
        _builder.newLineIfNotEmpty();
        EList _commands = signature.getCommands();
        for (Command command : _commands) {
            _builder.append("    ");
            _builder.append("protected static boolean result");
            String _name_1 = command.getName();
            _builder.append(_name_1, "    ");
            _builder.append(" = false;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        _builder.append("protected static HashMap<String, String> ");
        String _apiName = ProjectUtility.getApiName(task);
        _builder.append(_apiName, "    ");
        _builder.append("Results = new HashMap<String, String>(); ");
        _builder.newLineIfNotEmpty();
        EList _notifications = signature.getNotifications();
        for (Notification notification : _notifications) {
            _builder.append("    ");
            _builder.append("protected static boolean notification");
            String _name_2 = notification.getName();
            _builder.append(_name_2, "    ");
            _builder.append(" = false;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public ");
        String _name_3 = signature.getName();
        _builder.append(_name_3, "    ");
        _builder.append("Worker() {");
        _builder.newLineIfNotEmpty();
        EList _commands_1 = signature.getCommands();
        for (Command command_1 : _commands_1) {
            _builder.append("        ");
            String _apiName_1 = ProjectUtility.getApiName(task);
            _builder.append(_apiName_1, "        ");
            _builder.append("Results.put(\"");
            String _name_4 = command_1.getName();
            _builder.append(_name_4, "        ");
            _builder.append("\", \"\");");
            _builder.newLineIfNotEmpty();
        }
        EList _notifications_1 = signature.getNotifications();
        for (Notification notification_1 : _notifications_1) {
            _builder.append("        ");
            String _apiName_2 = ProjectUtility.getApiName(task);
            _builder.append(_apiName_2, "        ");
            _builder.append("Results.put(\"");
            String _name_5 = notification_1.getName();
            _builder.append(_name_5, "        ");
            _builder.append("\", \"\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public void executeEvent(JsonObject event) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("String method = event.get(\"method\").getAsString();");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("String result;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("JsonObject reply;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("JsonObject resultJson;");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("switch(method) {");
        _builder.newLine();
        EList _commands_2 = signature.getCommands();
        for (Command command_2 : _commands_2) {
            StringConcatenation _builder_1;
            _builder.append("        ");
            _builder.append("case \"");
            String _name_6 = command_2.getName();
            _builder.append(_name_6, "        ");
            _builder.append("\": // reply to ");
            String _name_7 = command_2.getName();
            _builder.append(_name_7, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            _builder.append("result = \"\";");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("    ");
            Functions.Function1 _function = it -> {
                DIRECTION _direction = it.getDirection();
                return Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
            };
            Iterable outParams = IterableExtensions.filter((Iterable)command_2.getParameters(), (Functions.Function1)_function);
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            boolean isVoid = TypeUtilities.isVoid((Type)command_2.getType());
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            int nrResultParams = 0;
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            StringConcatenation _xblockexpression = null;
            if (!isVoid) {
                // empty if block
            }
            _xblockexpression = _builder_1 = new StringConcatenation();
            _builder.append((Object)_xblockexpression, "            ");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            StringConcatenation _xblockexpression_1 = null;
            int _nrResultParams = ++nrResultParams;
            int _size = IterableExtensions.size((Iterable)outParams);
            nrResultParams = _nrResultParams + _size;
            StringConcatenation _builder_12 = new StringConcatenation();
            _xblockexpression_1 = _builder_12;
            _builder.append((Object)_xblockexpression_1, "            ");
            _builder.newLineIfNotEmpty();
            if (nrResultParams > 1) {
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("resultJson = new JsonObject();");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("    ");
                int counter = 0;
                _builder.newLineIfNotEmpty();
                for (Parameter p : outParams) {
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("JsonObject ");
                    String _name_8 = p.getName();
                    _builder.append(_name_8, "            ");
                    _builder.append(" = event.get(\"parameters\").getAsJsonArray().get(");
                    int _plusPlus = counter++;
                    _builder.append((Object)_plusPlus, "            ");
                    _builder.append(").getAsJsonObject();");
                    _builder.newLineIfNotEmpty();
                    Type _type = p.getType();
                    if (_type instanceof TypeReference) {
                        if (((TypeReference)p.getType()).getType() instanceof EnumTypeDecl || ((TypeReference)p.getType()).getType() instanceof SimpleTypeDecl) {
                            _builder.append("        ");
                            _builder.append("    ");
                            _builder.append("resultJson.addProperty(\"");
                            String _name_9 = p.getName();
                            _builder.append(_name_9, "            ");
                            _builder.append("\", ");
                            String _convertValueFromTestApp = RequiredPortWorkerGenerator.convertValueFromTestApp(p.getType(), p.getName());
                            _builder.append(_convertValueFromTestApp, "            ");
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("resultJson.add(\"");
                        String _name_10 = p.getName();
                        _builder.append(_name_10, "            ");
                        _builder.append("\", ");
                        String _convertValueFromTestApp_1 = RequiredPortWorkerGenerator.convertValueFromTestApp(p.getType(), p.getName());
                        _builder.append(_convertValueFromTestApp_1, "            ");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("resultJson.add(\"");
                    String _name_11 = p.getName();
                    _builder.append(_name_11, "            ");
                    _builder.append("\", ");
                    String _convertValueFromTestApp_2 = RequiredPortWorkerGenerator.convertValueFromTestApp(p.getType(), p.getName());
                    _builder.append(_convertValueFromTestApp_2, "            ");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
                if (!isVoid) {
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("reply = event.get(\"parameters\").getAsJsonArray().get(");
                    _builder.append((Object)counter, "            ");
                    _builder.append(").getAsJsonObject();");
                    _builder.newLineIfNotEmpty();
                    Type _type_1 = command_2.getType();
                    if (_type_1 instanceof TypeReference) {
                        if (((TypeReference)command_2.getType()).getType() instanceof EnumTypeDecl || ((TypeReference)command_2.getType()).getType() instanceof SimpleTypeDecl) {
                            _builder.append("        ");
                            _builder.append("    ");
                            _builder.append("replyConverted = new JsonPrimitive(");
                            String _convertValueFromTestApp_3 = RequiredPortWorkerGenerator.convertValueFromTestApp(command_2.getType(), "reply");
                            _builder.append(_convertValueFromTestApp_3, "            ");
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                            _builder.append("        ");
                            _builder.append("    ");
                            _builder.append("resultJson.addProperty(\"result\", ");
                            String _convertValueFromTestApp_4 = RequiredPortWorkerGenerator.convertValueFromTestApp(command_2.getType(), "reply");
                            _builder.append(_convertValueFromTestApp_4, "            ");
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append("        ");
                            _builder.append("    ");
                            _builder.append("resultJson.add(\"result\", ");
                            String _convertValueFromTestApp_5 = RequiredPortWorkerGenerator.convertValueFromTestApp(command_2.getType(), "reply");
                            _builder.append(_convertValueFromTestApp_5, "            ");
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                        }
                    } else {
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("resultJson.add(\"result\", ");
                        String _convertValueFromTestApp_6 = RequiredPortWorkerGenerator.convertValueFromTestApp(command_2.getType(), "reply");
                        _builder.append(_convertValueFromTestApp_6, "            ");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("result = resultJson.toString();");
                    _builder.newLine();
                }
            } else if (nrResultParams == 1) {
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("reply = event.get(\"parameters\").getAsJsonArray().get(0).getAsJsonObject();");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("    ");
                Type _xifexpression = null;
                _xifexpression = !isVoid ? command_2.getType() : ((Parameter[])Conversions.unwrapArray((Object)outParams, Parameter.class))[0].getType();
                Type type = _xifexpression;
                _builder.newLineIfNotEmpty();
                if (type instanceof TypeReference) {
                    if (((TypeReference)type).getType() instanceof EnumTypeDecl || ((TypeReference)type).getType() instanceof SimpleTypeDecl) {
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("result = ");
                        String _convertValueFromTestApp_7 = RequiredPortWorkerGenerator.convertValueFromTestApp(type, "reply");
                        _builder.append(_convertValueFromTestApp_7, "            ");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("result = ");
                        String _convertValueFromTestApp_8 = RequiredPortWorkerGenerator.convertValueFromTestApp(type, "reply");
                        _builder.append(_convertValueFromTestApp_8, "            ");
                        _builder.append(".toString();");
                        _builder.newLineIfNotEmpty();
                    }
                } else {
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("result = ");
                    String _convertValueFromTestApp_9 = RequiredPortWorkerGenerator.convertValueFromTestApp(type, "reply");
                    _builder.append(_convertValueFromTestApp_9, "            ");
                    _builder.append(".toString();");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("        ");
            _builder.append("    ");
            String _apiName_3 = ProjectUtility.getApiName(task);
            _builder.append(_apiName_3, "            ");
            _builder.append("Results.put(\"");
            String _name_12 = command_2.getName();
            _builder.append(_name_12, "            ");
            _builder.append("\", result);");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            _builder.append("result");
            String _name_13 = command_2.getName();
            _builder.append(_name_13, "            ");
            _builder.append(" = true;");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            _builder.append("break;");
            _builder.newLine();
        }
        EList _notifications_2 = signature.getNotifications();
        for (Notification notification_2 : _notifications_2) {
            boolean _not;
            _builder.append("        ");
            _builder.append("case \"");
            String _name_14 = notification_2.getName();
            _builder.append(_name_14, "        ");
            _builder.append("\": // notification ");
            String _name_15 = notification_2.getName();
            _builder.append(_name_15, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            _builder.append("result = \"\";");
            _builder.newLine();
            boolean _isEmpty = notification_2.getParameters().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("resultJson = new JsonObject();");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("    ");
                int counter_1 = 0;
                _builder.newLineIfNotEmpty();
                EList _parameters = notification_2.getParameters();
                for (Parameter p_1 : _parameters) {
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("JsonObject ");
                    String _name_16 = p_1.getName();
                    _builder.append(_name_16, "            ");
                    _builder.append(" = event.get(\"parameters\").getAsJsonArray().get(");
                    int _plusPlus_1 = counter_1++;
                    _builder.append((Object)_plusPlus_1, "            ");
                    _builder.append(").getAsJsonObject();");
                    _builder.newLineIfNotEmpty();
                    Type _type_2 = p_1.getType();
                    if (_type_2 instanceof TypeReference) {
                        if (((TypeReference)p_1.getType()).getType() instanceof EnumTypeDecl || ((TypeReference)p_1.getType()).getType() instanceof SimpleTypeDecl) {
                            _builder.append("        ");
                            _builder.append("    ");
                            _builder.append("resultJson.addProperty(\"");
                            String _name_17 = p_1.getName();
                            _builder.append(_name_17, "            ");
                            _builder.append("\", ");
                            String _convertValueFromTestApp_10 = RequiredPortWorkerGenerator.convertValueFromTestApp(p_1.getType(), p_1.getName());
                            _builder.append(_convertValueFromTestApp_10, "            ");
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        _builder.append("        ");
                        _builder.append("    ");
                        _builder.append("resultJson.add(\"");
                        String _name_18 = p_1.getName();
                        _builder.append(_name_18, "            ");
                        _builder.append("\", ");
                        String _convertValueFromTestApp_11 = RequiredPortWorkerGenerator.convertValueFromTestApp(p_1.getType(), p_1.getName());
                        _builder.append(_convertValueFromTestApp_11, "            ");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("resultJson.add(\"");
                    String _name_19 = p_1.getName();
                    _builder.append(_name_19, "            ");
                    _builder.append("\", ");
                    String _convertValueFromTestApp_12 = RequiredPortWorkerGenerator.convertValueFromTestApp(p_1.getType(), p_1.getName());
                    _builder.append(_convertValueFromTestApp_12, "            ");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("result = resultJson.toString();");
                _builder.newLine();
            }
            _builder.append("        ");
            _builder.append("    ");
            String _apiName_4 = ProjectUtility.getApiName(task);
            _builder.append(_apiName_4, "            ");
            _builder.append("Results.put(\"");
            String _name_20 = notification_2.getName();
            _builder.append(_name_20, "            ");
            _builder.append("\", result);");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            _builder.append("notification");
            String _name_21 = notification_2.getName();
            _builder.append(_name_21, "            ");
            _builder.append(" = true;");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            _builder.append("break; ");
            _builder.newLine();
        }
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static String convertValueFromTestApp(Type type, String expression) {
        if (type instanceof TypeReference) {
            TypeDecl _type_3;
            TypeDecl _type = ((TypeReference)type).getType();
            if (_type instanceof EnumTypeDecl) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("TestAppToSUT.convertEnum(");
                _builder.append(expression);
                _builder.append(")");
                return _builder.toString();
            }
            TypeDecl _type_1 = ((TypeReference)type).getType();
            if (_type_1 instanceof SimpleTypeDecl) {
                boolean _equals;
                boolean _tripleNotEquals;
                TypeDecl _type_2 = ((TypeReference)type).getType();
                SimpleTypeDecl _t = (SimpleTypeDecl)_type_2;
                SimpleTypeDecl _base = _t.getBase();
                boolean bl = _tripleNotEquals = _base != null;
                if (_tripleNotEquals) {
                    _t = _t.getBase();
                }
                if (_equals = _t.getName().equals("int")) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("TestAppToSUT.convertInt(");
                    _builder_1.append(expression);
                    _builder_1.append(")");
                    return _builder_1.toString();
                }
                boolean _equals_1 = _t.getName().equals("string");
                if (_equals_1) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("TestAppToSUT.convertString(");
                    _builder_2.append(expression);
                    _builder_2.append(")");
                    return _builder_2.toString();
                }
                boolean _equals_2 = _t.getName().equals("real");
                if (_equals_2) {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("TestAppToSUT.convertReal(");
                    _builder_3.append(expression);
                    _builder_3.append(")");
                    return _builder_3.toString();
                }
                boolean _equals_3 = _t.getName().equals("bool");
                if (_equals_3) {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("TestAppToSUT.convertBool(");
                    _builder_4.append(expression);
                    _builder_4.append(")");
                    return _builder_4.toString();
                }
            }
            if ((_type_3 = ((TypeReference)type).getType()) instanceof RecordTypeDecl) {
                StringConcatenation _builder_5 = new StringConcatenation();
                _builder_5.append("TestAppToSUT.convertRecordToJson(");
                _builder_5.append(expression);
                _builder_5.append(")");
                return _builder_5.toString();
            }
            TypeDecl _type_4 = ((TypeReference)type).getType();
            if (_type_4 instanceof VectorTypeDecl) {
                StringConcatenation _builder_6 = new StringConcatenation();
                _builder_6.append("TestAppToSUT.convertVectorValue(");
                _builder_6.append(expression);
                _builder_6.append(")");
                return _builder_6.toString();
            }
        } else if (type instanceof VectorTypeConstructor) {
            StringConcatenation _builder_7 = new StringConcatenation();
            _builder_7.append("TestAppToSUT.convertVectorValue(");
            _builder_7.append(expression);
            _builder_7.append(")");
            return _builder_7.toString();
        }
        StringConcatenation _builder_8 = new StringConcatenation();
        _builder_8.append("Unsuppoted type of path parameter");
        return _builder_8.toString();
    }
}

