/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching.sourcelookup.advanced;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.AdvancedSourceLookupSupport;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.CompositeSourceContainer;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.IJDIHelpers;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.WorkspaceProjectSourceContainers;
import org.eclipse.jdt.launching.sourcelookup.advanced.ISourceContainerResolver;

public class AdvancedSourceLookupParticipant
implements ISourceLookupParticipant {
    private final IJDIHelpers jdi;
    private ISourceLookupDirector director;
    private final Map<File, ISourceContainer> containers = new HashMap<File, ISourceContainer>();

    public AdvancedSourceLookupParticipant() {
        this(IJDIHelpers.INSTANCE);
    }

    public AdvancedSourceLookupParticipant(IJDIHelpers jdi) {
        this.jdi = jdi;
    }

    public void init(ISourceLookupDirector director) {
        this.director = director;
    }

    public Object[] findSourceElements(Object element) throws CoreException {
        ISourceContainer container = this.getSourceContainer(element, false, null);
        if (container == null) {
            return null;
        }
        String sourcePath = this.jdi.getSourcePath(element);
        if (sourcePath == null) {
            return null;
        }
        return container.findSourceElements(sourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISourceContainer getSourceContainer(Object element, boolean refresh, IProgressMonitor monitor) throws CoreException {
        File location = this.jdi.getClassesLocation(element);
        if (location == null) {
            return null;
        }
        Map<File, ISourceContainer> map = this.containers;
        synchronized (map) {
            if (!refresh && this.containers.containsKey(location)) {
                return this.containers.get(location);
            }
        }
        monitor = AdvancedSourceLookupSupport.getContextMonitor(monitor);
        WorkspaceProjectSourceContainers projectLocator = AdvancedSourceLookupSupport.getWorkspaceJavaProjects(monitor);
        if (monitor == null && projectLocator == null) {
            AdvancedSourceLookupSupport.schedule(m -> {
                ISourceContainer iSourceContainer = this.getSourceContainer(element, refresh, m);
            });
            return null;
        }
        if (projectLocator == null) {
            return null;
        }
        ISourceContainer projectContainer = projectLocator.createProjectContainer(location);
        if (projectContainer != null) {
            return this.cacheContainer(element, location, projectContainer);
        }
        for (File frameLocation : this.jdi.getStackFramesClassesLocations(element)) {
            ISourceContainer entryContainer = projectLocator.createClasspathEntryContainer(frameLocation, location);
            if (entryContainer == null) continue;
            return this.cacheContainer(element, location, entryContainer);
        }
        if (monitor == null) {
            AdvancedSourceLookupSupport.schedule(m -> {
                ISourceContainer iSourceContainer = this.getSourceContainer(element, refresh, m);
            });
            return null;
        }
        for (ISourceContainerResolver repository : this.getSourceContainerResolvers()) {
            Collection<ISourceContainer> members = repository.resolveSourceContainers(location, monitor);
            if (members == null || members.isEmpty()) continue;
            return this.cacheContainer(element, location, CompositeSourceContainer.compose(members));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISourceContainer cacheContainer(Object element, File location, ISourceContainer container) {
        ISourceContainer oldContainer;
        Map<File, ISourceContainer> map = this.containers;
        synchronized (map) {
            oldContainer = this.containers.put(location, container);
            if (oldContainer != null) {
                oldContainer.dispose();
            }
        }
        if (oldContainer != null || container != null) {
            this.updateDebugElement(element);
        }
        return container;
    }

    protected Collection<ISourceContainerResolver> getSourceContainerResolvers() {
        IConfigurationElement[] elements;
        ArrayList<ISourceContainerResolver> result = new ArrayList<ISourceContainerResolver>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.jdt.launching.sourceContainerResolvers");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("resolver".equals(element.getName())) {
                try {
                    result.add((ISourceContainerResolver)element.createExecutableExtension("class"));
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        return result;
    }

    public String getSourceName(Object object) throws CoreException {
        return null;
    }

    public void dispose() {
        this.disposeContainers();
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
        this.disposeContainers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeContainers() {
        Map<File, ISourceContainer> map = this.containers;
        synchronized (map) {
            for (ISourceContainer container : this.containers.values()) {
                if (container == null) continue;
                container.dispose();
            }
            this.containers.clear();
        }
    }

    private void updateDebugElement(Object element) {
        this.director.clearSourceElements(element);
        if (element instanceof DebugElement) {
            ((DebugElement)element).fireChangeEvent(512);
        }
    }

    public static AdvancedSourceLookupParticipant getSourceLookup(Object element) {
        ISourceLocator sourceLocator = null;
        if (element instanceof IDebugElement) {
            sourceLocator = ((IDebugElement)element).getLaunch().getSourceLocator();
        }
        AdvancedSourceLookupParticipant sourceLookup = null;
        if (sourceLocator instanceof ISourceLookupDirector) {
            ISourceLookupParticipant[] iSourceLookupParticipantArray = ((ISourceLookupDirector)sourceLocator).getParticipants();
            int n = iSourceLookupParticipantArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceLookupParticipant participant = iSourceLookupParticipantArray[n2];
                if (participant instanceof AdvancedSourceLookupParticipant) {
                    sourceLookup = (AdvancedSourceLookupParticipant)participant;
                    break;
                }
                ++n2;
            }
        }
        return sourceLookup;
    }
}

