/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.samples;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.ui.launcher.EclipseLaunchShortcut;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.config.IStandbyContentPart;
import org.eclipse.ui.part.ISetSelectionTarget;

public class SampleStandbyContent
implements IStandbyContentPart {
    private ScrolledForm form;
    private Hyperlink moreLink;
    private String helpURL;
    private String launcher;
    private String launchTarget;
    private FormText descText;
    private FormText instText;
    private ILaunchShortcut defaultShortcut = new EclipseLaunchShortcut();
    private IConfigurationElement sample;
    private String input;
    private static String MEMENTO_SAMPLE_ID_ATT = "sampleId";

    public SampleStandbyContent() {
        PDEPlugin.getDefault().getLabelProvider().connect(this);
    }

    public void createPartControl(Composite parent, FormToolkit toolkit) {
        this.form = toolkit.createScrolledForm(parent);
        TableWrapLayout layout = new TableWrapLayout();
        layout.verticalSpacing = 10;
        layout.topMargin = 10;
        layout.bottomMargin = 10;
        layout.leftMargin = 10;
        layout.rightMargin = 10;
        this.form.getBody().setLayout((Layout)layout);
        this.descText = toolkit.createFormText(this.form.getBody(), true);
        this.descText.setLayoutData((Object)new TableWrapData(256));
        this.descText.setText("", false, false);
        this.moreLink = toolkit.createHyperlink(this.form.getBody(), "Read More", 0);
        this.moreLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (SampleStandbyContent.this.helpURL != null) {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(SampleStandbyContent.this.helpURL);
                }
            }
        });
        this.instText = toolkit.createFormText(this.form.getBody(), true);
        this.instText.setLayoutData((Object)new TableWrapData(256));
        StringBuilder buf = new StringBuilder();
        buf.append(PDEUIMessages.SampleStandbyContent_content);
        this.instText.setText(buf.toString(), true, false);
        this.instText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Object href = e.getHref();
                if (href.equals("help")) {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(SampleStandbyContent.this.helpURL);
                } else if (href.equals("browse")) {
                    SampleStandbyContent.this.doBrowse();
                } else if (href.equals("run")) {
                    SampleStandbyContent.this.doRun(SampleStandbyContent.this.launcher, SampleStandbyContent.this.launchTarget, false);
                } else if (href.equals("debug")) {
                    SampleStandbyContent.this.doRun(SampleStandbyContent.this.launcher, SampleStandbyContent.this.launchTarget, true);
                }
            }
        });
        this.instText.setImage("run", PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_RUN_EXC));
        this.instText.setImage("debug", PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_DEBUG_EXC));
        this.instText.setImage("help", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
    }

    private void doRun(String launcher, String target, boolean debug) {
        ILaunchShortcut shortcut = this.defaultShortcut;
        StructuredSelection selection = target != null ? new StructuredSelection() : new StructuredSelection();
        ILaunchShortcut fshortcut = shortcut;
        BusyIndicator.showWhile((Display)this.form.getDisplay(), () -> SampleStandbyContent.lambda$0(fshortcut, (ISelection)selection, debug));
    }

    private void doBrowse() {
        IWorkspaceRoot root = PDEPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        ISetSelectionTarget target = this.findTarget();
        if (target == null) {
            return;
        }
        String sid = this.sample.getAttribute("id");
        if (sid == null) {
            return;
        }
        ArrayList<IResource> items = new ArrayList<IResource>();
        int i = 0;
        while (i < projects.length) {
            IFile pfile;
            IProject project = projects[i];
            if (project.exists() && project.isOpen() && (pfile = project.getFile("sample.properties")).exists()) {
                try {
                    Throwable throwable = null;
                    Object var10_12 = null;
                    try (InputStream is = pfile.getContents();){
                        IResource res;
                        Properties prop = new Properties();
                        prop.load(is);
                        String id = prop.getProperty("id");
                        if (id != null && id.equals(sid) && (res = this.findSelectReveal(project, prop.getProperty("projectName"))) != null) {
                            items.add(res);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
            ++i;
        }
        if (!items.isEmpty()) {
            target.selectReveal((ISelection)new StructuredSelection(items));
        }
    }

    private ISetSelectionTarget findTarget() {
        String id = this.sample.getAttribute("targetViewId");
        if (id == null) {
            return null;
        }
        IViewPart view = PDEPlugin.getActivePage().findView(id);
        if (view == null || !(view instanceof ISetSelectionTarget)) {
            return null;
        }
        return (ISetSelectionTarget)view;
    }

    private IResource findSelectReveal(IProject project, String originalName) {
        IConfigurationElement[] projects = this.sample.getChildren("project");
        int i = 0;
        while (i < projects.length) {
            IResource res;
            String path;
            if (originalName.equals(projects[i].getAttribute("name")) && (path = projects[i].getAttribute("selectReveal")) != null && (res = project.findMember(path)) != null && res.exists()) {
                return res;
            }
            ++i;
        }
        return null;
    }

    public Control getControl() {
        return this.form;
    }

    public void init(IIntroPart introPart) {
    }

    public void setInput(Object input) {
        if (input != null) {
            this.input = (String)input;
        }
        String sampleId = this.input.toString();
        IConfigurationElement[] samples = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.pde.ui.samples");
        int i = 0;
        while (i < samples.length) {
            IConfigurationElement sample = samples[i];
            String id = sample.getAttribute("id");
            if (id != null && id.equals(sampleId)) {
                this.update(sample);
                return;
            }
            ++i;
        }
        this.update(null);
    }

    private void update(IConfigurationElement sample) {
        IConfigurationElement[] descConfig;
        this.sample = sample;
        if (this.form == null) {
            return;
        }
        String title = sample != null ? sample.getAttribute("name") : "";
        this.form.setText(title);
        if (sample != null) {
            this.launcher = sample.getAttribute("launcher");
            this.launchTarget = sample.getAttribute("launchTarget");
        } else {
            this.launcher = null;
            this.launchTarget = null;
        }
        IConfigurationElement[] iConfigurationElementArray = descConfig = sample != null ? sample.getChildren("description") : null;
        if (descConfig != null && descConfig.length == 1) {
            String desc = descConfig[0].getValue();
            String content = NLS.bind((String)PDEUIMessages.SampleStandbyContent_desc, (Object)(desc != null ? desc : ""));
            this.helpURL = descConfig[0].getAttribute("helpHref");
            this.moreLink.setVisible(this.helpURL != null);
            this.descText.setText(content, true, false);
        } else {
            this.moreLink.setVisible(false);
            this.descText.setText("", false, false);
        }
        this.form.reflow(true);
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
    }

    public void init(IIntroPart introPart, IMemento memento) {
        this.input = this.getCachedInput(memento);
    }

    private String getCachedInput(IMemento memento) {
        if (memento == null) {
            return null;
        }
        return memento.getString(MEMENTO_SAMPLE_ID_ATT);
    }

    public void saveState(IMemento memento) {
        String currentSampleId = this.input;
        if (this.input != null) {
            memento.putString(MEMENTO_SAMPLE_ID_ATT, currentSampleId);
        }
    }

    private static /* synthetic */ void lambda$0(ILaunchShortcut iLaunchShortcut, ISelection iSelection, boolean bl) {
        iLaunchShortcut.launch(iSelection, bl ? "debug" : "run");
    }
}

