/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import java.io.IOException;
import org.apache.poi.hwmf.draw.HwmfGraphics;
import org.apache.poi.hwmf.record.HwmfRecord;
import org.apache.poi.hwmf.record.HwmfRecordType;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndianInputStream;

public class HwmfEscape
implements HwmfRecord {
    private EscapeFunction escapeFunction;
    private int byteCount;
    private byte[] escapeData;

    @Override
    public HwmfRecordType getWmfRecordType() {
        return HwmfRecordType.escape;
    }

    @Override
    public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
        this.escapeFunction = EscapeFunction.valueOf(leis.readUShort());
        this.byteCount = leis.readUShort();
        this.escapeData = IOUtils.toByteArray(leis, this.byteCount);
        return 4 + this.byteCount;
    }

    @Override
    public void draw(HwmfGraphics ctx) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("escape - function: " + (Object)((Object)this.escapeFunction) + "\n");
        sb.append(HexDump.dump(this.escapeData, 0L, 0));
        return sb.toString();
    }

    public static enum EscapeFunction {
        NEWFRAME(1),
        ABORTDOC(2),
        NEXTBAND(3),
        SETCOLORTABLE(4),
        GETCOLORTABLE(5),
        FLUSHOUT(6),
        DRAFTMODE(7),
        QUERYESCSUPPORT(8),
        SETABORTPROC(9),
        STARTDOC(10),
        ENDDOC(11),
        GETPHYSPAGESIZE(12),
        GETPRINTINGOFFSET(13),
        GETSCALINGFACTOR(14),
        META_ESCAPE_ENHANCED_METAFILE(15),
        SETPENWIDTH(16),
        SETCOPYCOUNT(17),
        SETPAPERSOURCE(18),
        PASSTHROUGH(19),
        GETTECHNOLOGY(20),
        SETLINECAP(21),
        SETLINEJOIN(22),
        SETMITERLIMIT(23),
        BANDINFO(24),
        DRAWPATTERNRECT(25),
        GETVECTORPENSIZE(26),
        GETVECTORBRUSHSIZE(27),
        ENABLEDUPLEX(28),
        GETSETPAPERBINS(29),
        GETSETPRINTORIENT(30),
        ENUMPAPERBINS(31),
        SETDIBSCALING(32),
        EPSPRINTING(33),
        ENUMPAPERMETRICS(34),
        GETSETPAPERMETRICS(35),
        POSTSCRIPT_DATA(37),
        POSTSCRIPT_IGNORE(38),
        GETDEVICEUNITS(42),
        GETEXTENDEDTEXTMETRICS(256),
        GETPAIRKERNTABLE(258),
        EXTTEXTOUT(512),
        GETFACENAME(513),
        DOWNLOADFACE(514),
        METAFILE_DRIVER(2049),
        QUERYDIBSUPPORT(3073),
        BEGIN_PATH(4096),
        CLIP_TO_PATH(4097),
        END_PATH(4098),
        OPEN_CHANNEL(4110),
        DOWNLOADHEADER(4111),
        CLOSE_CHANNEL(4112),
        POSTSCRIPT_PASSTHROUGH(4115),
        ENCAPSULATED_POSTSCRIPT(4116),
        POSTSCRIPT_IDENTIFY(4117),
        POSTSCRIPT_INJECTION(4118),
        CHECKJPEGFORMAT(4119),
        CHECKPNGFORMAT(4120),
        GET_PS_FEATURESETTING(4121),
        MXDC_ESCAPE(4122),
        SPCLPASSTHROUGH2(4568);

        int flag;

        private EscapeFunction(int flag) {
            this.flag = flag;
        }

        static EscapeFunction valueOf(int flag) {
            for (EscapeFunction hs : EscapeFunction.values()) {
                if (hs.flag != flag) continue;
                return hs;
            }
            return null;
        }
    }
}

