/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.generator;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.List;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionAddition;
import org.eclipse.comma.expressions.expression.ExpressionAnd;
import org.eclipse.comma.expressions.expression.ExpressionAny;
import org.eclipse.comma.expressions.expression.ExpressionBracket;
import org.eclipse.comma.expressions.expression.ExpressionBulkData;
import org.eclipse.comma.expressions.expression.ExpressionConstantBool;
import org.eclipse.comma.expressions.expression.ExpressionConstantInt;
import org.eclipse.comma.expressions.expression.ExpressionConstantReal;
import org.eclipse.comma.expressions.expression.ExpressionConstantString;
import org.eclipse.comma.expressions.expression.ExpressionDivision;
import org.eclipse.comma.expressions.expression.ExpressionEnumLiteral;
import org.eclipse.comma.expressions.expression.ExpressionEqual;
import org.eclipse.comma.expressions.expression.ExpressionFunctionCall;
import org.eclipse.comma.expressions.expression.ExpressionGeq;
import org.eclipse.comma.expressions.expression.ExpressionGreater;
import org.eclipse.comma.expressions.expression.ExpressionLeq;
import org.eclipse.comma.expressions.expression.ExpressionLess;
import org.eclipse.comma.expressions.expression.ExpressionMap;
import org.eclipse.comma.expressions.expression.ExpressionMapRW;
import org.eclipse.comma.expressions.expression.ExpressionMaximum;
import org.eclipse.comma.expressions.expression.ExpressionMinimum;
import org.eclipse.comma.expressions.expression.ExpressionMinus;
import org.eclipse.comma.expressions.expression.ExpressionModulo;
import org.eclipse.comma.expressions.expression.ExpressionMultiply;
import org.eclipse.comma.expressions.expression.ExpressionNEqual;
import org.eclipse.comma.expressions.expression.ExpressionNot;
import org.eclipse.comma.expressions.expression.ExpressionOr;
import org.eclipse.comma.expressions.expression.ExpressionPlus;
import org.eclipse.comma.expressions.expression.ExpressionPower;
import org.eclipse.comma.expressions.expression.ExpressionRecord;
import org.eclipse.comma.expressions.expression.ExpressionRecordAccess;
import org.eclipse.comma.expressions.expression.ExpressionSubtraction;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.ExpressionVector;
import org.eclipse.comma.expressions.expression.Field;
import org.eclipse.comma.expressions.expression.Pair;
import org.eclipse.comma.expressions.validation.ExpressionValidator;
import org.eclipse.comma.monitoring.generator.CommaScope;
import org.eclipse.comma.monitoring.generator.TypesJavaGenerator;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.TypeObject;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public abstract class ExpressionsJavaGenerator
extends TypesJavaGenerator {
    protected static final String VAR_NAME_PREFIX = "commaVar_";
    protected static final String TVAR_NAME_PREFIX = "commaTVar_";
    protected static final String QVAR_NAME_PREFIX = "commaQVar_";

    protected CharSequence _generateExpression(ExpressionAddition expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(" + ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionAnd expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(" && ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionBracket expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _generateExpression = this.generateExpression(expr.getSub());
        _builder.append((Object)_generateExpression);
        _builder.append(") ");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionConstantBool expr) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isValue = expr.isValue();
        _builder.append((Object)_isValue);
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionConstantReal expr) {
        StringConcatenation _builder = new StringConcatenation();
        double _value = expr.getValue();
        _builder.append((Object)_value);
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionConstantInt expr) {
        StringConcatenation _builder = new StringConcatenation();
        long _value = expr.getValue();
        _builder.append((Object)_value);
        _builder.append("L");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionConstantString expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        String _value = expr.getValue();
        _builder.append(_value);
        _builder.append("\"");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionAny expr) {
        StringConcatenation _builder = new StringConcatenation();
        EObject _eContainer = expr.eContainer();
        if (_eContainer instanceof Field) {
            _builder.append("null");
        } else {
            _builder.append("(new CAny())");
        }
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionDivision expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(" / ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionEqual expr) {
        StringConcatenation _xblockexpression = null;
        ExpressionValidator validator = new ExpressionValidator();
        TypeObject type = validator.typeOf(expr.getLeft());
        if (type instanceof SimpleTypeDecl) {
            boolean _not;
            boolean _and = false;
            boolean _equals = ((SimpleTypeDecl)type).getName().equals("string");
            boolean bl = _not = !_equals;
            if (!_not) {
                _and = false;
            } else {
                boolean _equals_1;
                boolean _tripleNotEquals;
                boolean _xifexpression = false;
                SimpleTypeDecl _base = ((SimpleTypeDecl)type).getBase();
                boolean bl2 = _tripleNotEquals = _base != null;
                _xifexpression = _tripleNotEquals ? !(_equals_1 = ((SimpleTypeDecl)type).getBase().getName().equals("string")) : true;
                _and = _xifexpression;
            }
            if (_and) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("(");
                CharSequence _generateExpression = this.generateExpression(expr.getLeft());
                _builder.append((Object)_generateExpression);
                _builder.append(" == ");
                CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
                _builder.append((Object)_generateExpression_1);
                _builder.append(")");
                return _builder;
            }
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        CharSequence _generateExpression_2 = this.generateExpression(expr.getLeft());
        _builder_1.append((Object)_generateExpression_2);
        _builder_1.append(".equals(");
        CharSequence _generateExpression_3 = this.generateExpression(expr.getRight());
        _builder_1.append((Object)_generateExpression_3);
        _builder_1.append(")");
        _xblockexpression = _builder_1;
        return _xblockexpression;
    }

    protected CharSequence _generateExpression(ExpressionGeq expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(" >= ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionGreater expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(" > ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionLeq expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(" <= ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionLess expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(" < ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionMaximum expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Math.max(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(", ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionMinimum expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Math.min(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(", ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionMinus expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(-");
        CharSequence _generateExpression = this.generateExpression(expr.getSub());
        _builder.append((Object)_generateExpression);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionModulo expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(" % ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionMultiply expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(" * ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionNEqual expr) {
        StringConcatenation _xblockexpression = null;
        ExpressionValidator validator = new ExpressionValidator();
        TypeObject type = validator.typeOf(expr.getLeft());
        if (type instanceof SimpleTypeDecl) {
            boolean _not;
            boolean _and = false;
            boolean _equals = ((SimpleTypeDecl)type).getName().equals("string");
            boolean bl = _not = !_equals;
            if (!_not) {
                _and = false;
            } else {
                boolean _equals_1;
                boolean _tripleNotEquals;
                boolean _xifexpression = false;
                SimpleTypeDecl _base = ((SimpleTypeDecl)type).getBase();
                boolean bl2 = _tripleNotEquals = _base != null;
                _xifexpression = _tripleNotEquals ? !(_equals_1 = ((SimpleTypeDecl)type).getBase().getName().equals("string")) : true;
                _and = _xifexpression;
            }
            if (_and) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("(");
                CharSequence _generateExpression = this.generateExpression(expr.getLeft());
                _builder.append((Object)_generateExpression);
                _builder.append(" != ");
                CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
                _builder.append((Object)_generateExpression_1);
                _builder.append(")");
                return _builder;
            }
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("!");
        CharSequence _generateExpression_2 = this.generateExpression(expr.getLeft());
        _builder_1.append((Object)_generateExpression_2);
        _builder_1.append(".equals(");
        CharSequence _generateExpression_3 = this.generateExpression(expr.getRight());
        _builder_1.append((Object)_generateExpression_3);
        _builder_1.append(")");
        _xblockexpression = _builder_1;
        return _xblockexpression;
    }

    protected CharSequence _generateExpression(ExpressionNot expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("!(");
        CharSequence _generateExpression = this.generateExpression(expr.getSub());
        _builder.append((Object)_generateExpression);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionOr expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(" || ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionPlus expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateExpression = this.generateExpression(expr.getSub());
        _builder.append((Object)_generateExpression);
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionPower expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Math.pow(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(", ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionSubtraction expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(" - ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionVariable expr) {
        return this.generateVariableReference(expr);
    }

    public CharSequence generateVariableReference(ExpressionVariable expr) {
        StringConcatenation _switchResult = null;
        CommaScope _commaScope = this.getCommaScope((EObject)expr.getVariable());
        if (_commaScope != null) {
            switch (_commaScope) {
                case GLOBAL: {
                    StringConcatenation _xifexpression = null;
                    if (Objects.equal((Object)((Object)this.getCommaScope((EObject)expr)), (Object)((Object)CommaScope.GLOBAL)) || Objects.equal((Object)((Object)this.getCommaScope((EObject)expr)), (Object)((Object)CommaScope.QUANTIFIER))) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append(VAR_NAME_PREFIX);
                        String _name = expr.getVariable().getName();
                        _builder.append(_name);
                        _xifexpression = _builder;
                    } else {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("stateOfDecisionClass.get_");
                        _builder_1.append(VAR_NAME_PREFIX);
                        String _name_1 = expr.getVariable().getName();
                        _builder_1.append(_name_1);
                        _builder_1.append("()");
                        _xifexpression = _builder_1;
                    }
                    _switchResult = _xifexpression;
                    break;
                }
                case TRANSITION: {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append(TVAR_NAME_PREFIX);
                    String _name_2 = expr.getVariable().getName();
                    _builder_2.append(_name_2);
                    _switchResult = _builder_2;
                    break;
                }
                case QUANTIFIER: {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append(QVAR_NAME_PREFIX);
                    String _name_3 = expr.getVariable().getName();
                    _builder_3.append(_name_3);
                    _switchResult = _builder_3;
                    break;
                }
            }
        }
        return _switchResult;
    }

    protected CharSequence _generateExpression(ExpressionEnumLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(new CEnumValue(\"");
        String _name = expr.getType().getName();
        _builder.append(_name);
        _builder.append("::");
        String _name_1 = expr.getLiteral().getName();
        _builder.append(_name_1);
        _builder.append("\"))");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionBulkData expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(new CBulkdata(");
        int _size = expr.getSize();
        _builder.append((Object)_size);
        _builder.append("))");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionRecord expr) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        RecordTypeDecl _parent = expr.getType().getParent();
        boolean bl = _tripleNotEquals = _parent != null;
        if (_tripleNotEquals) {
            _builder.append("(");
            CharSequence _javaType = this.toJavaType((EObject)expr.getType());
            _builder.append((Object)_javaType);
            _builder.append(") ");
        }
        _builder.append("new ");
        CharSequence _javaType_1 = this.toJavaType((EObject)expr.getType());
        _builder.append((Object)_javaType_1);
        _builder.append("()");
        List _reverseView = ListExtensions.reverseView((List)expr.getFields());
        for (Field f : _reverseView) {
            _builder.append(".set_");
            String _name = f.getRecordField().getName();
            _builder.append(_name);
            _builder.append("(");
            CharSequence _generateWithCopy = this.generateWithCopy(f.getExp());
            _builder.append((Object)_generateWithCopy);
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionRecordAccess expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateExpression = this.generateExpression(expr.getRecord());
        _builder.append((Object)_generateExpression);
        _builder.append(".get_");
        String _name = expr.getField().getName();
        _builder.append(_name);
        _builder.append("()");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionVector expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        CharSequence _javaReferenceType = this.toJavaReferenceType((EObject)expr.getTypeAnnotation().getType());
        _builder.append((Object)_javaReferenceType);
        _builder.append("()");
        EList _elements = expr.getElements();
        for (Expression e : _elements) {
            _builder.append(".add(");
            CharSequence _generateWithCopy = this.generateWithCopy(e);
            _builder.append((Object)_generateWithCopy);
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionFunctionCall expr) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _equals = expr.getFunctionName().equals("isEmpty");
        if (_equals) {
            CharSequence _generateExpression = this.generateExpression((Expression)expr.getArgs().get(0));
            _builder.append((Object)_generateExpression);
            _builder.append(".isEmpty()");
        }
        _builder.newLineIfNotEmpty();
        boolean _equals_1 = expr.getFunctionName().equals("size");
        if (_equals_1) {
            CharSequence _generateExpression_1 = this.generateExpression((Expression)expr.getArgs().get(0));
            _builder.append((Object)_generateExpression_1);
            _builder.append(".size()");
        }
        _builder.newLineIfNotEmpty();
        boolean _equals_2 = expr.getFunctionName().equals("contains");
        if (_equals_2) {
            CharSequence _generateExpression_2 = this.generateExpression((Expression)expr.getArgs().get(0));
            _builder.append((Object)_generateExpression_2);
            _builder.append(".contains(");
            CharSequence _generateExpression_3 = this.generateExpression((Expression)expr.getArgs().get(1));
            _builder.append((Object)_generateExpression_3);
            _builder.append(")");
        }
        _builder.newLineIfNotEmpty();
        boolean _equals_3 = expr.getFunctionName().equals("add");
        if (_equals_3) {
            CharSequence _generateExpression_4 = this.generateExpression((Expression)expr.getArgs().get(0));
            _builder.append((Object)_generateExpression_4);
            _builder.append(".add(");
            CharSequence _generateWithCopy = this.generateWithCopy((Expression)expr.getArgs().get(1));
            _builder.append((Object)_generateWithCopy);
            _builder.append(")");
        }
        _builder.newLineIfNotEmpty();
        boolean _equals_4 = expr.getFunctionName().equals("asReal");
        if (_equals_4) {
            _builder.append("((double)");
            CharSequence _generateExpression_5 = this.generateExpression((Expression)expr.getArgs().get(0));
            _builder.append((Object)_generateExpression_5);
            _builder.append(")");
        }
        _builder.newLineIfNotEmpty();
        boolean _equals_5 = expr.getFunctionName().equals("abs");
        if (_equals_5) {
            _builder.append("Math.abs(");
            CharSequence _generateExpression_6 = this.generateExpression((Expression)expr.getArgs().get(0));
            _builder.append((Object)_generateExpression_6);
            _builder.append(")");
        }
        _builder.newLineIfNotEmpty();
        boolean _equals_6 = expr.getFunctionName().equals("length");
        if (_equals_6) {
            CharSequence _generateExpression_7 = this.generateExpression((Expression)expr.getArgs().get(0));
            _builder.append((Object)_generateExpression_7);
            _builder.append(".getSize()");
        }
        _builder.newLineIfNotEmpty();
        boolean _equals_7 = expr.getFunctionName().equals("hasKey");
        if (_equals_7) {
            CharSequence _generateExpression_8 = this.generateExpression((Expression)expr.getArgs().get(0));
            _builder.append((Object)_generateExpression_8);
            _builder.append(".hasKey(");
            CharSequence _generateExpression_9 = this.generateExpression((Expression)expr.getArgs().get(1));
            _builder.append((Object)_generateExpression_9);
            _builder.append(")");
        }
        _builder.newLineIfNotEmpty();
        boolean _equals_8 = expr.getFunctionName().equals("deleteKey");
        if (_equals_8) {
            CharSequence _generateExpression_10 = this.generateExpression((Expression)expr.getArgs().get(0));
            _builder.append((Object)_generateExpression_10);
            _builder.append(".deleteKey(");
            CharSequence _generateExpression_11 = this.generateExpression((Expression)expr.getArgs().get(1));
            _builder.append((Object)_generateExpression_11);
            _builder.append(")");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionMap expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        CharSequence _javaReferenceType = this.toJavaReferenceType((EObject)expr.getTypeAnnotation().getType());
        _builder.append((Object)_javaReferenceType);
        _builder.append("()");
        EList _pairs = expr.getPairs();
        for (Pair p : _pairs) {
            _builder.append(".put(");
            CharSequence _generateExpression = this.generateExpression(p.getKey());
            _builder.append((Object)_generateExpression);
            _builder.append(", ");
            CharSequence _generateWithCopy = this.generateWithCopy(p.getValue());
            _builder.append((Object)_generateWithCopy);
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionMapRW expr) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        Expression _value = expr.getValue();
        boolean bl = _tripleNotEquals = _value != null;
        if (_tripleNotEquals) {
            CharSequence _generateMapUpdate = this.generateMapUpdate(expr);
            _builder.append((Object)_generateMapUpdate);
        } else {
            CharSequence _generateMapAccess = this.generateMapAccess(expr);
            _builder.append((Object)_generateMapAccess);
        }
        return _builder;
    }

    public CharSequence generateMapUpdate(ExpressionMapRW expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateExpression = this.generateExpression(expr.getMap());
        _builder.append((Object)_generateExpression);
        _builder.append(".update(");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getKey());
        _builder.append((Object)_generateExpression_1);
        _builder.append(", ");
        CharSequence _generateWithCopy = this.generateWithCopy(expr.getValue());
        _builder.append((Object)_generateWithCopy);
        _builder.append(")");
        return _builder;
    }

    public CharSequence generateMapAccess(ExpressionMapRW expr) {
        StringConcatenation _xblockexpression = null;
        ExpressionValidator validator = new ExpressionValidator();
        TypeObject mapType = validator.typeOf(expr.getMap());
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateExpression = this.generateExpression(expr.getMap());
        _builder.append((Object)_generateExpression);
        _builder.append(".readSafe(");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getKey());
        _builder.append((Object)_generateExpression_1);
        _builder.append(", ");
        CharSequence _defaultValue = this.defaultValue((EObject)TypeUtilities.getValueType((TypeObject)mapType));
        _builder.append((Object)_defaultValue);
        _builder.append(")");
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateWithCopy(Expression expr) {
        StringConcatenation _xblockexpression = null;
        ExpressionValidator validator = new ExpressionValidator();
        TypeObject type = validator.typeOf(expr);
        boolean _isStructuredType = TypeUtilities.isStructuredType((TypeObject)type);
        if (_isStructuredType && (expr instanceof ExpressionVariable || expr instanceof ExpressionRecordAccess || expr instanceof ExpressionMapRW && ((ExpressionMapRW)expr).getValue() == null)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(");
            CharSequence _javaReferenceType = this.toJavaReferenceType((EObject)type);
            _builder.append((Object)_javaReferenceType);
            _builder.append(")Utils.deepCopy(");
            CharSequence _generateExpression = this.generateExpression(expr);
            _builder.append((Object)_generateExpression);
            _builder.append(")");
            return _builder;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        CharSequence _generateExpression_1 = this.generateExpression(expr);
        _builder_1.append((Object)_generateExpression_1);
        _xblockexpression = _builder_1;
        return _xblockexpression;
    }

    public abstract CommaScope getCommaScope(EObject var1);

    public CharSequence generateExpression(Expression expr) {
        if (expr instanceof ExpressionAddition) {
            return this._generateExpression((ExpressionAddition)expr);
        }
        if (expr instanceof ExpressionAnd) {
            return this._generateExpression((ExpressionAnd)expr);
        }
        if (expr instanceof ExpressionBracket) {
            return this._generateExpression((ExpressionBracket)expr);
        }
        if (expr instanceof ExpressionDivision) {
            return this._generateExpression((ExpressionDivision)expr);
        }
        if (expr instanceof ExpressionEqual) {
            return this._generateExpression((ExpressionEqual)expr);
        }
        if (expr instanceof ExpressionGeq) {
            return this._generateExpression((ExpressionGeq)expr);
        }
        if (expr instanceof ExpressionGreater) {
            return this._generateExpression((ExpressionGreater)expr);
        }
        if (expr instanceof ExpressionLeq) {
            return this._generateExpression((ExpressionLeq)expr);
        }
        if (expr instanceof ExpressionLess) {
            return this._generateExpression((ExpressionLess)expr);
        }
        if (expr instanceof ExpressionMaximum) {
            return this._generateExpression((ExpressionMaximum)expr);
        }
        if (expr instanceof ExpressionMinimum) {
            return this._generateExpression((ExpressionMinimum)expr);
        }
        if (expr instanceof ExpressionMinus) {
            return this._generateExpression((ExpressionMinus)expr);
        }
        if (expr instanceof ExpressionModulo) {
            return this._generateExpression((ExpressionModulo)expr);
        }
        if (expr instanceof ExpressionMultiply) {
            return this._generateExpression((ExpressionMultiply)expr);
        }
        if (expr instanceof ExpressionNEqual) {
            return this._generateExpression((ExpressionNEqual)expr);
        }
        if (expr instanceof ExpressionNot) {
            return this._generateExpression((ExpressionNot)expr);
        }
        if (expr instanceof ExpressionOr) {
            return this._generateExpression((ExpressionOr)expr);
        }
        if (expr instanceof ExpressionPlus) {
            return this._generateExpression((ExpressionPlus)expr);
        }
        if (expr instanceof ExpressionPower) {
            return this._generateExpression((ExpressionPower)expr);
        }
        if (expr instanceof ExpressionSubtraction) {
            return this._generateExpression((ExpressionSubtraction)expr);
        }
        if (expr instanceof ExpressionAny) {
            return this._generateExpression((ExpressionAny)expr);
        }
        if (expr instanceof ExpressionBulkData) {
            return this._generateExpression((ExpressionBulkData)expr);
        }
        if (expr instanceof ExpressionConstantBool) {
            return this._generateExpression((ExpressionConstantBool)expr);
        }
        if (expr instanceof ExpressionConstantInt) {
            return this._generateExpression((ExpressionConstantInt)expr);
        }
        if (expr instanceof ExpressionConstantReal) {
            return this._generateExpression((ExpressionConstantReal)expr);
        }
        if (expr instanceof ExpressionConstantString) {
            return this._generateExpression((ExpressionConstantString)expr);
        }
        if (expr instanceof ExpressionEnumLiteral) {
            return this._generateExpression((ExpressionEnumLiteral)expr);
        }
        if (expr instanceof ExpressionFunctionCall) {
            return this._generateExpression((ExpressionFunctionCall)expr);
        }
        if (expr instanceof ExpressionMap) {
            return this._generateExpression((ExpressionMap)expr);
        }
        if (expr instanceof ExpressionMapRW) {
            return this._generateExpression((ExpressionMapRW)expr);
        }
        if (expr instanceof ExpressionRecord) {
            return this._generateExpression((ExpressionRecord)expr);
        }
        if (expr instanceof ExpressionRecordAccess) {
            return this._generateExpression((ExpressionRecordAccess)expr);
        }
        if (expr instanceof ExpressionVariable) {
            return this._generateExpression((ExpressionVariable)expr);
        }
        if (expr instanceof ExpressionVector) {
            return this._generateExpression((ExpressionVector)expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }
}

