/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.comma.monitoring.lib.CDispatcher;
import org.eclipse.comma.monitoring.lib.CFactory;
import org.eclipse.comma.monitoring.lib.CInterfaceMonitor;
import org.eclipse.comma.monitoring.lib.CInterfaceMonitoringContext;
import org.eclipse.comma.monitoring.lib.CMonitorResults;
import org.eclipse.comma.monitoring.lib.messages.CObservedCommand;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.messages.CObservedSignal;

public class CInterfaceDispatcher
extends CDispatcher {
    private CInterfaceMonitoringContext context;
    private final String interfaceName;
    private final boolean singleton;
    private CFactory factory;

    public CInterfaceDispatcher(CInterfaceMonitoringContext context, CFactory factory, int nrConnections) {
        super(nrConnections);
        this.context = context;
        this.interfaceName = context.getInterfaceName();
        this.singleton = context.isSingleton();
        this.factory = factory;
    }

    @Override
    public boolean consume(CObservedMessage message) throws Exception {
        if (this.nrErrorConnections == this.nrConnections) {
            return false;
        }
        if (!message.getInterface().equals(this.interfaceName)) {
            return true;
        }
        String key = this.connectionKey(message);
        CInterfaceMonitor monitor = (CInterfaceMonitor)this.connection2monitor.get(key);
        if (monitor == null) {
            monitor = new CInterfaceMonitor(this.context.clone().setConnectionName(key).setLocalDir(String.valueOf(key) + "\\"), this.factory);
            this.connection2monitor.put(key, monitor);
        }
        if (!monitor.inErrorState() && !monitor.consume(message)) {
            ++this.nrErrorConnections;
        }
        return this.nrErrorConnections < this.nrConnections;
    }

    private String connectionKey(CObservedMessage message) {
        if (message instanceof CObservedCommand || message instanceof CObservedSignal) {
            if (!this.singleton) {
                return this.makeMultitonConnectionKey(message.getDestination(), message.getSource(), this.interfaceName);
            }
            return this.makeSingletonConnectionKey(message.getDestination(), message.getDestinationPort(), this.interfaceName);
        }
        if (!this.singleton) {
            return this.makeMultitonConnectionKey(message.getSource(), message.getDestination(), this.interfaceName);
        }
        return this.makeSingletonConnectionKey(message.getSource(), message.getSourcePort(), this.interfaceName);
    }

    @Override
    public void traceEnded() {
        for (CInterfaceMonitor mon : this.connection2monitor.values().stream().filter(h -> !h.inErrorState()).collect(Collectors.toList())) {
            mon.traceEnded();
        }
    }

    @Override
    public List<CMonitorResults> getResults() {
        return this.connection2monitor.values().stream().map(h -> h.getResults()).collect(Collectors.toList());
    }
}

