/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.actions.ActionGroup;

public abstract class SynchronizePageActionGroup
extends ActionGroup {
    private ISynchronizePageConfiguration configuration;
    private Map<String, Map<String, List<Object>>> menuContributions = new HashMap<String, Map<String, List<Object>>>();
    private VisibleRootsSelectionProvider visibleRootSelectionProvider;

    public void initialize(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        if (this.visibleRootSelectionProvider != null) {
            configuration.addActionContribution(this.visibleRootSelectionProvider);
        }
    }

    public void modelChanged(ISynchronizeModelElement root) {
    }

    public void dispose() {
        super.dispose();
        if (this.configuration != null) {
            this.configuration.removeActionContribution(this);
        }
    }

    protected IContributionItem findGroup(IContributionManager menu, String groupId) {
        if (menu == null) {
            return null;
        }
        IContributionItem item = menu.find(((SynchronizePageConfiguration)this.configuration).getGroupId(groupId));
        if (item == null) {
            item = menu.find(groupId);
        }
        return item;
    }

    protected boolean appendToGroup(IContributionManager manager, String groupId, IAction action) {
        if (this.internalAppendToGroup(manager, groupId, action)) {
            this.registerActionWithWorkbench(action);
            return true;
        }
        return false;
    }

    private boolean internalAppendToGroup(IContributionManager manager, String groupId, IAction action) {
        if (manager == null || action == null) {
            return false;
        }
        IContributionItem group = this.findGroup(manager, groupId);
        if (group != null) {
            manager.appendToGroup(group.getId(), action);
            return true;
        }
        return false;
    }

    protected boolean appendToGroup(IContributionManager manager, String groupId, IContributionItem item) {
        if (manager == null || item == null) {
            return false;
        }
        IContributionItem group = this.findGroup(manager, groupId);
        if (group != null) {
            manager.appendToGroup(group.getId(), item);
            return true;
        }
        return false;
    }

    protected void appendToGroup(String menuId, String groupId, IAction action) {
        this.registerActionWithWorkbench(action);
        this.internalAppendToGroup(menuId, groupId, (Object)action);
    }

    private void registerActionWithWorkbench(IAction action) {
        ISynchronizePageSite site = this.configuration.getSite();
        String id = action.getId();
        if (id != null) {
            site.getActionBars().setGlobalActionHandler(id, action);
            IKeyBindingService keyBindingService = site.getKeyBindingService();
            if (keyBindingService != null) {
                keyBindingService.registerAction(action);
            }
        }
    }

    protected void appendToGroup(String menuId, String groupId, IContributionItem item) {
        this.internalAppendToGroup(menuId, groupId, item);
    }

    protected ISelectionProvider getVisibleRootsSelectionProvider() {
        if (this.visibleRootSelectionProvider == null) {
            ISynchronizeModelElement root = null;
            if (this.configuration != null) {
                root = (ISynchronizeModelElement)this.configuration.getProperty("org.eclipse.team.ui.P_MODEL");
            }
            this.visibleRootSelectionProvider = new VisibleRootsSelectionProvider(root);
            if (this.configuration != null) {
                this.configuration.addActionContribution(this.visibleRootSelectionProvider);
            }
        }
        return this.visibleRootSelectionProvider;
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.fillMenu((IContributionManager)menu, "org.eclipse.team.ui.P_CONTEXT_MENU");
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (actionBars != null) {
            this.fillMenu((IContributionManager)actionBars.getMenuManager(), "org.eclipse.team.ui.P_VIEW_MENU");
            this.fillMenu((IContributionManager)actionBars.getToolBarManager(), "org.eclipse.team.ui.P_TOOLBAR_MENU");
        }
    }

    private void fillMenu(IContributionManager menu, String menuId) {
        Map<String, List<Object>> groups = this.menuContributions.get(menuId);
        if (menu != null && groups != null) {
            for (String groupId : groups.keySet()) {
                List<Object> actions = groups.get(groupId);
                if (actions == null) continue;
                for (Object element : actions) {
                    if (element instanceof IAction) {
                        this.internalAppendToGroup(menu, groupId, (IAction)element);
                        continue;
                    }
                    if (!(element instanceof IContributionItem)) continue;
                    this.appendToGroup(menu, groupId, (IContributionItem)element);
                }
            }
        }
    }

    private void internalAppendToGroup(String menuId, String groupId, Object action) {
        List<Object> actions;
        Map<String, List<Object>> groups = this.menuContributions.get(menuId);
        if (groups == null) {
            groups = new HashMap<String, List<Object>>();
            this.menuContributions.put(menuId, groups);
        }
        if ((actions = groups.get(groupId)) == null) {
            actions = new ArrayList<Object>();
            groups.put(groupId, actions);
        }
        actions.add(action);
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    private static class VisibleRootsSelectionProvider
    extends SynchronizePageActionGroup
    implements ISelectionProvider {
        private ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList(1);
        private ISelection selection;

        protected VisibleRootsSelectionProvider(ISynchronizeModelElement element) {
            this.modelChanged(element);
        }

        @Override
        public void modelChanged(ISynchronizeModelElement root) {
            if (root == null) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                this.setSelection((ISelection)new StructuredSelection((Object)root));
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.add((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.remove((Object)listener);
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
            this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }

        private void selectionChanged(final SelectionChangedEvent event) {
            for (final ISelectionChangedListener l : this.selectionChangedListeners) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.selectionChanged(event);
                    }
                });
            }
        }
    }
}

