/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import javax.inject.Named;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.ui.internal.handlers.FilterRunnable;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.chemclipse.rcp.app.ui.handlers.PerspectiveSwitchHandler;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class FilterHandlerAllPeaks
implements EventHandler {
    private static final Logger logger = Logger.getLogger(FilterHandlerAllPeaks.class);
    private static IChromatogramSelectionMSD chromatogramSelection;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        if (chromatogramSelection != null) {
            PerspectiveSwitchHandler.focusPerspectiveAndView((String)"org.eclipse.chemclipse.chromatogram.msd.perspective.ui.perspective.chromatogramPeaks", (String)"org.eclipse.chemclipse.ux.extension.msd.ui.part.peakMSDView");
            Display display = Display.getCurrent();
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Start SNIP Filter All Peaks");
            FilterRunnable runnable = new FilterRunnable(chromatogramSelection, false);
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(display.getActiveShell());
            try {
                monitor.run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)e);
            }
            catch (InterruptedException e) {
                logger.warn((Object)e);
            }
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Done: SNIP Filter applied");
        }
    }

    public void handleEvent(Event event) {
        chromatogramSelection = event.getTopic().equals("chromatogram/msd/update/chromatogramselection") ? (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection") : null;
    }
}

