/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core.quantitation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.model.quantitation.CalibrationMethod;
import org.eclipse.chemclipse.model.quantitation.IRetentionIndexWindow;
import org.eclipse.chemclipse.model.quantitation.IRetentionTimeWindow;
import org.eclipse.chemclipse.model.quantitation.RetentionIndexWindow;
import org.eclipse.chemclipse.model.quantitation.RetentionTimeWindow;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.quantitation.ConcentrationResponseEntriesMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.ConcentrationResponseEntryMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IConcentrationResponseEntriesMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationPeakMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationSignalsMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IntegrationQuantitationSupport;
import org.eclipse.chemclipse.msd.model.core.quantitation.QuantitationSignalMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.QuantitationSignalsMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;

public abstract class AbstractQuantitationCompoundMSD
implements IQuantitationCompoundMSD {
    private static final long serialVersionUID = 8760040551533353962L;
    private String name = "";
    private String chemicalClass = "";
    private IRetentionTimeWindow retentionTimeWindow;
    private IRetentionIndexWindow retentionIndexWindow;
    private String concentrationUnit;
    private IQuantitationSignalsMSD quantitationSignalsMSD;
    private IConcentrationResponseEntriesMSD concentrationResponseEntriesMSD;
    private boolean useTIC;
    private CalibrationMethod calibrationMethod;
    private boolean useCrossZero;

    public AbstractQuantitationCompoundMSD(String name, String concentrationUnit, int retentionTime) {
        this.name = name;
        this.concentrationUnit = concentrationUnit;
        this.retentionTimeWindow = new RetentionTimeWindow();
        this.retentionTimeWindow.setRetentionTime(retentionTime);
        this.retentionIndexWindow = new RetentionIndexWindow();
        this.quantitationSignalsMSD = new QuantitationSignalsMSD();
        this.concentrationResponseEntriesMSD = new ConcentrationResponseEntriesMSD();
        this.useTIC = true;
        this.calibrationMethod = CalibrationMethod.LINEAR;
        this.useCrossZero = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getChemicalClass() {
        return this.chemicalClass;
    }

    @Override
    public void setChemicalClass(String chemicalClass) {
        if (chemicalClass != null) {
            this.chemicalClass = chemicalClass;
        }
    }

    @Override
    public IRetentionTimeWindow getRetentionTimeWindow() {
        return this.retentionTimeWindow;
    }

    @Override
    public IRetentionIndexWindow getRetentionIndexWindow() {
        return this.retentionIndexWindow;
    }

    @Override
    public String getConcentrationUnit() {
        return this.concentrationUnit;
    }

    @Override
    public boolean isUseTIC() {
        return this.useTIC;
    }

    @Override
    public void setUseTIC(boolean useTIC) {
        this.useTIC = useTIC;
    }

    @Override
    public IQuantitationSignalsMSD getQuantitationSignalsMSD() {
        return this.quantitationSignalsMSD;
    }

    @Override
    public void updateQuantitationSignalsMSD(IQuantitationSignalsMSD quantitationSignalsMSD) {
        if (quantitationSignalsMSD != null) {
            this.quantitationSignalsMSD = quantitationSignalsMSD;
        }
    }

    @Override
    public IConcentrationResponseEntriesMSD getConcentrationResponseEntriesMSD() {
        return this.concentrationResponseEntriesMSD;
    }

    @Override
    public void updateConcentrationResponseEntries(IConcentrationResponseEntriesMSD concentrationResponseEntriesMSD) {
        if (concentrationResponseEntriesMSD != null) {
            this.concentrationResponseEntriesMSD = concentrationResponseEntriesMSD;
        }
    }

    @Override
    public void calculateQuantitationSignalsAndConcentrationResponseEntries(List<IQuantitationPeakMSD> quantitationPeaks) {
        if (quantitationPeaks.size() > 0) {
            this.quantitationSignalsMSD.clear();
            this.concentrationResponseEntriesMSD.clear();
            if (this.isUseTIC()) {
                this.createSignalTablesTIC(quantitationPeaks);
            } else {
                this.createSignalTablesXIC(quantitationPeaks);
            }
        }
    }

    private void createSignalTablesTIC(List<IQuantitationPeakMSD> quantitationPeaks) {
        boolean firstPeak = true;
        for (IQuantitationPeakMSD quantitationPeakMSD : quantitationPeaks) {
            double concentration = quantitationPeakMSD.getConcentration();
            IPeakMSD peak = quantitationPeakMSD.getReferencePeakMSD();
            IntegrationQuantitationSupport integrationQuantitationSupport = new IntegrationQuantitationSupport(peak);
            if (!integrationQuantitationSupport.validateTIC()) continue;
            double ion = 0.0;
            double response = integrationQuantitationSupport.getIntegrationArea(ion);
            if (firstPeak) {
                QuantitationSignalMSD quantitationSignal = new QuantitationSignalMSD(ion, 100.0f);
                this.quantitationSignalsMSD.add(quantitationSignal);
            }
            ConcentrationResponseEntryMSD concentrationResponseEntry = new ConcentrationResponseEntryMSD(ion, concentration, response);
            this.concentrationResponseEntriesMSD.add(concentrationResponseEntry);
            firstPeak = false;
        }
    }

    private void createSignalTablesXIC(List<IQuantitationPeakMSD> quantitationPeaks) {
        boolean firstPeak = true;
        for (IQuantitationPeakMSD quantitationPeakMSD : quantitationPeaks) {
            IPeakMassSpectrum massSpectrum;
            IExtractedIonSignal extractedIonSignal;
            List<Double> selectedQuantitationIons;
            double concentration = quantitationPeakMSD.getConcentration();
            IPeakMSD peak = quantitationPeakMSD.getReferencePeakMSD();
            IntegrationQuantitationSupport integrationQuantitationSupport = new IntegrationQuantitationSupport(peak);
            if (!integrationQuantitationSupport.validateXIC(selectedQuantitationIons = this.getSelectedQunatitationIons(extractedIonSignal = (massSpectrum = peak.getExtractedMassSpectrum()).getExtractedIonSignal()))) continue;
            for (double ion : selectedQuantitationIons) {
                float abundance = extractedIonSignal.getAbundance((int)ion);
                float totalSignalMassSpectrum = extractedIonSignal.getTotalSignal();
                float percentageIonAbundance = (float)(1.0 / (double)totalSignalMassSpectrum * (double)abundance);
                if (firstPeak) {
                    QuantitationSignalMSD quantitationSignal = new QuantitationSignalMSD(ion, percentageIonAbundance);
                    this.quantitationSignalsMSD.add(quantitationSignal);
                }
                double response = integrationQuantitationSupport.getIntegrationArea(ion);
                ConcentrationResponseEntryMSD concentrationResponseEntry = integrationQuantitationSupport.isTheTotalSignalIntegrated() ? new ConcentrationResponseEntryMSD(ion, concentration, response * (double)percentageIonAbundance) : new ConcentrationResponseEntryMSD(ion, concentration, response);
                this.concentrationResponseEntriesMSD.add(concentrationResponseEntry);
            }
            firstPeak = false;
        }
    }

    private List<Double> getSelectedQunatitationIons(IExtractedIonSignal extractedIonSignal) {
        ArrayList<Double> selectedQunatitationIons = new ArrayList<Double>();
        int startIon = extractedIonSignal.getStartIon();
        int stopIon = extractedIonSignal.getStopIon();
        int ion = startIon;
        while (ion <= stopIon) {
            float abundance = extractedIonSignal.getAbundance(ion);
            if (abundance > 0.0f) {
                selectedQunatitationIons.add(Double.valueOf(ion));
            }
            ++ion;
        }
        return selectedQunatitationIons;
    }

    @Override
    public CalibrationMethod getCalibrationMethod() {
        return this.calibrationMethod;
    }

    @Override
    public void setCalibrationMethod(CalibrationMethod calibrationMethod) {
        this.calibrationMethod = calibrationMethod;
    }

    @Override
    public boolean isCrossZero() {
        return this.useCrossZero;
    }

    @Override
    public void setUseCrossZero(boolean useCrossZero) {
        this.useCrossZero = useCrossZero;
    }

    @Override
    public void updateQuantitationCompound(IQuantitationCompoundMSD quantitationCompoundMSD) {
        if (quantitationCompoundMSD != null) {
            this.name = quantitationCompoundMSD.getName();
            this.chemicalClass = quantitationCompoundMSD.getChemicalClass();
            this.concentrationUnit = quantitationCompoundMSD.getConcentrationUnit();
            this.useTIC = quantitationCompoundMSD.isUseTIC();
            this.calibrationMethod = quantitationCompoundMSD.getCalibrationMethod();
            this.useCrossZero = quantitationCompoundMSD.isCrossZero();
        }
    }
}

