/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.MathParseException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.random.RandomVectorGenerator;
import org.apache.commons.math3.util.FastMath;

public class SobolSequenceGenerator
implements RandomVectorGenerator {
    private static final int BITS = 52;
    private static final double SCALE = FastMath.pow(2.0, 52);
    private static final int MAX_DIMENSION = 1000;
    private static final String RESOURCE_NAME = "/assets/org/apache/commons/math3/random/new-joe-kuo-6.1000";
    private static final String FILE_CHARSET = "US-ASCII";
    private final int dimension;
    private int count = 0;
    private final long[][] direction;
    private final long[] x;

    public SobolSequenceGenerator(int dimension) throws OutOfRangeException {
        if (dimension < 1 || dimension > 1000) {
            throw new OutOfRangeException(dimension, (Number)1, 1000);
        }
        InputStream is = this.getClass().getResourceAsStream(RESOURCE_NAME);
        if (is == null) {
            throw new MathInternalError();
        }
        this.dimension = dimension;
        this.direction = new long[dimension][53];
        this.x = new long[dimension];
        try {
            try {
                this.initFromStream(is);
            }
            catch (IOException iOException) {
                throw new MathInternalError();
            }
            catch (MathParseException mathParseException) {
                throw new MathInternalError();
            }
        }
        catch (Throwable throwable) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {}
    }

    public SobolSequenceGenerator(int dimension, InputStream is) throws NotStrictlyPositiveException, MathParseException, IOException {
        if (dimension < 1) {
            throw new NotStrictlyPositiveException(dimension);
        }
        this.dimension = dimension;
        this.direction = new long[dimension][53];
        this.x = new long[dimension];
        int lastDimension = this.initFromStream(is);
        if (lastDimension < dimension) {
            throw new OutOfRangeException(dimension, (Number)1, lastDimension);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int initFromStream(InputStream is) throws MathParseException, IOException {
        block13: {
            i = 1;
            while (i <= 52) {
                this.direction[0][i] = 1L << 52 - i;
                ++i;
            }
            charset = Charset.forName("US-ASCII");
            reader = new BufferedReader(new InputStreamReader(is, charset));
            dim = -1;
            reader.readLine();
            lineNumber = 2;
            index = 1;
            line = null;
            while ((line = reader.readLine()) != null) {
                st = new StringTokenizer(line, " ");
                try {
                    dim = Integer.parseInt(st.nextToken());
                    if (dim >= 2 && dim <= this.dimension) {
                        s = Integer.parseInt(st.nextToken());
                        a = Integer.parseInt(st.nextToken());
                        m = new int[s + 1];
                        i = 1;
                        while (i <= s) {
                            m[i] = Integer.parseInt(st.nextToken());
                            ++i;
                        }
                        this.initDirectionVector(index++, a, m);
                    }
                    if (dim > this.dimension) {
                        var14_14 = dim;
                        return var14_14;
                    }
                    ** break block12
                }
                catch (NoSuchElementException v0) {
                    throw new MathParseException(line, lineNumber);
                }
                catch (NumberFormatException v1) {
                    throw new MathParseException(line, lineNumber);
                }
            }
            break block13;
lbl-1000:
            // 1 sources

            {
                ++lineNumber;
                continue;
                break;
            }
            finally {
                reader.close();
            }
        }
        return dim;
    }

    private void initDirectionVector(int d, int a, int[] m) {
        int s = m.length - 1;
        int i = 1;
        while (i <= s) {
            this.direction[d][i] = (long)m[i] << 52 - i;
            ++i;
        }
        i = s + 1;
        while (i <= 52) {
            this.direction[d][i] = this.direction[d][i - s] ^ this.direction[d][i - s] >> s;
            int k = 1;
            while (k <= s - 1) {
                long[] lArray = this.direction[d];
                int n = i;
                lArray[n] = lArray[n] ^ (long)(a >> s - 1 - k & 1) * this.direction[d][i - k];
                ++k;
            }
            ++i;
        }
    }

    @Override
    public double[] nextVector() {
        double[] v = new double[this.dimension];
        if (this.count == 0) {
            ++this.count;
            return v;
        }
        int c = 1;
        int value = this.count - 1;
        while ((value & 1) == 1) {
            value >>= 1;
            ++c;
        }
        int i = 0;
        while (i < this.dimension) {
            int n = i;
            this.x[n] = this.x[n] ^ this.direction[i][c];
            v[i] = (double)this.x[i] / SCALE;
            ++i;
        }
        ++this.count;
        return v;
    }

    public double[] skipTo(int index) throws NotPositiveException {
        if (index == 0) {
            Arrays.fill(this.x, 0L);
        } else {
            int i = index - 1;
            long grayCode = i ^ i >> 1;
            int j = 0;
            while (j < this.dimension) {
                long result = 0L;
                int k = 1;
                while (k <= 52) {
                    long shift = grayCode >> k - 1;
                    if (shift == 0L) break;
                    long ik = shift & 1L;
                    result ^= ik * this.direction[j][k];
                    ++k;
                }
                this.x[j] = result;
                ++j;
            }
        }
        this.count = index;
        return this.nextVector();
    }

    public int getNextIndex() {
        return this.count;
    }
}

