/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.sofm;

import org.apache.commons.math3.ml.neuralnet.sofm.NeighbourhoodSizeFunction;
import org.apache.commons.math3.ml.neuralnet.sofm.util.ExponentialDecayFunction;
import org.apache.commons.math3.ml.neuralnet.sofm.util.QuasiSigmoidDecayFunction;
import org.apache.commons.math3.util.FastMath;

public class NeighbourhoodSizeFunctionFactory {
    private NeighbourhoodSizeFunctionFactory() {
    }

    public static NeighbourhoodSizeFunction exponentialDecay(double initValue, double valueAtNumCall, long numCall) {
        return new NeighbourhoodSizeFunction(initValue, valueAtNumCall, numCall){
            private final ExponentialDecayFunction decay;
            {
                this.decay = new ExponentialDecayFunction(d, d2, l);
            }

            @Override
            public int value(long n) {
                return (int)FastMath.rint(this.decay.value(n));
            }
        };
    }

    public static NeighbourhoodSizeFunction quasiSigmoidDecay(double initValue, double slope, long numCall) {
        return new NeighbourhoodSizeFunction(initValue, slope, numCall){
            private final QuasiSigmoidDecayFunction decay;
            {
                this.decay = new QuasiSigmoidDecayFunction(d, d2, l);
            }

            @Override
            public int value(long n) {
                return (int)FastMath.rint(this.decay.value(n));
            }
        };
    }
}

