/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IDataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IPcaResult;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IPcaResults;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ISample;
import org.eclipse.chemclipse.support.text.ValueFormat;

public class ResultExport {
    private static final String TAB = "\t";
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    /*
     * WARNING - void declaration
     */
    public void exportToTextFile(File file, IPcaResults pcaResults) throws FileNotFoundException {
        PrintWriter printWriter = new PrintWriter(file);
        if (pcaResults != null) {
            void var5_12;
            int n;
            Set<Map.Entry<ISample, IPcaResult>> entrySet = pcaResults.getPcaResultMap().entrySet();
            printWriter.println("-------------------------------------");
            printWriter.println("Settings");
            printWriter.println("-------------------------------------");
            printWriter.print("Number of principle components:");
            printWriter.print(TAB);
            printWriter.println(pcaResults.getNumberOfPrincipleComponents());
            printWriter.print("Retention time window:");
            printWriter.print(TAB);
            printWriter.println(pcaResults.getRetentionTimeWindow());
            printWriter.println("");
            printWriter.println("-------------------------------------");
            printWriter.println("Input Files");
            printWriter.println("-------------------------------------");
            for (IDataInputEntry iDataInputEntry : pcaResults.getDataInputEntries()) {
                printWriter.print(iDataInputEntry.getName());
                printWriter.print(TAB);
                printWriter.println(iDataInputEntry.getInputFile());
            }
            printWriter.println("");
            printWriter.println("-------------------------------------");
            printWriter.println("Extracted Retention Times (Minutes)");
            printWriter.println("-------------------------------------");
            Iterator<Object> iterator = pcaResults.getExtractedRetentionTimes().iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                printWriter.println(this.decimalFormat.format((double)n2 / 60000.0));
            }
            printWriter.println("");
            printWriter.println("-------------------------------------");
            printWriter.println("Peak Intensity Table");
            printWriter.println("-------------------------------------");
            printWriter.print("Filename");
            printWriter.print(TAB);
            iterator = pcaResults.getExtractedRetentionTimes().iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                printWriter.print(this.decimalFormat.format((double)n3 / 60000.0));
                printWriter.print(TAB);
            }
            printWriter.println("");
            for (Map.Entry entry : entrySet) {
                double[] sampleData;
                printWriter.print(((ISample)entry.getKey()).getName());
                printWriter.print(TAB);
                IPcaResult pcaResult = (IPcaResult)entry.getValue();
                double[] dArray = sampleData = pcaResult.getSampleData();
                n = sampleData.length;
                int n4 = 0;
                while (n4 < n) {
                    double data = dArray[n4];
                    printWriter.print(this.decimalFormat.format(data));
                    printWriter.print(TAB);
                    ++n4;
                }
                printWriter.println("");
            }
            printWriter.println("");
            printWriter.println("-------------------------------------");
            printWriter.println("Principle Components");
            printWriter.println("-------------------------------------");
            printWriter.print("File");
            printWriter.print(TAB);
            boolean bl = true;
            while (var5_12 <= pcaResults.getNumberOfPrincipleComponents()) {
                printWriter.print("PC" + (int)var5_12);
                printWriter.print(TAB);
                ++var5_12;
            }
            printWriter.println("");
            for (Map.Entry entry : entrySet) {
                String name = ((ISample)entry.getKey()).getName();
                IPcaResult pcaResult = (IPcaResult)entry.getValue();
                double[] eigenSpace = pcaResult.getEigenSpace();
                printWriter.print(name);
                printWriter.print(TAB);
                double[] dArray = eigenSpace;
                int n5 = eigenSpace.length;
                n = 0;
                while (n < n5) {
                    double value = dArray[n];
                    printWriter.print(this.decimalFormat.format(value));
                    printWriter.print(TAB);
                    ++n;
                }
                printWriter.println("");
            }
        } else {
            printWriter.println("There are no results available yet.");
        }
        printWriter.flush();
        printWriter.close();
    }
}

