/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block.decomposition.chol;

import org.ejml.alg.block.BlockInnerRankUpdate;
import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.alg.block.BlockTriangularSolver;
import org.ejml.alg.block.decomposition.chol.InnerCholesky_B64;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.data.D1Submatrix64F;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;

public class CholeskyOuterForm_B64
implements CholeskyDecomposition<BlockMatrix64F> {
    private boolean lower = false;
    private BlockMatrix64F T;
    private D1Submatrix64F subA = new D1Submatrix64F();
    private D1Submatrix64F subB = new D1Submatrix64F();
    private D1Submatrix64F subC = new D1Submatrix64F();
    private Complex64F det = new Complex64F();

    public CholeskyOuterForm_B64(boolean lower) {
        this.lower = lower;
    }

    @Override
    public boolean decompose(BlockMatrix64F A) {
        if (A.numCols != A.numRows) {
            throw new IllegalArgumentException("A must be square");
        }
        this.T = A;
        if (this.lower) {
            return this.decomposeLower();
        }
        return this.decomposeUpper();
    }

    private boolean decomposeLower() {
        int blockLength = this.T.blockLength;
        this.subA.set(this.T);
        this.subB.set(this.T);
        this.subC.set(this.T);
        int i = 0;
        while (i < this.T.numCols) {
            int widthA = Math.min(blockLength, this.T.numCols - i);
            this.subA.col0 = i;
            this.subA.col1 = i + widthA;
            this.subA.row0 = this.subA.col0;
            this.subA.row1 = this.subA.col1;
            this.subB.col0 = i;
            this.subB.col1 = i + widthA;
            this.subB.row0 = i + widthA;
            this.subB.row1 = this.T.numRows;
            this.subC.col0 = i + widthA;
            this.subC.col1 = this.T.numRows;
            this.subC.row0 = i + widthA;
            this.subC.row1 = this.T.numRows;
            if (!InnerCholesky_B64.lower(this.subA)) {
                return false;
            }
            if (widthA == blockLength) {
                BlockTriangularSolver.solveBlock(blockLength, false, this.subA, this.subB, false, true);
                BlockInnerRankUpdate.symmRankNMinus_L(blockLength, this.subC, this.subB);
            }
            i += blockLength;
        }
        BlockMatrixOps.zeroTriangle(true, this.T);
        return true;
    }

    private boolean decomposeUpper() {
        int blockLength = this.T.blockLength;
        this.subA.set(this.T);
        this.subB.set(this.T);
        this.subC.set(this.T);
        int i = 0;
        while (i < this.T.numCols) {
            int widthA = Math.min(blockLength, this.T.numCols - i);
            this.subA.col0 = i;
            this.subA.col1 = i + widthA;
            this.subA.row0 = this.subA.col0;
            this.subA.row1 = this.subA.col1;
            this.subB.col0 = i + widthA;
            this.subB.col1 = this.T.numCols;
            this.subB.row0 = i;
            this.subB.row1 = i + widthA;
            this.subC.col0 = i + widthA;
            this.subC.col1 = this.T.numCols;
            this.subC.row0 = i + widthA;
            this.subC.row1 = this.T.numCols;
            if (!InnerCholesky_B64.upper(this.subA)) {
                return false;
            }
            if (widthA == blockLength) {
                BlockTriangularSolver.solveBlock(blockLength, true, this.subA, this.subB, true, false);
                BlockInnerRankUpdate.symmRankNMinus_U(blockLength, this.subC, this.subB);
            }
            i += blockLength;
        }
        BlockMatrixOps.zeroTriangle(false, this.T);
        return true;
    }

    @Override
    public boolean isLower() {
        return this.lower;
    }

    @Override
    public BlockMatrix64F getT(BlockMatrix64F T) {
        if (T == null) {
            return this.T;
        }
        T.set(this.T);
        return T;
    }

    @Override
    public Complex64F computeDeterminant() {
        double prod = 1.0;
        int blockLength = this.T.blockLength;
        int i = 0;
        while (i < this.T.numCols) {
            int widthA = Math.min(blockLength, this.T.numCols - i);
            int indexT = i * this.T.numCols + i * widthA;
            int j = 0;
            while (j < widthA) {
                prod *= this.T.data[indexT];
                indexT += widthA + 1;
                ++j;
            }
            i += blockLength;
        }
        this.det.real = prod * prod;
        this.det.imaginary = 0.0;
        return this.det;
    }

    @Override
    public boolean inputModified() {
        return true;
    }
}

