/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.views;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.swt.ui.components.chromatogram.MirroredMultipleChromatogramOffsetUI;
import org.eclipse.chemclipse.swt.ui.support.AxisTitlesIntensityScale;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.chemclipse.swt.ui.support.IOffset;
import org.eclipse.chemclipse.swt.ui.support.Offset;
import org.eclipse.chemclipse.ux.extension.xxd.ui.views.AbstractChromatogramOverlayView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class MirroredChromatogramOverlayView
extends AbstractChromatogramOverlayView {
    @Inject
    private Composite parent;
    private MirroredMultipleChromatogramOffsetUI chromatogramOverlayUI;
    private IOffset offset = new Offset(0.0, 0.0);

    @Inject
    public MirroredChromatogramOverlayView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
    }

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.chromatogramOverlayUI = new MirroredMultipleChromatogramOffsetUI(this.parent, 0, this.offset, (IAxisTitles)new AxisTitlesIntensityScale());
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.chromatogramOverlayUI.setFocus();
        this.update(this.getChromatogramSelection(), false);
    }

    public void update(IChromatogramSelection chromatogramSelection, boolean forceReload) {
        if (this.doUpdate(chromatogramSelection)) {
            List<IChromatogramSelection> chromatogramSelections = this.getChromatogramSelections(chromatogramSelection, false);
            this.chromatogramOverlayUI.setOffset(this.offset);
            this.chromatogramOverlayUI.updateSelection(chromatogramSelections, forceReload);
        }
    }
}

