/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.io.PeakIdentificationBatchJobWriter;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakIdentificationBatchJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors.IMultiEditorPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors.PeakIdentificationBatchProcessEditorPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors.PeakIdentificationResultsPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors.PeakInputFilesPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors.PeakOutputFilesPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.internal.runnables.PeakIdentificationBatchJobExportRunnable;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.internal.runnables.PeakIdentificationBatchJobImportRunnable;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;

public class PeakIdentificationBatchProcessEditor
extends MultiPageEditorPart {
    private static final Logger logger = Logger.getLogger(PeakIdentificationBatchProcessEditor.class);
    private IFile editorBatchProcessJobFile;
    private IPeakIdentificationBatchJob peakIdentificationBatchJob;
    private boolean isDirty = false;
    private PeakIdentificationBatchProcessEditorPage batchProcessEditorPage;
    private List<IMultiEditorPage> pages = new ArrayList<IMultiEditorPage>();
    private static final String BATCHPROCESS_EDITOR_PAGE = "bpp";
    public static final String PEAK_INPUT_FILES_PAGE = "ifp";
    public static final String PEAK_OUTPUT_FILES_PAGE = "ofp";
    public static final String PEAK_IDENTIFICATION_RESULTS_PAGE = "prp";
    private HashMap<String, Integer> pagesMap = new HashMap();

    protected void setActivePage(String key) {
        Integer pageIndex;
        if (this.pagesMap != null && (pageIndex = this.pagesMap.get(key)) != null) {
            this.setActivePage(pageIndex);
        }
    }

    public void setFocus() {
        super.setFocus();
        int index = this.getActivePage();
        IMultiEditorPage multiEditorPage = this.pages.get(index);
        multiEditorPage.setFocus();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void setDirty() {
        this.isDirty = true;
        this.firePropertyChange(257);
    }

    protected void createPages() {
        this.createPeakIdentificationBatchProcessEditorPage();
        this.createPeakInputFilesPage();
        this.createPeakOutputFilesPage();
        this.createPeakIdentificationResultsPage();
        this.setBatchProcessJobInPages();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        String fileName = input.getName();
        fileName = fileName.substring(0, fileName.length() - 4);
        this.setPartName(fileName);
        if (input instanceof IFileEditorInput) {
            this.editorBatchProcessJobFile = ((IFileEditorInput)input).getFile();
            Display display = Display.getCurrent();
            PeakIdentificationBatchJobImportRunnable runnable = new PeakIdentificationBatchJobImportRunnable(this.editorBatchProcessJobFile.getLocation().toFile());
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(display.getActiveShell());
            try {
                monitor.run(false, true, (IRunnableWithProgress)runnable);
                this.peakIdentificationBatchJob = runnable.getPeakIdentificationBatchJob();
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)e);
            }
            catch (InterruptedException e) {
                logger.warn((Object)e);
            }
        } else {
            throw new PartInitException("The file could't be loaded.");
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.editorBatchProcessJobFile != null) {
            PeakIdentificationBatchJobWriter writer = new PeakIdentificationBatchJobWriter();
            try {
                writer.writeBatchProcessJob(this.editorBatchProcessJobFile.getLocation().toFile(), this.peakIdentificationBatchJob, monitor);
                this.isDirty = false;
                this.firePropertyChange(257);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
            }
            catch (FileIsNotWriteableException e) {
                logger.warn((Object)e);
            }
            catch (IOException e) {
                logger.warn((Object)e);
            }
            catch (XMLStreamException e) {
                logger.warn((Object)e);
            }
        }
    }

    public void doSaveAs() {
        Display display = Display.getCurrent();
        Shell shell = display.getActiveShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setText("Save the identification batch job");
        dialog.setFileName("PeakIdentificationBatchJob.opi");
        String fileName = dialog.open();
        if (fileName != null) {
            File file = new File(fileName);
            PeakIdentificationBatchJobExportRunnable runnable = new PeakIdentificationBatchJobExportRunnable(file, this.peakIdentificationBatchJob);
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(display.getActiveShell());
            try {
                monitor.run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)e);
            }
            catch (InterruptedException e) {
                logger.warn((Object)e);
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    private void setBatchProcessJobInPages() {
        for (IMultiEditorPage page : this.pages) {
            if (page == null) continue;
            page.setPeakIdentificationBatchJob(this.peakIdentificationBatchJob);
        }
    }

    private void createPeakIdentificationBatchProcessEditorPage() {
        this.batchProcessEditorPage = new PeakIdentificationBatchProcessEditorPage(this, this.getContainer());
        this.pages.add(this.batchProcessEditorPage);
        this.pagesMap.put(BATCHPROCESS_EDITOR_PAGE, this.batchProcessEditorPage.getPageIndex());
        this.setPageText(this.pagesMap.get(BATCHPROCESS_EDITOR_PAGE), "Peak Identification Batch Editor");
    }

    private void createPeakInputFilesPage() {
        PeakInputFilesPage page = new PeakInputFilesPage(this, this.getContainer());
        this.pages.add(page);
        this.pagesMap.put(PEAK_INPUT_FILES_PAGE, page.getPageIndex());
        this.setPageText(this.pagesMap.get(PEAK_INPUT_FILES_PAGE), "Peak Input Files");
    }

    private void createPeakOutputFilesPage() {
        PeakOutputFilesPage page = new PeakOutputFilesPage(this, this.getContainer());
        this.pages.add(page);
        this.pagesMap.put(PEAK_OUTPUT_FILES_PAGE, page.getPageIndex());
        this.setPageText(this.pagesMap.get(PEAK_OUTPUT_FILES_PAGE), "Peak Output Files");
    }

    private void createPeakIdentificationResultsPage() {
        PeakIdentificationResultsPage page = new PeakIdentificationResultsPage(this, this.getContainer());
        this.pages.add(page);
        this.pagesMap.put(PEAK_IDENTIFICATION_RESULTS_PAGE, page.getPageIndex());
        this.setPageText(this.pagesMap.get(PEAK_IDENTIFICATION_RESULTS_PAGE), "Peak Identification Results");
    }

    public void dispose() {
        for (IMultiEditorPage page : this.pages) {
            if (page == null) continue;
            page.dispose();
        }
        super.dispose();
    }
}

