/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IIntegrationSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.internal.core.settings.IRetentionTimeRange;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.internal.core.settings.RetentionTimeRange;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;

public class IntegrationSupport
implements IIntegrationSupport {
    private int minimumPeakWidth = 0;
    private float minimumSignalToNoiseRatio = 0.0f;
    private List<IRetentionTimeRange> ranges = new ArrayList<IRetentionTimeRange>();

    @Override
    public void reset() {
        this.minimumPeakWidth = 0;
        this.minimumSignalToNoiseRatio = 0.0f;
        this.resetIntegratorOff();
    }

    @Override
    public void resetIntegratorOff() {
        this.ranges.clear();
    }

    @Override
    public void setIntegratorOff(int startRetentionTime, int stopRetentionTime) {
        RetentionTimeRange retentionTimeRange = new RetentionTimeRange(startRetentionTime, stopRetentionTime);
        this.ranges.add(retentionTimeRange);
    }

    @Override
    public boolean isIntegratorOff(int startRetentionTime) {
        boolean integratorOff = false;
        for (IRetentionTimeRange range : this.ranges) {
            if (startRetentionTime < range.getStartRetentionTime() || startRetentionTime > range.getStopRetentionTime()) continue;
            integratorOff = true;
            break;
        }
        return integratorOff;
    }

    @Override
    public void setMinimumPeakWidth(int minimumPeakWidth) {
        if (minimumPeakWidth >= 0) {
            this.minimumPeakWidth = minimumPeakWidth;
        }
    }

    @Override
    public int getMinimumPeakWidth() {
        return this.minimumPeakWidth;
    }

    @Override
    public float getMinimumSignalToNoiseRatio() {
        return this.minimumSignalToNoiseRatio;
    }

    @Override
    public void setMinimumSignalToNoiseRatio(float minimumSignalToNoiseRatio) {
        if (minimumSignalToNoiseRatio >= 0.0f) {
            this.minimumSignalToNoiseRatio = minimumSignalToNoiseRatio;
        }
    }

    @Override
    public boolean report(IPeak peak) {
        IChromatogramPeakMSD chromatogramPeak;
        if (peak == null) {
            return false;
        }
        if (peak instanceof IPeakMSD) {
            IPeakMSD peakMSD = (IPeakMSD)peak;
            if (peakMSD.getPeakModel() == null) {
                return false;
            }
            if (peakMSD.getPeakModel().getWidthByInflectionPoints() < this.minimumPeakWidth) {
                return false;
            }
            if (this.isIntegratorOff(peakMSD.getPeakModel().getStartRetentionTime())) {
                return false;
            }
        } else if (peak instanceof IPeakCSD) {
            IPeakCSD peakFID = (IPeakCSD)peak;
            if (peakFID.getPeakModel() == null) {
                return false;
            }
            if (peakFID.getPeakModel().getWidthByInflectionPoints() < this.minimumPeakWidth) {
                return false;
            }
            if (this.isIntegratorOff(peakFID.getPeakModel().getStartRetentionTime())) {
                return false;
            }
        }
        return !(peak instanceof IChromatogramPeakMSD ? (chromatogramPeak = (IChromatogramPeakMSD)peak).getSignalToNoiseRatio() < this.minimumSignalToNoiseRatio : peak instanceof IChromatogramPeakCSD && (chromatogramPeak = (IChromatogramPeakCSD)peak).getSignalToNoiseRatio() < this.minimumSignalToNoiseRatio);
    }
}

