/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors;

import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors.PcaEditor;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class OverviewPage {
    private static final Logger logger = Logger.getLogger(OverviewPage.class);
    private static final int DEFAULT_RETENTION_TIME_WINDOW = 200;
    private PcaEditor pcaEditor;
    private Text retentionTimeWindowText;
    private Spinner principleComponentSpinner;
    private int extractionType;

    public OverviewPage(PcaEditor pcaEditor, TabFolder tabFolder, FormToolkit formToolkit) {
        this.pcaEditor = pcaEditor;
        this.initialize(tabFolder, formToolkit);
    }

    private void initialize(TabFolder tabFolder, FormToolkit formToolkit) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Overview");
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        formToolkit = new FormToolkit(composite.getDisplay());
        ScrolledForm scrolledForm = formToolkit.createScrolledForm(composite);
        Composite scrolledFormComposite = scrolledForm.getBody();
        formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Principle Component Analysis");
        this.createPropertiesSection(scrolledFormComposite, formToolkit);
        this.createExecuteSection(scrolledFormComposite, formToolkit);
        tabItem.setControl((Control)composite);
    }

    public int getExtractionType() {
        return this.extractionType;
    }

    public int getRetentionTimeWindow() {
        int retentionTimeWindow = 200;
        try {
            retentionTimeWindow = Integer.parseInt(this.retentionTimeWindowText.getText().trim());
        }
        catch (NumberFormatException e) {
            logger.warn((Object)e);
        }
        return retentionTimeWindow;
    }

    public int getNumberOfPrincipleComponents() {
        return this.principleComponentSpinner.getSelection();
    }

    private void createPropertiesSection(Composite parent, FormToolkit formToolkit) {
        Section section = formToolkit.createSection(parent, 384);
        section.setText("Properties");
        section.setDescription("Use the properties to define the retention time window and the number of components.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        Label label = formToolkit.createLabel(client, "Select the PCA settings:");
        label.setLayoutData((Object)gridData);
        this.createRetentionTimeWindowText(client, formToolkit);
        this.createPrincipleComponentSpinner(client, formToolkit);
        this.createExtractionTypeButtons(client, formToolkit);
        section.setClient((Control)client);
        formToolkit.paintBordersFor(client);
    }

    private void createRetentionTimeWindowText(Composite client, FormToolkit formToolkit) {
        formToolkit.createLabel(client, "Retention Time Window (milliseconds)");
        this.retentionTimeWindowText = formToolkit.createText(client, Integer.toString(200), 0);
        GridData gridData = new GridData();
        gridData.widthHint = 300;
        this.retentionTimeWindowText.setLayoutData((Object)gridData);
    }

    private void createPrincipleComponentSpinner(Composite client, FormToolkit formToolkit) {
        formToolkit.createLabel(client, "Number of Principle Components");
        this.principleComponentSpinner = new Spinner(client, 0);
        this.principleComponentSpinner.setMinimum(3);
        this.principleComponentSpinner.setMaximum(10);
        this.principleComponentSpinner.setIncrement(1);
        GridData gridData = new GridData();
        gridData.widthHint = 50;
        gridData.heightHint = 20;
        this.principleComponentSpinner.setLayoutData((Object)gridData);
    }

    private void createExtractionTypeButtons(Composite client, FormToolkit formToolkit) {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 30;
        Label radioLabels = formToolkit.createLabel(client, "Select the extraction type:");
        radioLabels.setLayoutData((Object)gridData);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button.getText().equals("Peaks")) {
                    OverviewPage.this.extractionType = 0;
                } else {
                    OverviewPage.this.extractionType = 1;
                }
            }
        };
        Button[] radioButtons = new Button[2];
        radioButtons[0] = new Button(client, 16);
        radioButtons[0].setSelection(true);
        radioButtons[0].setText("Peaks");
        radioButtons[0].setLayoutData((Object)gridData);
        radioButtons[0].addSelectionListener((SelectionListener)selectionListener);
        radioButtons[1] = new Button(client, 16);
        radioButtons[1].setText("Scans");
        radioButtons[1].setLayoutData((Object)gridData);
        radioButtons[1].addSelectionListener((SelectionListener)selectionListener);
    }

    private void createExecuteSection(Composite parent, FormToolkit formToolkit) {
        Section section = formToolkit.createSection(parent, 384);
        section.setText("Evaluation");
        section.setDescription("Run the PCA evaluation after the entries have been edited.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 20;
        gridData.heightHint = 30;
        Label label = formToolkit.createLabel(client, "Select the input chromatograms:\n");
        label.setLayoutData((Object)gridData);
        this.createInputFilesPageHyperlink(client, gridData, formToolkit);
        section.setClient((Control)client);
        formToolkit.paintBordersFor(client);
    }

    private void createInputFilesPageHyperlink(Composite client, GridData gridData, FormToolkit formToolkit) {
        ImageHyperlink imageHyperlink = formToolkit.createImageHyperlink(client, 0);
        imageHyperlink.setImage(ApplicationImageFactory.getInstance().getImage("configure.gif", "16x16"));
        imageHyperlink.setText("Data Input Files");
        imageHyperlink.setLayoutData((Object)gridData);
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OverviewPage.this.pcaEditor.showInputFilesPage();
            }
        });
    }
}

