/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards;

import java.io.File;
import java.util.Date;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.io.CalibrationFileWriter;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.model.IRetentionIndexEntry;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.IRetentionIndexWizardElements;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.PageCalibrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.PageCalibrationTableCSD;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.PageCalibrationTableMSD;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.PagePeakAssignmentCSD;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.PagePeakAssignmentMSD;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.PagePeakSelectionCSD;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.PagePeakSelectionMSD;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.RetentionIndexWizardElements;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.support.ui.wizards.AbstractFileWizard;
import org.eclipse.chemclipse.ux.extension.csd.ui.wizards.ChromatogramInputEntriesWizardPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;

public class WizardCreateRetentionIndexFile
extends AbstractFileWizard {
    public static final int PREFERRED_WIDTH = 300;
    public static final int PREFERRED_HEIGHT = 600;
    private static final Logger logger = Logger.getLogger(WizardCreateRetentionIndexFile.class);
    private IRetentionIndexWizardElements wizardElements = new RetentionIndexWizardElements();
    private static final String CALIBRATION_FILE_EXTENSION = ".cal";
    private static final String CHROMATOGRAM_FILE_EXTENSION = ".ocb";
    private static final String CHROMATOGRAM_CONVERTER_ID = "org.eclipse.chemclipse.xxd.converter.supplier.chemclipse";
    private PageCalibrationSettings pageCalibrationSettings;
    private org.eclipse.chemclipse.ux.extension.msd.ui.wizards.ChromatogramInputEntriesWizardPage pageChromatogramInputEntriesMSD;
    private ChromatogramInputEntriesWizardPage pageChromatogramInputEntriesCSD;
    private PagePeakSelectionMSD pagePeakSelectionMSD;
    private PagePeakSelectionCSD pagePeakSelectionCSD;
    private PagePeakAssignmentMSD pagePeakAssignmentMSD;
    private PagePeakAssignmentCSD pagePeakAssignmentCSD;
    private PageCalibrationTableMSD pageCalibrationTableMSD;
    private PageCalibrationTableCSD pageCalibrationTableCSD;

    public WizardCreateRetentionIndexFile() {
        super("RetentionIndices_" + new Date().getTime(), CALIBRATION_FILE_EXTENSION);
    }

    public void addPages() {
        super.addPages();
        this.pageCalibrationSettings = new PageCalibrationSettings(this.wizardElements);
        this.pageChromatogramInputEntriesMSD = new org.eclipse.chemclipse.ux.extension.msd.ui.wizards.ChromatogramInputEntriesWizardPage(this.wizardElements.getChromatogramWizardElementsMSD());
        this.pageChromatogramInputEntriesCSD = new ChromatogramInputEntriesWizardPage(this.wizardElements.getChromatogramWizardElementsCSD());
        this.pagePeakSelectionMSD = new PagePeakSelectionMSD(this.wizardElements);
        this.pagePeakSelectionCSD = new PagePeakSelectionCSD(this.wizardElements);
        this.pagePeakAssignmentMSD = new PagePeakAssignmentMSD(this.wizardElements);
        this.pagePeakAssignmentCSD = new PagePeakAssignmentCSD(this.wizardElements);
        this.pageCalibrationTableMSD = new PageCalibrationTableMSD(this.wizardElements);
        this.pageCalibrationTableCSD = new PageCalibrationTableCSD(this.wizardElements);
        this.addPage((IWizardPage)this.pageCalibrationSettings);
        this.addPage((IWizardPage)this.pageChromatogramInputEntriesMSD);
        this.addPage((IWizardPage)this.pageChromatogramInputEntriesCSD);
        this.addPage((IWizardPage)this.pagePeakSelectionMSD);
        this.addPage((IWizardPage)this.pagePeakSelectionCSD);
        this.addPage((IWizardPage)this.pagePeakAssignmentMSD);
        this.addPage((IWizardPage)this.pagePeakAssignmentCSD);
        this.addPage((IWizardPage)this.pageCalibrationTableMSD);
        this.addPage((IWizardPage)this.pageCalibrationTableCSD);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        Object nextPage = super.getNextPage(page);
        if (page == this.pageCalibrationSettings) {
            nextPage = this.wizardElements.isUseMassSpectrometryData() ? this.pageChromatogramInputEntriesMSD : this.pageChromatogramInputEntriesCSD;
        } else if (page == this.pageChromatogramInputEntriesMSD) {
            nextPage = this.pagePeakSelectionMSD;
        } else if (page == this.pageChromatogramInputEntriesCSD) {
            nextPage = this.pagePeakSelectionCSD;
        } else if (page == this.pagePeakSelectionMSD) {
            nextPage = this.pagePeakAssignmentMSD;
        } else if (page == this.pagePeakSelectionCSD) {
            nextPage = this.pagePeakAssignmentCSD;
        } else if (page == this.pagePeakAssignmentMSD) {
            nextPage = this.pageCalibrationTableMSD;
        } else if (page == this.pagePeakAssignmentCSD) {
            nextPage = this.pageCalibrationTableCSD;
        } else if (page == this.pageCalibrationTableMSD || page == this.pageCalibrationTableCSD) {
            nextPage = null;
        }
        this.setPreviousPages();
        return nextPage;
    }

    private void setPreviousPages() {
        if (this.wizardElements.isUseMassSpectrometryData()) {
            this.pageCalibrationTableMSD.setPreviousPage((IWizardPage)this.pagePeakAssignmentMSD);
        } else {
            this.pageCalibrationTableCSD.setPreviousPage((IWizardPage)this.pagePeakAssignmentCSD);
        }
        this.pagePeakAssignmentMSD.setPreviousPage((IWizardPage)this.pagePeakSelectionMSD);
        this.pagePeakAssignmentCSD.setPreviousPage((IWizardPage)this.pagePeakSelectionCSD);
        this.pagePeakSelectionMSD.setPreviousPage((IWizardPage)this.pageChromatogramInputEntriesMSD);
        this.pagePeakSelectionCSD.setPreviousPage((IWizardPage)this.pageChromatogramInputEntriesCSD);
        this.pageChromatogramInputEntriesMSD.setPreviousPage((IWizardPage)this.pageCalibrationSettings);
        this.pageChromatogramInputEntriesCSD.setPreviousPage((IWizardPage)this.pageCalibrationSettings);
    }

    public boolean canFinish() {
        boolean canFinish = this.pageCalibrationSettings.canFinish();
        if (canFinish) {
            if (this.wizardElements.isUseMassSpectrometryData()) {
                canFinish = this.wizardElements.getChromatogramWizardElementsMSD().getSelectedChromatograms().size() > 0;
            } else {
                boolean bl = canFinish = this.wizardElements.getChromatogramWizardElementsCSD().getSelectedChromatograms().size() > 0;
            }
        }
        if (canFinish) {
            canFinish = this.pagePeakSelectionMSD.canFinish();
        }
        if (canFinish) {
            canFinish = this.pagePeakAssignmentMSD.canFinish();
        }
        if (canFinish) {
            canFinish = this.wizardElements.isRetentionIndexDataValidated();
        }
        return canFinish;
    }

    public void doFinish(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Create Chromatogram Evaluation", -1);
        IFile file = super.prepareProject(monitor);
        try {
            List<IRetentionIndexEntry> retentionIndexEntries = this.wizardElements.getExtractedRetentionIndexEntries();
            File calibrationFile = file.getLocation().toFile();
            if (!calibrationFile.getAbsolutePath().endsWith(CALIBRATION_FILE_EXTENSION)) {
                calibrationFile = new File(String.valueOf(calibrationFile.getAbsolutePath()) + CALIBRATION_FILE_EXTENSION);
            }
            CalibrationFileWriter calibrationFileWriter = new CalibrationFileWriter();
            calibrationFileWriter.write(calibrationFile, retentionIndexEntries);
            String path = calibrationFile.getAbsolutePath();
            File chromatogramFile = new File(String.valueOf(path.substring(0, path.length() - CALIBRATION_FILE_EXTENSION.length())) + CHROMATOGRAM_FILE_EXTENSION);
            if (this.wizardElements.isUseMassSpectrometryData()) {
                IChromatogramMSD chromatogramMSD = this.wizardElements.getChromatogramSelectionMSD().getChromatogramMSD();
                ChromatogramConverterMSD.convert((File)chromatogramFile, (IChromatogramMSD)chromatogramMSD, (String)CHROMATOGRAM_CONVERTER_ID, (IProgressMonitor)monitor);
            } else {
                IChromatogramCSD chromatogramCSD = this.wizardElements.getChromatogramSelectionCSD().getChromatogramCSD();
                ChromatogramConverterCSD.convert((File)chromatogramFile, (IChromatogramCSD)chromatogramCSD, (String)CHROMATOGRAM_CONVERTER_ID, (IProgressMonitor)monitor);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
        super.refreshWorkspace(monitor);
        super.runOpenEditor(file, monitor);
    }
}

