/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.core.IPeakQuantifierSupplier;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.core.IPeakQuantifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.exceptions.NoPeakQuantifierAvailableException;

public class PeakQuantifierSupport
implements IPeakQuantifierSupport {
    private List<IPeakQuantifierSupplier> suppliers = new ArrayList<IPeakQuantifierSupplier>();

    protected void add(IPeakQuantifierSupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public List<String> getAvailablePeakQuantifierIds() throws NoPeakQuantifierAvailableException {
        this.arePeakQuantifierStored();
        ArrayList<String> availableDetectors = new ArrayList<String>();
        for (IPeakQuantifierSupplier supplier : this.suppliers) {
            availableDetectors.add(supplier.getId());
        }
        return availableDetectors;
    }

    @Override
    public IPeakQuantifierSupplier getPeakQuantifierSupplier(String quantifierId) throws NoPeakQuantifierAvailableException {
        IPeakQuantifierSupplier detectorSupplier = null;
        this.arePeakQuantifierStored();
        if (quantifierId == null || quantifierId.equals("")) {
            throw new NoPeakQuantifierAvailableException("There is no peak quantifier available with the following id: " + quantifierId + ".");
        }
        for (IPeakQuantifierSupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(quantifierId)) continue;
            detectorSupplier = supplier;
            break;
        }
        if (detectorSupplier == null) {
            throw new NoPeakQuantifierAvailableException("There is no peak quantifier available with the following id: " + quantifierId + ".");
        }
        return detectorSupplier;
    }

    @Override
    public String getPeakQuantifierId(int index) throws NoPeakQuantifierAvailableException {
        this.arePeakQuantifierStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoPeakQuantifierAvailableException("There is no peak quantifier available with the following id: " + index + ".");
        }
        IPeakQuantifierSupplier supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String[] getPeakQuantifierNames() throws NoPeakQuantifierAvailableException {
        this.arePeakQuantifierStored();
        ArrayList<String> detectorNames = new ArrayList<String>();
        for (IPeakQuantifierSupplier supplier : this.suppliers) {
            detectorNames.add(supplier.getPeakQuantifierName());
        }
        return detectorNames.toArray(new String[detectorNames.size()]);
    }

    private void arePeakQuantifierStored() throws NoPeakQuantifierAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoPeakQuantifierAvailableException();
        }
    }
}

