/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.IVendorScan;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.VendorIon;
import org.eclipse.chemclipse.msd.model.core.AbstractVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;

public class VendorScan
extends AbstractVendorMassSpectrum
implements IVendorScan {
    private static final long serialVersionUID = -2003018665770498972L;
    private static final Logger logger = Logger.getLogger(VendorScan.class);

    public int getMaxPossibleIons() {
        return 65535;
    }

    public int getMinPossibleRetentionTime() {
        return 0;
    }

    public int getMaxPossibleRetentionTime() {
        return Integer.MAX_VALUE;
    }

    public IVendorScan makeDeepCopy() throws CloneNotSupportedException {
        IVendorScan massSpectrum = (IVendorScan)super.clone();
        for (IIon ion : this.getIons()) {
            try {
                VendorIon chemClipseIon = new VendorIon(ion.getIon(), ion.getAbundance());
                massSpectrum.addIon((IIon)chemClipseIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        return massSpectrum;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.makeDeepCopy();
    }
}

