/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.msd.converter.io.IPeakReader;
import org.eclipse.chemclipse.msd.converter.processing.peak.IPeakImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.AbstractZipReader;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.PeakReader_0701;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.PeakReader_0801;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.PeakReader_0802;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.PeakReader_0803;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.PeakReader_0901;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.PeakReader_0902;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.PeakReader_0903;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.PeakReader_1001;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.PeakReader_1002;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.PeakReader_1003;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.PeakReader_1004;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.PeakReader_1005;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.PeakReader_1006;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.PeakReader_1007;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.PeakReader_1100;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.ReaderHelper;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakReaderMSD
implements IPeakReader {
    public IPeakImportConverterProcessingInfo read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IPeakImportConverterProcessingInfo processingInfo = null;
        ReaderHelper readerHelper = new ReaderHelper();
        String version = readerHelper.getVersion(file);
        AbstractZipReader peakReader = null;
        if (version.equals("0.7.0.1")) {
            peakReader = new PeakReader_0701();
        } else if (version.equals("0.8.0.1")) {
            peakReader = new PeakReader_0801();
        } else if (version.equals("0.8.0.2")) {
            peakReader = new PeakReader_0802();
        } else if (version.equals("0.8.0.3")) {
            peakReader = new PeakReader_0803();
        } else if (version.equals("0.9.0.1")) {
            peakReader = new PeakReader_0901();
        } else if (version.equals("0.9.0.2")) {
            peakReader = new PeakReader_0902();
        } else if (version.equals("0.9.0.3")) {
            peakReader = new PeakReader_0903();
        } else if (version.equals("1.0.0.1")) {
            peakReader = new PeakReader_1001();
        } else if (version.equals("1.0.0.2")) {
            peakReader = new PeakReader_1002();
        } else if (version.equals("1.0.0.3")) {
            peakReader = new PeakReader_1003();
        } else if (version.equals("1.0.0.4")) {
            peakReader = new PeakReader_1004();
        } else if (version.equals("1.0.0.5")) {
            peakReader = new PeakReader_1005();
        } else if (version.equals("1.0.0.6")) {
            peakReader = new PeakReader_1006();
        } else if (version.equals("1.0.0.7")) {
            peakReader = new PeakReader_1007();
        } else if (version.equals("1.1.0.0")) {
            peakReader = new PeakReader_1100();
        }
        if (peakReader != null) {
            processingInfo = peakReader.read(file, monitor);
        }
        return processingInfo;
    }
}

