/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.io.ChromatogramReaderCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.converter.io.AbstractChromatogramMSDReader;
import org.eclipse.chemclipse.msd.converter.io.IChromatogramMSDReader;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.AbstractChromatogramReader;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ChromatogramReader_0701;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ChromatogramReader_0801;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ChromatogramReader_0802;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ChromatogramReader_0803;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ChromatogramReader_0901;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ChromatogramReader_0902;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ChromatogramReader_0903;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1001;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1002;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1003;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1004;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1005;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1006;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1007;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1100;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.VendorChromatogram;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.VendorIon;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.VendorScan;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.ReaderHelper;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class ChromatogramReaderMSD
extends AbstractChromatogramMSDReader
implements IChromatogramMSDReader {
    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramOverview chromatogramOverview = null;
        ReaderHelper readerHelper = new ReaderHelper();
        String version = readerHelper.getVersion(file);
        AbstractChromatogramReader chromatogramReader = null;
        if (version.equals("0.7.0.1")) {
            chromatogramReader = new ChromatogramReader_0701();
        } else if (version.equals("0.8.0.1")) {
            chromatogramReader = new ChromatogramReader_0801();
        } else if (version.equals("0.8.0.2")) {
            chromatogramReader = new ChromatogramReader_0802();
        } else if (version.equals("0.8.0.3")) {
            chromatogramReader = new ChromatogramReader_0803();
        } else if (version.equals("0.9.0.1")) {
            chromatogramReader = new ChromatogramReader_0901();
        } else if (version.equals("0.9.0.2")) {
            chromatogramReader = new ChromatogramReader_0902();
        } else if (version.equals("0.9.0.3")) {
            chromatogramReader = new ChromatogramReader_0903();
        } else if (version.equals("1.0.0.1")) {
            chromatogramReader = new ChromatogramReader_1001();
        } else if (version.equals("1.0.0.2")) {
            chromatogramReader = new ChromatogramReader_1002();
        } else if (version.equals("1.0.0.3")) {
            chromatogramReader = new ChromatogramReader_1003();
        } else if (version.equals("1.0.0.4")) {
            chromatogramReader = new ChromatogramReader_1004();
        } else if (version.equals("1.0.0.5")) {
            chromatogramReader = new ChromatogramReader_1005();
        } else if (version.equals("1.0.0.6")) {
            chromatogramReader = new ChromatogramReader_1006();
        } else if (version.equals("1.0.0.7")) {
            chromatogramReader = new ChromatogramReader_1007();
        } else if (version.equals("1.1.0.0")) {
            chromatogramReader = new ChromatogramReader_1100();
        }
        if (chromatogramReader != null) {
            try {
                chromatogramOverview = chromatogramReader.readOverview(file, monitor);
            }
            catch (Exception exception) {
                chromatogramOverview = this.createChromatogramMSDFromFID(0.0, file, monitor);
            }
        } else {
            chromatogramOverview = this.createChromatogramMSDFromFID(0.0, file, monitor);
        }
        return chromatogramOverview;
    }

    public IChromatogramMSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramMSD chromatogramMSD;
        ReaderHelper readerHelper = new ReaderHelper();
        String version = readerHelper.getVersion(file);
        AbstractChromatogramReader chromatogramReader = null;
        if (version.equals("0.7.0.1")) {
            chromatogramReader = new ChromatogramReader_0701();
        } else if (version.equals("0.8.0.1")) {
            chromatogramReader = new ChromatogramReader_0801();
        } else if (version.equals("0.8.0.2")) {
            chromatogramReader = new ChromatogramReader_0802();
        } else if (version.equals("0.8.0.3")) {
            chromatogramReader = new ChromatogramReader_0803();
        } else if (version.equals("0.9.0.1")) {
            chromatogramReader = new ChromatogramReader_0901();
        } else if (version.equals("0.9.0.2")) {
            chromatogramReader = new ChromatogramReader_0902();
        } else if (version.equals("0.9.0.3")) {
            chromatogramReader = new ChromatogramReader_0903();
        } else if (version.equals("1.0.0.1")) {
            chromatogramReader = new ChromatogramReader_1001();
        } else if (version.equals("1.0.0.2")) {
            chromatogramReader = new ChromatogramReader_1002();
        } else if (version.equals("1.0.0.3")) {
            chromatogramReader = new ChromatogramReader_1003();
        } else if (version.equals("1.0.0.4")) {
            chromatogramReader = new ChromatogramReader_1004();
        } else if (version.equals("1.0.0.5")) {
            chromatogramReader = new ChromatogramReader_1005();
        } else if (version.equals("1.0.0.6")) {
            chromatogramReader = new ChromatogramReader_1006();
        } else if (version.equals("1.0.0.7")) {
            chromatogramReader = new ChromatogramReader_1007();
        } else if (version.equals("1.1.0.0")) {
            chromatogramReader = new ChromatogramReader_1100();
        }
        if (chromatogramReader != null) {
            try {
                chromatogramMSD = chromatogramReader.read(file, monitor);
            }
            catch (Exception exception) {
                chromatogramMSD = this.createChromatogramMSDFromFID(18.0, file, monitor);
            }
        } else {
            chromatogramMSD = this.createChromatogramMSDFromFID(18.0, file, monitor);
        }
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        boolean useScanProxies = preferences.getBoolean("useScanProxies", false);
        boolean loadScanProxiesInBackground = preferences.getBoolean("loadScanProxiesInBackground", false);
        int minBytesToLoadInBackground = preferences.getInt("minBytesToLoadInBackground", 2000000);
        if (useScanProxies && loadScanProxiesInBackground && file.length() > (long)minBytesToLoadInBackground) {
            final IChromatogramMSD chromatogram = chromatogramMSD;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    chromatogram.enforceLoadScanProxies((IProgressMonitor)new NullProgressMonitor());
                }
            });
            t.start();
        }
        return chromatogramMSD;
    }

    private IChromatogramMSD createChromatogramMSDFromFID(double mz, File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        ChromatogramReaderCSD chromatogramReaderFID;
        IChromatogramCSD chromatogramFID;
        VendorChromatogram chromatogramMSD = null;
        if (PreferenceSupplier.isForceLoadAlternateDetector() && (chromatogramFID = (chromatogramReaderFID = new ChromatogramReaderCSD()).read(file, monitor)) != null) {
            int startRetentionTime;
            chromatogramMSD = new VendorChromatogram();
            for (IScan scan : chromatogramFID.getScans()) {
                VendorScan massSpectrum = new VendorScan();
                massSpectrum.setRetentionTime(scan.getRetentionTime());
                massSpectrum.setRetentionIndex(scan.getRetentionIndex());
                try {
                    VendorIon ion = new VendorIon(mz, scan.getTotalSignal());
                    massSpectrum.addIon((IIon)ion);
                }
                catch (Exception exception) {}
                chromatogramMSD.addScan((IScan)massSpectrum);
            }
            chromatogramMSD.setConverterId("org.eclipse.chemclipse.xxd.converter.supplier.chemclipse");
            File fileConverted = new File(file.getAbsolutePath().replace(".ocb", "-fromFID.ocb"));
            chromatogramMSD.setFile(fileConverted);
            int scanDelay = startRetentionTime = chromatogramMSD.getStartRetentionTime();
            chromatogramMSD.setScanDelay(scanDelay);
            int endRetentionTime = chromatogramMSD.getStopRetentionTime();
            int scanInterval = endRetentionTime / chromatogramMSD.getNumberOfScans();
            chromatogramMSD.setScanInterval(scanInterval);
        }
        return chromatogramMSD;
    }
}

