/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences.editors;

import java.util.Arrays;
import org.eclipse.chemclipse.support.l10n.Messages;
import org.eclipse.chemclipse.support.messages.SupportMessages;
import org.eclipse.chemclipse.support.ui.preferences.editors.InstrumentInputValidator;
import org.eclipse.chemclipse.support.util.InstrumentListUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class InstrumentListEditor
extends ListEditor {
    public InstrumentListEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.initialize(parent);
    }

    protected String createList(String[] items) {
        InstrumentListUtil instrumentListUtil = new InstrumentListUtil();
        return instrumentListUtil.createList(items);
    }

    protected String getNewInputObject() {
        List list = this.getList();
        Messages messages = SupportMessages.INSTANCE();
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), messages.getMessage("labelInstrumentName", new String[0]), messages.getMessage("labelAddInstrument", new String[]{"API 5000"}), "", (IInputValidator)new InstrumentInputValidator(list));
        dialog.create();
        if (dialog.open() == 0) {
            String instrument = dialog.getValue();
            return this.addInstrument(instrument, list);
        }
        return null;
    }

    private void initialize(Composite parent) {
        final Messages messages = SupportMessages.INSTANCE();
        Composite composite = this.getButtonBoxControl(parent);
        Button button = new Button(composite, 8);
        button.setText(messages.getMessage("labelClearInstruments", new String[0]));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = InstrumentListEditor.this.getList();
                if (list != null) {
                    Shell shell = Display.getCurrent().getActiveShell();
                    MessageBox messageBox = new MessageBox(shell, 448);
                    messageBox.setText(messages.getMessage("labelDeleteInstrument", new String[0]));
                    messageBox.setMessage(messages.getMessage("labelQuestionDeleteInstruments", new String[0]));
                    int decision = messageBox.open();
                    if (decision == 64) {
                        list.removeAll();
                    }
                }
            }
        });
    }

    private String addInstrument(String instrument, List list) {
        String[] items = list.getItems();
        if (!this.itemExistsInList(instrument, items)) {
            return instrument;
        }
        return null;
    }

    private boolean itemExistsInList(String instrument, String[] list) {
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(instrument)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected String[] parseString(String stringList) {
        InstrumentListUtil instrumentListUtil = new InstrumentListUtil();
        Object[] instruments = instrumentListUtil.parseString(stringList);
        Arrays.sort(instruments);
        return instruments;
    }
}

