/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.IMassSpectrumFilterSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.IMassSpectrumFilterSupport;
import org.eclipse.chemclipse.chromatogram.msd.filter.exceptions.NoMassSpectrumFilterSupplierAvailableException;

public class MassSpectrumFilterSupport
implements IMassSpectrumFilterSupport {
    private List<IMassSpectrumFilterSupplier> suppliers = new ArrayList<IMassSpectrumFilterSupplier>();

    protected void add(IMassSpectrumFilterSupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public List<String> getAvailableFilterIds() throws NoMassSpectrumFilterSupplierAvailableException {
        this.areMassSpectrumFiltersStored();
        ArrayList<String> availableFilters = new ArrayList<String>();
        for (IMassSpectrumFilterSupplier supplier : this.suppliers) {
            availableFilters.add(supplier.getId());
        }
        return availableFilters;
    }

    @Override
    public String getFilterId(int index) throws NoMassSpectrumFilterSupplierAvailableException {
        this.areMassSpectrumFiltersStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoMassSpectrumFilterSupplierAvailableException("There is no mass spectrum filter available with the following id: " + index + ".");
        }
        IMassSpectrumFilterSupplier supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String[] getFilterNames() throws NoMassSpectrumFilterSupplierAvailableException {
        this.areMassSpectrumFiltersStored();
        ArrayList<String> filterNames = new ArrayList<String>();
        for (IMassSpectrumFilterSupplier supplier : this.suppliers) {
            filterNames.add(supplier.getFilterName());
        }
        return filterNames.toArray(new String[filterNames.size()]);
    }

    @Override
    public IMassSpectrumFilterSupplier getFilterSupplier(String filterId) throws NoMassSpectrumFilterSupplierAvailableException {
        IMassSpectrumFilterSupplier filterSupplier = null;
        this.areMassSpectrumFiltersStored();
        if (filterId == null || filterId.equals("")) {
            throw new NoMassSpectrumFilterSupplierAvailableException("There is no mass spectrum filter supplier available with the following id: " + filterId + ".");
        }
        for (IMassSpectrumFilterSupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(filterId)) continue;
            filterSupplier = supplier;
            break;
        }
        if (filterSupplier == null) {
            throw new NoMassSpectrumFilterSupplierAvailableException("There is no mass spectrum filter supplier available with the following id: " + filterId + ".");
        }
        return filterSupplier;
    }

    private void areMassSpectrumFiltersStored() throws NoMassSpectrumFilterSupplierAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoMassSpectrumFilterSupplierAvailableException();
        }
    }
}

