/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResult;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ChromatogramIntegrationResultsLabelProvider
extends AbstractChemClipseLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IChromatogramIntegrationResult) {
            IChromatogramIntegrationResult chromatogramIntegrationResult = (IChromatogramIntegrationResult)element;
            switch (columnIndex) {
                case 0: {
                    text = decimalFormat.format(chromatogramIntegrationResult.getChromatogramArea());
                    break;
                }
                case 1: {
                    text = decimalFormat.format(chromatogramIntegrationResult.getBackgroundArea());
                    break;
                }
                case 2: {
                    double ion = chromatogramIntegrationResult.getIon();
                    if (ion == 0.0) {
                        text = "TIC";
                        break;
                    }
                    text = decimalFormat.format(ion);
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("peak.gif", "16x16");
    }
}

