/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.ui.internal.handler;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.ui.internal.handler.PeakIntegrationSettingsSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.PeakIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IPeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.IPeakIntegratorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.notifier.IntegrationResultUpdateNotifier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class PeakIntegratorRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(PeakIntegratorRunnable.class);
    private static final String PEAK_INTEGRATOR_ID = "org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.peakIntegrator";
    private IChromatogramSelectionMSD chromatogramSelection;

    public PeakIntegratorRunnable(IChromatogramSelectionMSD chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("PeakMax Integrator", -1);
            PeakIntegrationSettingsSupport peakIntegrationSettingsSupport = new PeakIntegrationSettingsSupport();
            IPeakIntegrationSettings peakIntegrationSettings = peakIntegrationSettingsSupport.getPeakIntegrationSettings();
            IPeakIntegratorProcessingInfo processingInfo = PeakIntegrator.integrate((IChromatogramSelection)this.chromatogramSelection, (IPeakIntegrationSettings)peakIntegrationSettings, (String)PEAK_INTEGRATOR_ID, (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((IProcessingInfo)processingInfo, (boolean)false);
            try {
                IPeakIntegrationResults peakIntegrationResults = processingInfo.getPeakIntegrationResults();
                IntegrationResultUpdateNotifier.fireUpdateChange((IPeakIntegrationResults)peakIntegrationResults);
                this.updateSelection();
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void updateSelection() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PeakIntegratorRunnable.this.chromatogramSelection instanceof ChromatogramSelectionMSD) {
                    ((ChromatogramSelectionMSD)PeakIntegratorRunnable.this.chromatogramSelection).update(false);
                }
            }
        });
    }
}

