/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.core;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.processing.ChromatogramFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.processing.IChromatogramFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.result.IChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.AbstractChromatogramFilterMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.exceptions.FilterException;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.internal.core.support.Denoising;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.result.DenoisingFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.settings.ISupplierFilterSettings;
import org.eclipse.chemclipse.model.support.SegmentWidth;
import org.eclipse.chemclipse.msd.model.core.ICombinedMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramFilter
extends AbstractChromatogramFilterMSD {
    private IMarkedIons ionsToRemove;
    private IMarkedIons ionsToPreserve;
    private boolean adjustThresholdTransitions;
    private int numberOfUsedIonsForCoefficient;
    private SegmentWidth segmentWidth;

    public IChromatogramFilterProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        DenoisingFilterResult chromatogramFilterResult;
        ChromatogramFilterProcessingInfo processingInfo = new ChromatogramFilterProcessingInfo();
        processingInfo.addMessages(this.validate(chromatogramSelection, chromatogramFilterSettings));
        if (processingInfo.hasErrorMessages()) {
            return processingInfo;
        }
        this.setFilterSettings(chromatogramFilterSettings);
        try {
            List<ICombinedMassSpectrum> noiseMassSpectra = Denoising.applyDenoisingFilter(chromatogramSelection, this.ionsToRemove, this.ionsToPreserve, this.adjustThresholdTransitions, this.numberOfUsedIonsForCoefficient, this.segmentWidth, monitor);
            chromatogramFilterResult = new DenoisingFilterResult(ResultStatus.OK, "The chromatogram selection has been denoised successfully.", noiseMassSpectra);
        }
        catch (FilterException e) {
            chromatogramFilterResult = new DenoisingFilterResult(ResultStatus.EXCEPTION, e.getMessage());
        }
        processingInfo.setChromatogramFilterResult((IChromatogramFilterResult)chromatogramFilterResult);
        return processingInfo;
    }

    public IChromatogramFilterProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) {
        IChromatogramFilterSettings chromatogramFilterSettings = PreferenceSupplier.getChromatogramFilterSettings();
        return this.applyFilter(chromatogramSelection, chromatogramFilterSettings, monitor);
    }

    private void setFilterSettings(IChromatogramFilterSettings chromatogramFilterSettings) {
        if (chromatogramFilterSettings instanceof ISupplierFilterSettings) {
            IMarkedIons ionsToPreserve;
            ISupplierFilterSettings settings = (ISupplierFilterSettings)chromatogramFilterSettings;
            IMarkedIons ionsToRemove = settings.getIonsToRemove();
            if (ionsToRemove != null) {
                this.ionsToRemove = ionsToRemove;
            }
            if ((ionsToPreserve = settings.getIonsToPreserve()) != null) {
                this.ionsToPreserve = ionsToPreserve;
            }
            this.adjustThresholdTransitions = settings.getAdjustThresholdTransitions();
            this.numberOfUsedIonsForCoefficient = settings.getNumberOfUsedIonsForCoefficient();
            this.segmentWidth = settings.getSegmentWidth();
        }
    }
}

