/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.examples;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.Sample;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.PlotArea;
import org.eclipse.nebula.visualization.xygraph.figures.ToolbarArmedXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.ZoomType;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ComprehensiveExample {
    public static void main(String[] args) {
        Shell shell = new Shell();
        shell.setSize(800, 500);
        shell.open();
        LightweightSystem lws = new LightweightSystem((Canvas)shell);
        final ToolbarArmedXYGraph toolbarArmedXYGraph = ComprehensiveExample.createXYGraph();
        lws.setContents((IFigure)toolbarArmedXYGraph);
        shell.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(org.eclipse.swt.events.MouseEvent e) {
                IFigure figureUnderMouse = toolbarArmedXYGraph.findFigureAt(e.x, e.y, new TreeSearch(){

                    public boolean prune(IFigure figure) {
                        return false;
                    }

                    public boolean accept(IFigure figure) {
                        return figure instanceof Axis || figure instanceof PlotArea;
                    }
                });
                if (figureUnderMouse instanceof Axis) {
                    Axis axis;
                    double valuePosition = axis.getPositionValue((axis = (Axis)figureUnderMouse).isHorizontal() ? e.x : e.y, false);
                    axis.zoomInOut(valuePosition, (double)e.count * 0.1 / 3.0);
                } else if (figureUnderMouse instanceof PlotArea) {
                    PlotArea plotArea = (PlotArea)figureUnderMouse;
                    plotArea.zoomInOut(true, true, e.x, e.y, (double)e.count * 0.1 / 3.0);
                }
            }
        });
        shell.setText("Comprehensive Example");
        Display display = Display.getDefault();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private static ToolbarArmedXYGraph createXYGraph() {
        final XYGraph xyGraph = new XYGraph();
        xyGraph.setTitle("XY Graph Test");
        xyGraph.setFont(XYGraphMediaFactory.getInstance().getFont(XYGraphMediaFactory.FONT_TAHOMA));
        xyGraph.getPrimaryXAxis().setTitle("Time");
        xyGraph.getPrimaryYAxis().setTitle("Amplitude");
        xyGraph.getPrimaryXAxis().setRange(new Range(0.0, 200.0));
        xyGraph.getPrimaryXAxis().setDateEnabled(true);
        xyGraph.getPrimaryYAxis().setAutoScale(true);
        xyGraph.getPrimaryXAxis().setAutoScale(true);
        xyGraph.getPrimaryXAxis().setShowMajorGrid(true);
        xyGraph.getPrimaryYAxis().setShowMajorGrid(true);
        xyGraph.getPrimaryXAxis().setAutoScaleThreshold(0.0);
        Axis x2Axis = new Axis("X-2", false);
        x2Axis.setTickLableSide(AbstractScale.LabelSide.Secondary);
        xyGraph.addAxis(x2Axis);
        Axis y2Axis = new Axis("Log Scale", true);
        y2Axis.setRange(10.0, 500.0);
        y2Axis.setLogScale(true);
        y2Axis.setForegroundColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_PINK));
        y2Axis.setTickLableSide(AbstractScale.LabelSide.Secondary);
        xyGraph.addAxis(y2Axis);
        Axis y3Axis = new Axis("Y-3", true);
        y3Axis.setForegroundColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_BLUE));
        y3Axis.setTickLableSide(AbstractScale.LabelSide.Secondary);
        y3Axis.setRange(new Range(-2.0, 3.0));
        y3Axis.setShowMajorGrid(false);
        y3Axis.setAutoScale(true);
        final CircularBufferDataProvider trace2Provider = new CircularBufferDataProvider(true);
        trace2Provider.setBufferSize(100);
        trace2Provider.setUpdateDelay(100);
        Trace trace2 = new Trace("Trace 2", xyGraph.getPrimaryXAxis(), xyGraph.getPrimaryYAxis(), trace2Provider);
        trace2.setDataProvider(trace2Provider);
        trace2.setTraceType(Trace.TraceType.SOLID_LINE);
        trace2.setLineWidth(1);
        trace2.setPointStyle(Trace.PointStyle.POINT);
        trace2.setPointSize(4);
        trace2.setBaseLine(Trace.BaseLine.NEGATIVE_INFINITY);
        trace2.setAreaAlpha(100);
        trace2.setAntiAliasing(true);
        trace2.setErrorBarEnabled(false);
        trace2.setYErrorBarType(Trace.ErrorBarType.BOTH);
        trace2.setXErrorBarType(Trace.ErrorBarType.NONE);
        trace2.setErrorBarCapWidth(3);
        final CircularBufferDataProvider trace3Provider = new CircularBufferDataProvider(true);
        Trace trace3 = new Trace("Trace3", xyGraph.getPrimaryXAxis(), xyGraph.getPrimaryYAxis(), trace3Provider);
        trace3.setPointStyle(Trace.PointStyle.XCROSS);
        trace3.setTraceType(Trace.TraceType.BAR);
        trace3.setLineWidth(4);
        trace3Provider.setUpdateDelay(100);
        xyGraph.addTrace(trace3);
        xyGraph.addTrace(trace2);
        final CircularBufferDataProvider trace4Provider = new CircularBufferDataProvider(false);
        Trace trace4 = new Trace("Trace 4-Lissajous", x2Axis, y2Axis, trace4Provider);
        trace4.setPointSize(2);
        trace4Provider.setUpdateDelay(100);
        trace4Provider.setBufferSize(100);
        xyGraph.addTrace(trace4);
        ToolbarArmedXYGraph toolbarArmedXYGraph = new ToolbarArmedXYGraph((IXYGraph)xyGraph);
        xyGraph.setFocusTraversable(true);
        xyGraph.setRequestFocusEnabled(true);
        xyGraph.getPlotArea().addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                xyGraph.requestFocus();
            }
        });
        xyGraph.addKeyListener((KeyListener)new KeyListener.Stub(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getState() == 262144 && ke.keycode == 122) {
                    xyGraph.getOperationsManager().undo();
                }
                if (ke.getState() == 262144 && ke.keycode == 121) {
                    xyGraph.getOperationsManager().redo();
                }
                if (ke.getState() == 262144 && ke.keycode == 120) {
                    xyGraph.performAutoScale();
                }
                if (ke.getState() == 262144 && ke.keycode == 115) {
                    ImageLoader loader = new ImageLoader();
                    loader.data = new ImageData[]{xyGraph.getImage().getImageData()};
                    FileDialog dialog = new FileDialog(Display.getDefault().getShells()[0], 8192);
                    dialog.setFilterNames(new String[]{"PNG Files", "All Files (*.*)"});
                    dialog.setFilterExtensions(new String[]{"*.png", "*.*"});
                    String path = dialog.open();
                    if (path != null && !path.equals("")) {
                        loader.save(path, 5);
                    }
                }
                if (ke.getState() == 262144 && ke.keycode + 97 - 97 == 116) {
                    switch (xyGraph.getZoomType()) {
                        case RUBBERBAND_ZOOM: {
                            xyGraph.setZoomType(ZoomType.HORIZONTAL_ZOOM);
                            break;
                        }
                        case HORIZONTAL_ZOOM: {
                            xyGraph.setZoomType(ZoomType.VERTICAL_ZOOM);
                            break;
                        }
                        case VERTICAL_ZOOM: {
                            xyGraph.setZoomType(ZoomType.ZOOM_IN);
                            break;
                        }
                        case ZOOM_IN: {
                            xyGraph.setZoomType(ZoomType.ZOOM_OUT);
                            break;
                        }
                        case ZOOM_OUT: {
                            xyGraph.setZoomType(ZoomType.PANNING);
                            break;
                        }
                        case PANNING: {
                            xyGraph.setZoomType(ZoomType.NONE);
                            break;
                        }
                        case NONE: {
                            xyGraph.setZoomType(ZoomType.RUBBERBAND_ZOOM);
                            break;
                        }
                    }
                }
            }
        });
        Runnable updater = new Runnable(){
            private double updateIndex;
            private long t = System.currentTimeMillis();
            private boolean running = true;

            @Override
            public void run() {
                this.t += 60000L;
                trace3Provider.setCurrentYData(Math.cos(this.updateIndex), this.t);
                if (this.updateIndex >= 10.0 && this.updateIndex <= 10.5 || this.updateIndex >= 20.0 && this.updateIndex <= 20.2) {
                    trace2Provider.addSample(new Sample(this.t, Double.NaN));
                    this.running = false;
                } else {
                    Sample sampe = new Sample(this.t, Math.sin(this.updateIndex), 0.1 * Math.random(), 0.1 * Math.random(), (double)this.t * 1.0E-7 * Math.random(), (double)this.t * 1.0E-7 * Math.random(), "sdfsf");
                    trace2Provider.addSample(sampe);
                }
                trace2Provider.setCurrentYDataTimestamp(this.t);
                trace4Provider.setCurrentXData(Math.sin(this.updateIndex + 10.0) * 20.0 + 50.0);
                trace4Provider.setCurrentYData(Math.cos(this.updateIndex) * 30.0 + 50.0);
                this.updateIndex += 0.1;
                if (this.running) {
                    Display.getCurrent().timerExec(1, (Runnable)this);
                }
            }
        };
        Display.getCurrent().timerExec(1000, updater);
        return toolbarArmedXYGraph;
    }
}

