/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.dataprovider;

import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;

public class ClippedCircularBufferDataProvider
extends CircularBufferDataProvider {
    private int clippingWindow;

    public ClippedCircularBufferDataProvider(boolean chronological, int bufferSize, int clippingWindow) {
        super(chronological);
        this.setBufferSize(bufferSize);
        this.setClippingWindow(clippingWindow);
    }

    @Override
    public void setClippingWindow(int clippingWindow) {
        assert (clippingWindow > 0);
        assert (clippingWindow <= this.getSize());
        this.clippingWindow = clippingWindow;
    }

    @Override
    public int getClippingWindow() {
        return this.clippingWindow;
    }

    @Override
    protected void updateDataRange() {
        if (!this.dataRangedirty) {
            return;
        }
        this.dataRangedirty = false;
        if (this.getSize() > 0) {
            int lowerBound = 0;
            if (this.getSize() > this.clippingWindow) {
                lowerBound = this.getSize() - 1 - this.clippingWindow;
            }
            double xMin = this.getSample(lowerBound).getXValue();
            double yMin = this.getSample(lowerBound).getYValue();
            double xMax = xMin;
            double yMax = yMin;
            int i = lowerBound + 1;
            while (i < this.getSize()) {
                ISample dp = this.getSample(i);
                if (xMin > dp.getXValue() - dp.getXMinusError()) {
                    xMin = dp.getXValue() - dp.getXMinusError();
                }
                if (xMax < dp.getXValue() + dp.getXPlusError()) {
                    xMax = dp.getXValue() + dp.getXPlusError();
                }
                if (yMin > dp.getYValue() - dp.getYMinusError()) {
                    yMin = dp.getYValue() - dp.getYMinusError();
                }
                if (yMax < dp.getYValue() + dp.getYPlusError()) {
                    yMax = dp.getYValue() + dp.getYPlusError();
                }
                ++i;
            }
            this.xDataMinMax = new Range(xMin, xMax);
            this.yDataMinMax = new Range(yMin, yMax);
        } else {
            this.xDataMinMax = null;
            this.yDataMinMax = null;
        }
    }
}

