/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.internal.xygraph.undo;

import org.eclipse.nebula.visualization.internal.xygraph.undo.AnnotationMemento;
import org.eclipse.nebula.visualization.internal.xygraph.undo.AxisMemento;
import org.eclipse.nebula.visualization.internal.xygraph.undo.IUndoableCommand;
import org.eclipse.nebula.visualization.internal.xygraph.undo.TraceMemento;
import org.eclipse.nebula.visualization.internal.xygraph.undo.XYGraphMemento;
import org.eclipse.nebula.visualization.internal.xygraph.undo.XYGraphMementoUtil;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;

public class XYGraphConfigCommand
implements IUndoableCommand {
    private IXYGraph xyGraph;
    private XYGraphMemento previousXYGraphMem;
    private XYGraphMemento afterXYGraphMem;

    public XYGraphConfigCommand(IXYGraph xyGraph) {
        this((XYGraph)xyGraph);
    }

    @Deprecated
    public XYGraphConfigCommand(XYGraph xyGraph) {
        this.xyGraph = xyGraph;
        this.previousXYGraphMem = new XYGraphMemento();
        this.afterXYGraphMem = new XYGraphMemento();
        int i = 0;
        while (i < xyGraph.getPlotArea().getAnnotationList().size()) {
            this.previousXYGraphMem.addAnnotationMemento(new AnnotationMemento());
            this.afterXYGraphMem.addAnnotationMemento(new AnnotationMemento());
            ++i;
        }
        i = 0;
        while (i < xyGraph.getAxisList().size()) {
            this.previousXYGraphMem.addAxisMemento(new AxisMemento());
            this.afterXYGraphMem.addAxisMemento(new AxisMemento());
            ++i;
        }
        i = 0;
        while (i < xyGraph.getPlotArea().getTraceList().size()) {
            this.previousXYGraphMem.addTraceMemento(new TraceMemento());
            this.afterXYGraphMem.addTraceMemento(new TraceMemento());
            ++i;
        }
    }

    @Override
    public void redo() {
        XYGraphMementoUtil.restoreXYGraphPropsFromMemento(this.xyGraph, this.afterXYGraphMem);
    }

    @Override
    public void undo() {
        XYGraphMementoUtil.restoreXYGraphPropsFromMemento(this.xyGraph, this.previousXYGraphMem);
    }

    public void savePreviousStates() {
        XYGraphMementoUtil.saveXYGraphPropsToMemento(this.xyGraph, this.previousXYGraphMem);
    }

    public void saveAfterStates() {
        XYGraphMementoUtil.saveXYGraphPropsToMemento(this.xyGraph, this.afterXYGraphMem);
    }

    public String toString() {
        return "Configure XYGraph Settings";
    }
}

