/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree.painter;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.painter.TreeImagePainter;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class IndentedTreeImagePainter
extends CellPainterWrapper {
    private final int treeIndent;
    private final CellPainterDecorator internalPainter;

    @Deprecated
    public IndentedTreeImagePainter(ITreeRowModel<?> treeRowModel) {
        this(10, new TreeImagePainter());
    }

    @Deprecated
    public IndentedTreeImagePainter(ITreeRowModel<?> treeRowModel, int treeIndent) {
        this(treeIndent, new TreeImagePainter());
    }

    @Deprecated
    public IndentedTreeImagePainter(ITreeRowModel<?> treeRowModel, int treeIndent, TreeImagePainter treeImagePainter) {
        this(treeIndent, treeImagePainter);
    }

    public IndentedTreeImagePainter() {
        this(10, new TreeImagePainter());
    }

    public IndentedTreeImagePainter(int treeIndent) {
        this(treeIndent, new TreeImagePainter());
    }

    public IndentedTreeImagePainter(int treeIndent, TreeImagePainter treeImagePainter) {
        this(treeIndent, CellEdgeEnum.LEFT, treeImagePainter);
    }

    public IndentedTreeImagePainter(int treeIndent, CellEdgeEnum cellEdge, TreeImagePainter treeImagePainter) {
        this.treeIndent = treeIndent;
        this.internalPainter = new CellPainterDecorator(null, cellEdge, treeImagePainter);
        this.setWrappedPainter(this.internalPainter);
    }

    public IndentedTreeImagePainter(int treeIndent, ICellPainter interiorPainter, CellEdgeEnum cellEdge, boolean paintBg, int spacing, boolean paintDecorationDependent) {
        this.treeIndent = treeIndent;
        TreeImagePainter painter = new TreeImagePainter(paintBg);
        this.internalPainter = new CellPainterDecorator(interiorPainter, cellEdge, spacing, painter, paintDecorationDependent, paintBg);
        this.setWrappedPainter(this.internalPainter);
    }

    public IndentedTreeImagePainter(int treeIndent, ICellPainter interiorPainter, CellEdgeEnum cellEdge, ICellPainter decoratorPainter, boolean paintBg, int spacing, boolean paintDecorationDependent) {
        this.treeIndent = treeIndent;
        this.internalPainter = new CellPainterDecorator(interiorPainter, cellEdge, spacing, decoratorPainter, paintDecorationDependent, paintBg);
        this.setWrappedPainter(this.internalPainter);
    }

    public IndentedTreeImagePainter(int treeIndent, ICellPainter interiorPainter, boolean paintBg, boolean interiorPainterToSpanFullWidth) {
        this.treeIndent = treeIndent;
        TreeImagePainter painter = new TreeImagePainter(paintBg);
        this.internalPainter = new CellPainterDecorator(interiorPainter, CellEdgeEnum.RIGHT, 0, painter, !interiorPainterToSpanFullWidth, paintBg);
        this.setWrappedPainter(this.internalPainter);
    }

    public ICellPainter getTreeImagePainter() {
        return this.internalPainter.getDecoratorCellPainter();
    }

    public void setTreeImagePainter(ICellPainter cellPainter) {
        this.internalPainter.setDecoratorCellPainter(cellPainter);
    }

    public void setBaseCellPainter(ICellPainter cellPainter) {
        this.internalPainter.setBaseCellPainter(cellPainter);
    }

    @Override
    public Rectangle getWrappedPainterBounds(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        int depth = this.getDepth(cell);
        int indent = this.getIndent(depth);
        return new Rectangle(bounds.x + indent, bounds.y, bounds.width - indent, bounds.height);
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        super.paintCell(cell, gc, this.getWrappedPainterBounds(cell, gc, bounds, configRegistry), configRegistry);
    }

    @Override
    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        int depth = this.getDepth(cell);
        int indent = this.getIndent(depth);
        return indent + super.getPreferredWidth(cell, gc, configRegistry);
    }

    protected int getIndent(int depth) {
        return this.treeIndent * depth;
    }

    private int getDepth(ILayerCell cell) {
        int depth = 0;
        for (String configLabel : cell.getConfigLabels().getLabels()) {
            if (!configLabel.startsWith("TREE_DEPTH_")) continue;
            String[] tokens = configLabel.split("_");
            depth = Integer.valueOf(tokens[tokens.length - 1]);
        }
        return depth;
    }
}

