/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.grid.layer;

import org.eclipse.nebula.widgets.nattable.columnRename.DisplayColumnRenameDialogCommandHandler;
import org.eclipse.nebula.widgets.nattable.columnRename.RenameColumnHeaderCommandHandler;
import org.eclipse.nebula.widgets.nattable.columnRename.RenameColumnHelper;
import org.eclipse.nebula.widgets.nattable.columnRename.event.RenameColumnHeaderEvent;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderSelectionListener;
import org.eclipse.nebula.widgets.nattable.grid.layer.DimensionallyDependentLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.config.DefaultColumnHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class ColumnHeaderLayer
extends DimensionallyDependentLayer {
    private final SelectionLayer selectionLayer;
    protected RenameColumnHelper renameColumnHelper;

    public ColumnHeaderLayer(IUniqueIndexLayer baseLayer, ILayer horizontalLayerDependency, SelectionLayer selectionLayer) {
        this(baseLayer, horizontalLayerDependency, selectionLayer, true);
    }

    public ColumnHeaderLayer(IUniqueIndexLayer baseLayer, ILayer horizontalLayerDependency, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        this(baseLayer, horizontalLayerDependency, selectionLayer, useDefaultConfiguration, null);
    }

    public ColumnHeaderLayer(IUniqueIndexLayer baseLayer, ILayer horizontalLayerDependency, SelectionLayer selectionLayer, boolean useDefaultConfiguration, ILayerPainter layerPainter) {
        super(baseLayer, horizontalLayerDependency, baseLayer);
        if (selectionLayer == null) {
            throw new NullPointerException("selectionLayer");
        }
        this.selectionLayer = selectionLayer;
        this.layerPainter = layerPainter;
        this.renameColumnHelper = new RenameColumnHelper(this);
        this.registerPersistable(this.renameColumnHelper);
        selectionLayer.addLayerListener(new ColumnHeaderSelectionListener(this));
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultColumnHeaderLayerConfiguration());
        }
    }

    @Override
    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        int selectionLayerColumnPosition = LayerUtil.convertColumnPosition(this, columnPosition, this.selectionLayer);
        String displayMode = super.getDisplayModeByPosition(columnPosition, rowPosition);
        if (this.selectionLayer.isColumnPositionSelected(selectionLayerColumnPosition)) {
            if ("HOVER".equals(displayMode)) {
                return "SELECT_HOVER";
            }
            return "SELECT";
        }
        return displayMode;
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack labelStack = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        int selectionLayerColumnPosition = LayerUtil.convertColumnPosition(this, columnPosition, this.selectionLayer);
        if (this.selectionLayer.isColumnPositionFullySelected(selectionLayerColumnPosition)) {
            labelStack.addLabel("COLUMN_HEADER_FULL");
        }
        return labelStack;
    }

    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (this.isColumnRenamed(columnIndex)) {
            return this.getRenamedColumnLabelByIndex(columnIndex);
        }
        return super.getDataValueByPosition(columnPosition, rowPosition);
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new RenameColumnHeaderCommandHandler(this));
        this.registerCommandHandler(new DisplayColumnRenameDialogCommandHandler(this));
    }

    public String getOriginalColumnLabel(int columnPosition) {
        Object dataValue = super.getDataValueByPosition(columnPosition, 0);
        return dataValue != null ? dataValue.toString() : "";
    }

    public String getRenamedColumnLabel(int columnPosition) {
        int index = this.getColumnIndexByPosition(columnPosition);
        return this.getRenamedColumnLabelByIndex(index);
    }

    public String getRenamedColumnLabelByIndex(int columnIndex) {
        return this.renameColumnHelper.getRenamedColumnLabel(columnIndex);
    }

    public boolean isColumnRenamed(int columnIndex) {
        return this.renameColumnHelper.isColumnRenamed(columnIndex);
    }

    public boolean renameColumnPosition(int columnPosition, String customColumnName) {
        boolean renamed = this.renameColumnHelper.renameColumnPosition(columnPosition, customColumnName);
        if (renamed) {
            this.fireLayerEvent(new RenameColumnHeaderEvent(this, columnPosition));
        }
        return renamed;
    }

    public boolean renameColumnIndex(int columnIndex, String customColumnName) {
        boolean renamed = this.renameColumnHelper.renameColumnIndex(columnIndex, customColumnName);
        if (renamed) {
            this.fireLayerEvent(new RenameColumnHeaderEvent(this, columnIndex));
        }
        return renamed;
    }
}

