/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.log;

import org.cloudfoundry.client.lib.RestLogEntry;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.log.CloudLog;
import org.eclipse.cft.server.core.internal.log.DefaultCloudTracer;
import org.eclipse.cft.server.core.internal.log.HttpTracer;
import org.eclipse.cft.server.core.internal.log.ICloudTracer;

public abstract class CloudTracer
implements ICloudTracer {
    @Override
    public void traceNewLogEntry(RestLogEntry restLogEntry) {
        if (restLogEntry == null || !HttpTracer.getCurrent().isEnabled()) {
            return;
        }
        this.doTrace(restLogEntry);
    }

    abstract void doTrace(RestLogEntry var1);

    protected void fireTraceEvent(CloudLog log) {
        if (log == null) {
            return;
        }
        try {
            CloudFoundryPlugin.getCallback().trace(log, false);
        }
        catch (Throwable t) {
            CloudFoundryPlugin.logError(t);
        }
    }

    public static ICloudTracer getCurrentCloudTracer() {
        return new DefaultCloudTracer();
    }
}

