/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.debug;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryProjectUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.debug.CloudFoundryDebugProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public class SshDebugProvider
extends CloudFoundryDebugProvider {
    @Override
    public boolean isDebugSupported(IModule module, IServer server) {
        try {
            CloudFoundryServer cloudServer = this.getCloudServer(server);
            CloudFoundryApplicationModule appModule = this.getCloudFoundryApplicationModule(module, cloudServer);
            IJavaProject javaProject = CloudFoundryProjectUtil.getJavaProject(appModule);
            return javaProject != null && javaProject.exists() && cloudServer.getBehaviour().supportsSsh();
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logWarning(e.getMessage());
            return false;
        }
    }

    @Override
    public String getLaunchConfigurationType(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        return "org.eclipse.cft.debug.launchconfig.ssh";
    }
}

