/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.handler.jdt;

import java.util.NoSuchElementException;
import org.eclipse.capra.core.handlers.AnnotationException;
import org.eclipse.capra.handler.jdt.preferences.JDTPreferences;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class JDTAnnotate {
    private static final String TAG_PREFIX = "@";
    private static final String ANNOTATION_FAILED = "Annotation failed";

    private JDTAnnotate() {
    }

    public static void annotateArtifact(IJavaElement handle, String annotation) throws AnnotationException {
        if (handle instanceof ISourceReference) {
            try {
                ISourceReference sourceReference = (ISourceReference)handle;
                ISourceRange range = sourceReference.getSourceRange();
                ICompilationUnit cu = JDTAnnotate.getCompilationUnit(sourceReference);
                if (cu == null) {
                    Status status = new Status(1, "org.eclipse.capra.handler.jdt", ANNOTATION_FAILED, (Throwable)new NoSuchElementException("Could not find compilation unit for " + sourceReference.getSource()));
                    throw new AnnotationException((IStatus)status);
                }
                ASTParser parser = ASTParser.newParser((int)8);
                String source = cu.getSource();
                Document document = new Document(source);
                parser.setSource(cu);
                CompilationUnit root = (CompilationUnit)parser.createAST(null);
                ASTRewrite rewrite = ASTRewrite.create((AST)root.getAST());
                ASTNode node = JDTAnnotate.getNode((ASTNode)root, range.getOffset(), range.getLength());
                AST ast = node.getAST();
                ChildPropertyDescriptor property = JDTAnnotate.getJavadocPropertyDescriptor(handle);
                Javadoc javaDoc = (Javadoc)rewrite.get(node, (StructuralPropertyDescriptor)property);
                if (javaDoc == null) {
                    javaDoc = ast.newJavadoc();
                }
                ListRewrite tagsRewriter = rewrite.getListRewrite((ASTNode)javaDoc, Javadoc.TAGS_PROPERTY);
                IEclipsePreferences preferences = JDTPreferences.getPreferences();
                String tagName = TAG_PREFIX + preferences.get("ANNOTATE_JDT_TAG", "parent").trim();
                javaDoc.tags().stream().filter(t -> t.getTagName() != null && t.getTagName().equals(tagName)).forEach(t -> tagsRewriter.remove((ASTNode)t, null));
                TagElement tag = ast.newTagElement();
                TextElement text = ast.newTextElement();
                text.setText(annotation);
                tag.fragments().add(text);
                tag.setTagName(tagName);
                tagsRewriter.insertLast((ASTNode)tag, null);
                rewrite.set(node, (StructuralPropertyDescriptor)property, (Object)javaDoc, null);
                TextEdit edit = rewrite.rewriteAST();
                edit.apply((IDocument)document);
                String newSource = document.get();
                cu.getBuffer().setContents(newSource);
                cu.save(null, false);
            }
            catch (JavaModelException e) {
                throw new AnnotationException(e.getStatus());
            }
            catch (BadLocationException | MalformedTreeException e) {
                Status status = new Status(1, "org.eclipse.capra.handler.jdt", ANNOTATION_FAILED, e.getCause());
                throw new AnnotationException((IStatus)status);
            }
        }
    }

    private static ASTNode getNode(ASTNode root, int offset, int length) {
        NodeFinder finder = new NodeFinder(root, offset, length);
        ASTNode result = finder.getCoveringNode();
        if (result != null) {
            return result;
        }
        return finder.getCoveredNode();
    }

    private static ICompilationUnit getCompilationUnit(ISourceReference o) {
        if (o instanceof ICompilationUnit) {
            return (ICompilationUnit)o;
        }
        if (o instanceof IMethod) {
            return ((IMethod)o).getCompilationUnit();
        }
        if (o instanceof IJavaElement) {
            return (ICompilationUnit)((IJavaElement)o).getAncestor(5);
        }
        return null;
    }

    private static ChildPropertyDescriptor getJavadocPropertyDescriptor(IJavaElement handle) {
        switch (handle.getElementType()) {
            case 9: {
                return MethodDeclaration.JAVADOC_PROPERTY;
            }
            case 7: {
                return TypeDeclaration.JAVADOC_PROPERTY;
            }
        }
        return MethodDeclaration.JAVADOC_PROPERTY;
    }
}

