/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.operations;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.core.helpers.TraceHelper;
import org.eclipse.capra.ui.preferences.CapraPreferences;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class CreateTraceOperation
extends AbstractOperation {
    private static final String CAPRA_INFORMATION = "Capra Information";
    private static final String TRACE_LINK_EXISTS = "The trace link you want to create already exists and will therefore not be created";
    private static final String TRACE_LINK_SUCCESSFULLY_CREATED = "Trace link has been successfully created";
    private static final String DO_NOT_SHOW_DIALOG_AGAIN = "Do not show this dialog again";
    private static final String SELECT_TRACE_LINK_TYPE = "Select the trace type you want to create";
    private static final String SELECTION = "Selection";
    private Optional<EClass> chosenType;
    private List<EObject> wrappers;
    private EObject traceModel;
    private List<?> artifacts = null;
    private BiFunction<Collection<EClass>, List<EObject>, Optional<EClass>> chooseTraceType = null;

    private CreateTraceOperation(String label) {
        super(label);
    }

    public CreateTraceOperation(String label, List<?> artifacts) {
        super(label);
        Assert.isNotNull(artifacts);
        this.artifacts = artifacts;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.artifacts == null || this.artifacts.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        Shell shell = (Shell)info.getAdapter(Shell.class);
        if (this.chooseTraceType == null) {
            this.chooseTraceType = (traceTypes, selection) -> this.getTraceTypeToCreate(shell, (Collection<EClass>)traceTypes, (List<EObject>)selection);
        }
        this.createTrace(shell, this.chooseTraceType);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        List connections;
        TraceHelper traceHelper = new TraceHelper(this.traceModel);
        if (this.wrappers != null && this.chosenType != null && this.traceModel != null && !(connections = traceHelper.getTraces(this.wrappers, this.chosenType.get())).isEmpty()) {
            traceHelper.deleteTraces(connections);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public void createTrace(Shell shell, BiFunction<Collection<EClass>, List<EObject>, Optional<EClass>> chooseTraceType) {
        TraceMetaModelAdapter traceAdapter = (TraceMetaModelAdapter)ExtensionPointHelper.getTraceMetamodelAdapter().get();
        TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().get();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.traceModel = persistenceAdapter.getTraceModel((ResourceSet)resourceSet);
        EObject artifactModel = persistenceAdapter.getArtifactWrappers((ResourceSet)resourceSet);
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        TraceHelper traceHelper = new TraceHelper(this.traceModel);
        this.wrappers = artifactHelper.createWrappers(this.artifacts);
        Collection traceTypes = traceAdapter.getAvailableTraceTypes(this.wrappers);
        this.chosenType = chooseTraceType.apply(traceTypes, this.wrappers);
        if (this.chosenType.isPresent()) {
            if (traceHelper.traceExists(this.wrappers, this.chosenType.get())) {
                MessageDialog.openInformation((Shell)shell, (String)CAPRA_INFORMATION, (String)TRACE_LINK_EXISTS);
            } else {
                traceHelper.createTrace(this.wrappers, this.chosenType.get());
                persistenceAdapter.saveTracesAndArtifacts(this.traceModel, artifactModel);
                traceHelper.annotateTrace(this.wrappers);
                IPreferenceStore store = CapraPreferences.getPreferences();
                if (store.getBoolean("Show confirmation after a trace link has been created")) {
                    MessageDialogWithToggle.open((int)2, (Shell)shell, (String)CAPRA_INFORMATION, (String)TRACE_LINK_SUCCESSFULLY_CREATED, (String)DO_NOT_SHOW_DIALOG_AGAIN, (boolean)false, (IPreferenceStore)store, (String)"Show confirmation after a trace link has been created", (int)0);
                }
            }
        }
    }

    public void setChooseTraceType(BiFunction<Collection<EClass>, List<EObject>, Optional<EClass>> chooseTraceType) {
        this.chooseTraceType = chooseTraceType;
    }

    private Optional<EClass> getTraceTypeToCreate(Shell shell, Collection<EClass> traceTypes, List<EObject> wrappers) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                EClass eclass = (EClass)element;
                return eclass.getName();
            }
        });
        dialog.setTitle(SELECT_TRACE_LINK_TYPE);
        dialog.setElements(traceTypes.toArray());
        dialog.setMessage("Selection : " + wrappers.stream().map(this::getSelectionDisplayName).collect(Collectors.toList()));
        if (dialog.open() == 0) {
            return Optional.of((EClass)dialog.getFirstResult());
        }
        return Optional.empty();
    }

    private String getSelectionDisplayName(EObject element) {
        TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().get();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers((ResourceSet)new ResourceSetImpl());
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        IArtifactHandler handler = (IArtifactHandler)artifactHelper.getHandler(artifactHelper.unwrapWrapper((Object)element)).get();
        return handler.withCastedHandler(artifactHelper.unwrapWrapper((Object)element), (h, o) -> h.getDisplayName(o)).orElse(EMFHelper.getIdentifier((EObject)element));
    }
}

