/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.handlers;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.core.helpers.TraceHelper;
import org.eclipse.capra.ui.preferences.CapraPreferences;
import org.eclipse.capra.ui.views.SelectionView;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class TraceCreationHandler
extends AbstractHandler {
    private static final String CAPRA_INFORMATION = "Capra Information";
    private static final String TRACE_LINK_EXISTS = "The trace link you want to create already exists and will therefore not be created";
    private static final String TRACE_LINK_SUCCESSFULLY_CREATED = "Trace link has been successfully created";
    private static final String DO_NOT_SHOW_DIALOG_AGAIN = "Do not show this dialog again";
    private static final String SELECT_TRACE_LINK_TYPE = "Select the trace type you want to create";
    private static final String SELECTION = "Selection";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        this.createTrace(window, (traceTypes, selection) -> this.getTraceTypeToCreate(window, (Collection<EClass>)traceTypes, (List<EObject>)selection));
        return null;
    }

    public void createTrace(IWorkbenchWindow window, BiFunction<Collection<EClass>, List<EObject>, Optional<EClass>> chooseTraceType) {
        List<Object> artifacts = SelectionView.getOpenedView().getSelection();
        TraceMetaModelAdapter traceAdapter = (TraceMetaModelAdapter)ExtensionPointHelper.getTraceMetamodelAdapter().get();
        TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().get();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EObject traceModel = persistenceAdapter.getTraceModel((ResourceSet)resourceSet);
        EObject artifactModel = persistenceAdapter.getArtifactWrappers((ResourceSet)resourceSet);
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        TraceHelper traceHelper = new TraceHelper(traceModel);
        List wrappers = artifactHelper.createWrappers(artifacts);
        Collection traceTypes = traceAdapter.getAvailableTraceTypes(wrappers);
        Optional<EClass> chosenType = chooseTraceType.apply(traceTypes, wrappers);
        if (chosenType.isPresent()) {
            if (traceHelper.traceExists(wrappers, chosenType.get(), traceModel)) {
                MessageDialog.openInformation((Shell)window.getShell(), (String)CAPRA_INFORMATION, (String)TRACE_LINK_EXISTS);
            } else {
                traceHelper.createTrace(wrappers, chosenType.get());
                persistenceAdapter.saveTracesAndArtifacts(traceModel, artifactModel);
                traceHelper.annotateTrace(wrappers);
                IPreferenceStore store = CapraPreferences.getPreferences();
                if (store.getBoolean("Show confirmation after a trace link has been created")) {
                    MessageDialogWithToggle.open((int)2, (Shell)window.getShell(), (String)CAPRA_INFORMATION, (String)TRACE_LINK_SUCCESSFULLY_CREATED, (String)DO_NOT_SHOW_DIALOG_AGAIN, (boolean)false, (IPreferenceStore)store, (String)"Show confirmation after a trace link has been created", (int)0);
                }
            }
        }
    }

    private Optional<EClass> getTraceTypeToCreate(IWorkbenchWindow window, Collection<EClass> traceTypes, List<EObject> wrappers) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(window.getShell(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                EClass eclass = (EClass)element;
                return eclass.getName();
            }
        });
        dialog.setTitle(SELECT_TRACE_LINK_TYPE);
        dialog.setElements(traceTypes.toArray());
        dialog.setMessage("Selection : " + wrappers.stream().map(this::getSelectionDisplayName).collect(Collectors.toList()));
        if (dialog.open() == 0) {
            return Optional.of((EClass)dialog.getFirstResult());
        }
        return Optional.empty();
    }

    private String getSelectionDisplayName(EObject element) {
        TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().get();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers((ResourceSet)new ResourceSetImpl());
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        IArtifactHandler handler = (IArtifactHandler)artifactHelper.getHandler(artifactHelper.unwrapWrapper((Object)element)).get();
        return handler.withCastedHandler(artifactHelper.unwrapWrapper((Object)element), (h, o) -> h.getDisplayName(o)).orElse(EMFHelper.getIdentifier((EObject)element));
    }
}

