/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.Collection;
import java.util.Formatter;
import org.gradle.internal.impldep.javax.annotation.Nullable;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsupportedNotationException
extends TypeConversionException {
    private final Object notation;

    public UnsupportedNotationException(Object notation) {
        super("Could not convert " + notation);
        this.notation = notation;
    }

    public UnsupportedNotationException(Object notation, String failure, @Nullable String resolution, Collection<String> candidateTypes) {
        super(UnsupportedNotationException.format(failure, resolution, candidateTypes));
        this.notation = notation;
    }

    private static String format(String failure, String resolution, Collection<String> formats) {
        Formatter message = new Formatter();
        message.format("%s%n", failure);
        message.format("The following types/formats are supported:", new Object[0]);
        for (String format : formats) {
            message.format("%n  - %s", format);
        }
        if (GUtil.isTrue(resolution)) {
            message.format("%n%n%s", resolution);
        }
        return message.toString();
    }

    public Object getNotation() {
        return this.notation;
    }
}

