/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.connection;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.connection.CompositeBuildLauncher;
import org.gradle.tooling.internal.connection.DefaultBuildIdentifier;
import org.gradle.tooling.internal.connection.DefaultProjectIdentifier;
import org.gradle.tooling.internal.consumer.CompositeConnectionParameters;
import org.gradle.tooling.internal.consumer.DefaultBuildLauncher;
import org.gradle.tooling.internal.consumer.async.AsyncConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.converters.FixedBuildIdentifierProvider;
import org.gradle.tooling.internal.gradle.ConsumerProvidedTask;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.Launchable;
import org.gradle.tooling.model.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradleConnectionBuildLauncher
extends DefaultBuildLauncher
implements BuildLauncher,
CompositeBuildLauncher {
    public GradleConnectionBuildLauncher(AsyncConsumerActionExecutor connection, CompositeConnectionParameters parameters) {
        super(connection, parameters);
    }

    @Override
    public BuildLauncher forTasks(String ... tasks) {
        throw new UnsupportedOperationException("Must specify build root directory when executing tasks by name on a GradleConnection: see `CompositeBuildLauncher.forTasks(File, String)`.");
    }

    @Override
    public DefaultBuildLauncher setStandardInput(InputStream inputStream) {
        throw new UnsupportedOperationException("This is unsupported for composite models from GradleConnections at this time.");
    }

    @Override
    protected void preprocessLaunchables(Iterable<? extends Launchable> launchables) {
        BuildIdentifier targetBuildIdentifier = null;
        for (Launchable launchable : launchables) {
            BuildIdentifier launchableBuildIdentifier = launchable.getProjectIdentifier().getBuildIdentifier();
            if (targetBuildIdentifier == null) {
                targetBuildIdentifier = launchableBuildIdentifier;
                continue;
            }
            if (targetBuildIdentifier.equals(launchableBuildIdentifier)) continue;
            throw new IllegalArgumentException("All Launchables must originate from the same build.");
        }
        this.operationParamsBuilder.setBuildIdentifier(targetBuildIdentifier);
    }

    @Override
    public BuildLauncher forTasks(File buildDirectory, String ... tasks) {
        ArrayList<Task> taskList = new ArrayList<Task>(tasks.length);
        for (String task : tasks) {
            taskList.add(this.targetTask(task, buildDirectory));
        }
        return this.forTasks(taskList);
    }

    private Task targetTask(String task, File buildDirectory) {
        ConsumerProvidedTask taskObject = new ConsumerProvidedTask().setName(task).setPath(task).setDescription("Task " + task).setDisplayName("Task " + task);
        FixedBuildIdentifierProvider buildIdentifierProvider = new FixedBuildIdentifierProvider(new DefaultProjectIdentifier(new DefaultBuildIdentifier(buildDirectory), ":"));
        return new ProtocolToModelAdapter().adapt(Task.class, taskObject, buildIdentifierProvider);
    }
}

