/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.nodeselection;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;

public final class SelectionHistoryManager
implements ISelectionProvider {
    private final TreeViewer treeViewer;
    private final TreeViewerSelectionListener listener;
    private final List<ISelectionChangedListener> selectionChangedListeners;
    private NodeSelection selectionHistory;

    public SelectionHistoryManager(TreeViewer treeViewer) {
        this.treeViewer = (TreeViewer)Preconditions.checkNotNull((Object)treeViewer);
        this.listener = new TreeViewerSelectionListener();
        this.selectionChangedListeners = Lists.newCopyOnWriteArrayList();
        this.selectionHistory = NodeSelection.empty();
        this.init();
    }

    private void init() {
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.listener);
    }

    public void dispose() {
        this.treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this.listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public NodeSelection getSelectionHistory() {
        return this.selectionHistory;
    }

    public ISelection getSelection() {
        return this.getSelectionHistory();
    }

    public void setSelection(ISelection selection) {
        this.handleSelection(selection);
    }

    private void handleSelection(ISelection selection) {
        NodeSelection nodeSelection = NodeSelection.from(selection);
        this.selectionHistory = this.selectionHistory.mergeWith(nodeSelection);
        this.fireSelectionChanged();
    }

    private void fireSelectionChanged() {
        final SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this.treeViewer, this.getSelection());
        for (final ISelectionChangedListener listener : this.selectionChangedListeners) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.selectionChanged(selectionChangedEvent);
                }
            });
        }
    }

    private final class TreeViewerSelectionListener
    implements ISelectionChangedListener {
        private TreeViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionHistoryManager.this.handleSelection(event.getSelection());
        }
    }
}

