/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TextBlock;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.StringBufferToStringBuilderFixCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.text.edits.TextEditGroup;

public class StringConcatToTextBlockFixCore
extends CompilationUnitRewriteOperationsFixCore {
    private static final String JAVA_STRING = "java.lang.String";

    public static ICleanUpFixCore createCleanUp(CompilationUnit compilationUnit) {
        if (!JavaModelUtil.is15OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        StringConcatFinder finder = new StringConcatFinder(operations, true);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new StringBufferToStringBuilderFixCore(FixMessages.StringConcatToTextBlockFix_convert_msg, compilationUnit, ops);
    }

    public static StringConcatToTextBlockFixCore createStringConcatToTextBlockFix(ASTNode exp) {
        CompilationUnit root = (CompilationUnit)exp.getRoot();
        if (!JavaModelUtil.is15OrHigher(root.getJavaElement().getJavaProject())) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        StringConcatFinder finder = new StringConcatFinder(operations, true);
        exp.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        return new StringConcatToTextBlockFixCore(FixMessages.StringConcatToTextBlockFix_convert_msg, root, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{(CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation)operations.get(0)});
    }

    protected StringConcatToTextBlockFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static class ChangeStringConcatToTextBlock
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final InfixExpression fInfix;
        private final String fIndent;

        public ChangeStringConcatToTextBlock(InfixExpression infix) {
            this.fInfix = infix;
            this.fIndent = "\t";
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.StringConcatToTextBlockCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            StringBuilder buf = new StringBuilder();
            Stream<Expression> expressions = Stream.concat(Stream.of(this.fInfix.getLeftOperand(), this.fInfix.getRightOperand()), this.fInfix.extendedOperands().stream());
            final ArrayList parts = new ArrayList();
            expressions.forEach(new Consumer<Expression>(){

                @Override
                public void accept(Expression t) {
                    String value = ((StringLiteral)t).getEscapedValue();
                    parts.addAll(this.unescapeBlock(value.substring(1, value.length() - 1)));
                }
            });
            buf.append("\"\"\"\n");
            boolean newLine = false;
            for (String part : parts) {
                if (buf.length() > 4 && !newLine) {
                    buf.append("\\").append(System.lineSeparator());
                }
                newLine = part.endsWith(System.lineSeparator());
                buf.append(this.fIndent).append(part);
            }
            if (newLine) {
                buf.append(this.fIndent);
            }
            buf.append("\"\"\"");
            TextBlock textBlock = (TextBlock)rewrite.createStringPlaceholder(buf.toString(), 102);
            rewrite.replace((ASTNode)this.fInfix, (ASTNode)textBlock, group);
        }

        private List<String> unescapeBlock(String escapedText) {
            StringBuilder transformed = new StringBuilder();
            int readIndex = 0;
            int bsIndex = 0;
            ArrayList<String> parts = new ArrayList<String>();
            while ((bsIndex = escapedText.indexOf("\\", readIndex)) >= 0) {
                if (escapedText.startsWith("\\n", bsIndex)) {
                    transformed.append(escapedText.substring(readIndex, bsIndex));
                    parts.add(String.valueOf(ChangeStringConcatToTextBlock.escapeTrailingWhitespace(transformed.toString())) + System.lineSeparator());
                    transformed = new StringBuilder();
                    readIndex = bsIndex + 2;
                    continue;
                }
                if (escapedText.startsWith("\\\"", bsIndex)) {
                    transformed.append(escapedText.substring(readIndex, bsIndex));
                    int quoteCount = 1;
                    while (escapedText.startsWith("\\\"", bsIndex + 2 * quoteCount)) {
                        ++quoteCount;
                    }
                    int i = 0;
                    while (i < quoteCount / 3) {
                        transformed.append("\\\"\"\"");
                        ++i;
                    }
                    if (i > 0 && quoteCount % 3 != 0) {
                        transformed.append("\\");
                    }
                    int j = 0;
                    while (j < quoteCount % 3) {
                        transformed.append("\"");
                        ++j;
                    }
                    readIndex = bsIndex + 2 * quoteCount;
                    continue;
                }
                if (escapedText.startsWith("\\t", bsIndex)) {
                    transformed.append(escapedText.substring(readIndex, bsIndex));
                    transformed.append("\t");
                    readIndex = bsIndex + 2;
                    continue;
                }
                transformed.append(escapedText.substring(readIndex, bsIndex));
                transformed.append("\\").append(escapedText.charAt(bsIndex + 1));
                readIndex = bsIndex + 2;
            }
            if (readIndex < escapedText.length()) {
                transformed.append(ChangeStringConcatToTextBlock.escapeTrailingWhitespace(escapedText.substring(readIndex)));
            }
            if (transformed.length() > 0) {
                parts.add(transformed.toString());
            }
            return parts;
        }

        private static String escapeTrailingWhitespace(String unescaped) {
            if (unescaped.length() == 0) {
                return "";
            }
            int whitespaceStart = unescaped.length() - 1;
            StringBuilder trailingWhitespace = new StringBuilder();
            while (whitespaceStart > 0) {
                if (unescaped.charAt(whitespaceStart) == ' ') {
                    --whitespaceStart;
                    trailingWhitespace.append("\\s");
                    continue;
                }
                if (unescaped.charAt(whitespaceStart) != '\t') break;
                --whitespaceStart;
                trailingWhitespace.append("\\t");
            }
            return String.valueOf(unescaped.substring(0, whitespaceStart + 1)) + trailingWhitespace;
        }
    }

    public static final class StringConcatFinder
    extends ASTVisitor {
        private final List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> fOperations;
        private final boolean fAllConcats;

        public StringConcatFinder(List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations, boolean allConcats) {
            super(true);
            this.fOperations = operations;
            this.fAllConcats = allConcats;
        }

        private boolean isStringType(Type type) {
            if (type instanceof ArrayType) {
                return false;
            }
            ITypeBinding typeBinding = type.resolveBinding();
            return typeBinding != null && typeBinding.getQualifiedName().equals(StringConcatToTextBlockFixCore.JAVA_STRING);
        }

        public boolean visit(VariableDeclarationStatement visited) {
            Type type = visited.getType();
            return this.isStringType(type);
        }

        public boolean visit(FieldDeclaration visited) {
            Type type = visited.getType();
            return this.isStringType(type);
        }

        public boolean visit(Assignment visited) {
            ITypeBinding typeBinding = visited.resolveTypeBinding();
            return typeBinding != null && typeBinding.getQualifiedName().equals(StringConcatToTextBlockFixCore.JAVA_STRING);
        }

        public boolean visit(InfixExpression visited) {
            if (visited.getOperator() != InfixExpression.Operator.PLUS || visited.extendedOperands().isEmpty()) {
                return false;
            }
            ITypeBinding typeBinding = visited.resolveTypeBinding();
            if (typeBinding == null || !typeBinding.getQualifiedName().equals(StringConcatToTextBlockFixCore.JAVA_STRING)) {
                return false;
            }
            Expression leftHand = visited.getLeftOperand();
            if (!(leftHand instanceof StringLiteral)) {
                return false;
            }
            StringLiteral leftLiteral = (StringLiteral)leftHand;
            String literal = leftLiteral.getLiteralValue();
            if (!(literal.isEmpty() || this.fAllConcats || literal.endsWith("\n"))) {
                return false;
            }
            Expression rightHand = visited.getRightOperand();
            if (!(rightHand instanceof StringLiteral)) {
                return false;
            }
            StringLiteral rightLiteral = (StringLiteral)leftHand;
            literal = rightLiteral.getLiteralValue();
            if (!(literal.isEmpty() || this.fAllConcats || literal.endsWith("\n"))) {
                return false;
            }
            List extendedOperands = visited.extendedOperands();
            if (extendedOperands.isEmpty()) {
                return false;
            }
            int i = 0;
            while (i < extendedOperands.size()) {
                StringLiteral stringLiteral;
                String string;
                Expression operand = (Expression)extendedOperands.get(i);
                if (!(operand instanceof StringLiteral) || (string = (stringLiteral = (StringLiteral)operand).getLiteralValue()).isEmpty() || !this.fAllConcats && !string.endsWith("\n") && i != extendedOperands.size() - 1) {
                    return false;
                }
                ++i;
            }
            this.fOperations.add(new ChangeStringConcatToTextBlock(visited));
            return false;
        }
    }
}

