/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.util;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;

public class ExpressionUtil {
    public static Expression createUserProperty(DesignElementHandle handle, UserPropertyDefn userDef) {
        String propName = userDef.getName();
        String valueExpr = handle.getStringProperty(propName);
        switch (userDef.getTypeCode()) {
            case 7: 
            case 18: {
                ExpressionHandle property = handle.getExpressionProperty(propName);
                if (property == null) {
                    return null;
                }
                Object expression = property.getValue();
                if (expression == null) {
                    expression = userDef.getDefault();
                }
                if (expression instanceof org.eclipse.birt.report.model.api.Expression) {
                    return ExpressionUtil.createExpression((org.eclipse.birt.report.model.api.Expression)expression);
                }
                return null;
            }
            case 1: 
            case 2: 
            case 14: {
                return ExpressionUtil.createConstant(3, valueExpr);
            }
            case 6: {
                return ExpressionUtil.createConstant(1, valueExpr);
            }
            case 11: {
                return ExpressionUtil.createConstant(6, valueExpr);
            }
        }
        return ExpressionUtil.createConstant(5, valueExpr);
    }

    public static Expression createExpression(org.eclipse.birt.report.model.api.Expression expr) {
        if (expr != null) {
            String type = expr.getType();
            if ("constant".equals(type)) {
                String text = expr.getStringExpression();
                return Expression.newConstant(-1, text);
            }
            String text = expr.getStringExpression();
            if (text != null && (text = text.trim()).length() > 0) {
                return Expression.newScript(type, text);
            }
        }
        return null;
    }

    public static Expression createConstant(int type, String expr) {
        if (expr != null) {
            return Expression.newConstant(type, expr);
        }
        return null;
    }

    public static Expression createExpression(String expr) {
        if (expr != null && (expr = expr.trim()).length() > 0) {
            return Expression.newScript("javascript", expr);
        }
        return null;
    }

    public static Object evaluate(ExecutionContext context, Expression expr) {
        try {
            return context.evaluate(expr);
        }
        catch (BirtException ex) {
            context.addException(ex);
            return null;
        }
    }
}

