/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.ICrosstabModelListener;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.core.util.ICrosstabUpdateContext;
import org.eclipse.birt.report.item.crosstab.core.util.ICrosstabUpdateListener;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public final class CrosstabModelUtil
implements ICrosstabConstants {
    private static AggregationManager manager;
    private static ThreadLocal<ICrosstabModelListener> modelListener;

    static {
        modelListener = new ThreadLocal();
    }

    public static void setCrosstabModelListener(ICrosstabModelListener listener) {
        if (listener == null) {
            modelListener.remove();
        } else {
            if (listener instanceof ICrosstabUpdateListener) {
                ((ICrosstabUpdateListener)listener).setContext(new DefaultCrosstabUpdateContext());
            }
            modelListener.set(listener);
        }
    }

    public static ICrosstabModelListener getCrosstabModelListener() {
        return modelListener.get();
    }

    public static void notifyCreation(int type, Object model, Map<String, Object> extras) {
        ICrosstabModelListener listener = modelListener.get();
        if (listener != null) {
            if (listener instanceof ICrosstabUpdateListener) {
                ((ICrosstabUpdateListener)listener).onCreated(type, model, extras);
            } else {
                listener.onCreated(type, model);
            }
        } else {
            try {
                new DefaultCrosstabUpdateContext().performDefaultCreation(type, model, extras);
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
        }
    }

    public static void notifyValidate(int type, Object model, Map<String, Object> extras) {
        ICrosstabModelListener listener = modelListener.get();
        if (listener != null) {
            if (listener instanceof ICrosstabUpdateListener) {
                ((ICrosstabUpdateListener)listener).onValidate(type, model, extras);
            } else {
                listener.onValidate(type, model);
            }
        } else {
            try {
                new DefaultCrosstabUpdateContext().performDefaultValidation(type, model, extras);
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
        }
    }

    public static List<IReportItem> getReportItems(List<?> elements) {
        if (elements == null || elements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IReportItem> values = new ArrayList<IReportItem>();
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i) instanceof DesignElementHandle) {
                values.add(CrosstabUtil.getReportItem((DesignElementHandle)elements.get(i)));
            }
            ++i;
        }
        return values;
    }

    public static int getOppositeAxisType(int axisType) {
        switch (axisType) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        return -1;
    }

    static int getTotalIndex(LevelViewHandle levelView) {
        if (levelView == null) {
            return -1;
        }
        CrosstabReportItemHandle crosstab = levelView.getCrosstab();
        if (crosstab == null) {
            return -1;
        }
        int axisType = levelView.getAxisType();
        int levelIndex = levelView.getIndex();
        int dimensionIndex = ((DimensionViewHandle)levelView.getContainer()).getIndex();
        int result = levelIndex;
        int i = 0;
        while (i < dimensionIndex) {
            DimensionViewHandle dimension = crosstab.getDimension(axisType, i);
            result += dimension.getLevelCount();
            ++i;
        }
        return result;
    }

    public static boolean isValidAxisType(int axisType) {
        return axisType == 1 || axisType == 0;
    }

    public static int getAllLevelCount(CrosstabReportItemHandle crosstab, int axisType) {
        if (crosstab == null) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < crosstab.getDimensionCount(axisType)) {
            DimensionViewHandle dimensionView = crosstab.getDimension(axisType, i);
            count += dimensionView.getLevelCount();
            ++i;
        }
        return count;
    }

    public static LevelViewHandle getPrecedingLevel(LevelViewHandle levelView) {
        if (levelView == null) {
            return null;
        }
        DimensionViewHandle dimensionView = (DimensionViewHandle)levelView.getContainer();
        if (dimensionView == null) {
            return null;
        }
        int index = levelView.getIndex();
        if (index - 1 >= 0) {
            return dimensionView.getLevel(index - 1);
        }
        CrosstabViewHandle crosstabView = (CrosstabViewHandle)dimensionView.getContainer();
        if (crosstabView == null) {
            return null;
        }
        index = dimensionView.getIndex();
        int i = index - 1;
        while (i >= 0) {
            dimensionView = crosstabView.getDimension(i);
            int levelCount = dimensionView.getLevelCount();
            if (levelCount > 0) {
                return dimensionView.getLevel(levelCount - 1);
            }
            --i;
        }
        return null;
    }

    public static LevelViewHandle getInnerMostLevel(CrosstabReportItemHandle crosstab, int axisType) {
        if (crosstab == null) {
            return null;
        }
        int dimensionIndex = crosstab.getDimensionCount(axisType) - 1;
        while (dimensionIndex >= 0) {
            DimensionViewHandle dimensionView = crosstab.getDimension(axisType, dimensionIndex);
            int totalLevels = dimensionView.getLevelCount();
            if (totalLevels > 0) {
                return dimensionView.getLevel(totalLevels - 1);
            }
            --dimensionIndex;
        }
        return null;
    }

    public static Iterator getBindingColumnIterator(DesignElementHandle handle) {
        if (handle instanceof ReportItemHandle) {
            return ((ReportItemHandle)handle).columnBindingsIterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public static List getVisiableColumnBindingsList(DesignElementHandle handle, boolean includeSelf) {
        ArrayList bindingList = new ArrayList();
        if (includeSelf) {
            Iterator iterator = CrosstabModelUtil.getBindingColumnIterator(handle);
            while (iterator.hasNext()) {
                bindingList.add(iterator.next());
            }
        }
        return bindingList;
    }

    public static ComputedColumnHandle getInputBinding(ReportItemHandle input, String bindingName) {
        List elementsList = CrosstabModelUtil.getVisiableColumnBindingsList((DesignElementHandle)input, true);
        if (elementsList != null && elementsList.size() > 0) {
            int i = 0;
            while (i < elementsList.size()) {
                if (((ComputedColumnHandle)elementsList.get(i)).getName().equals(bindingName)) {
                    return (ComputedColumnHandle)elementsList.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static void updateRPTMeasureAggregation(CrosstabReportItemHandle crosstab) {
        if (crosstab == null) {
            return;
        }
        int count = crosstab.getMeasureCount();
        int i = 0;
        while (i < count) {
            MeasureViewHandle measureHandle = crosstab.getMeasure(i);
            if (measureHandle.getCell() != null) {
                List<DataItemHandle> items = CrosstabModelUtil.getDataItems(measureHandle.getCell());
                int j = 0;
                while (j < items.size()) {
                    CrosstabModelUtil.updateRPTAggregateOn(crosstab, items.get(j));
                    ++j;
                }
            }
            ++i;
        }
    }

    private static List<DataItemHandle> getDataItems(AggregationCellHandle cell) {
        ArrayList<DataItemHandle> items = new ArrayList<DataItemHandle>();
        if (cell == null) {
            return items;
        }
        List list = cell.getContents();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof DataItemHandle) {
                DataItemHandle handle = (DataItemHandle)list.get(i);
                String binding = handle.getResultSetColumn();
                ComputedColumnHandle computedHnadle = CrosstabModelUtil.getInputBinding((ReportItemHandle)cell.getCrosstab().getModelHandle(), binding);
                if (computedHnadle != null && computedHnadle.getTimeDimension() != null) {
                    items.add(handle);
                }
            }
            ++i;
        }
        return items;
    }

    private static void updateRPTAggregateOn(CrosstabReportItemHandle crosstab, DataItemHandle dataHandle) {
        String binding = dataHandle.getResultSetColumn();
        ComputedColumnHandle computedHnadle = CrosstabModelUtil.getInputBinding((ReportItemHandle)crosstab.getModelHandle(), binding);
        try {
            computedHnadle.clearAggregateOnList();
            LevelViewHandle levelHandle = CrosstabModelUtil.getInnerMostLevel(crosstab, 0);
            if (levelHandle != null) {
                computedHnadle.addAggregateOn(levelHandle.getCubeLevelName());
            }
            if ((levelHandle = CrosstabModelUtil.getInnerMostLevel(crosstab, 1)) != null) {
                computedHnadle.addAggregateOn(levelHandle.getCubeLevelName());
            }
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
    }

    private static boolean needUpdateMeasure(MeasureViewHandle measureView) {
        if (measureView == null) {
            return false;
        }
        if (!(measureView instanceof ComputedMeasureViewHandle) || CrosstabUtil.isLinkedDataModelMeasureView(measureView)) {
            return true;
        }
        AggregationCellHandle cell = measureView.getCell();
        List<DataItemHandle> items = CrosstabModelUtil.getDataItems(cell);
        return items.size() > 0;
    }

    public static void addDataItem(CrosstabReportItemHandle crosstab, AggregationCellHandle cell, MeasureViewHandle measureView, String function, String rowDimension, String rowLevel, String colDimension, String colLevel) throws SemanticException {
        if (crosstab == null || !CrosstabModelUtil.needUpdateMeasure(measureView)) {
            return;
        }
        if (measureView instanceof ComputedMeasureViewHandle && !CrosstabUtil.isLinkedDataModelMeasureView(measureView)) {
            List<DataItemHandle> items = CrosstabModelUtil.getDataItems(cell);
            int i = 0;
            while (i < items.size()) {
                CrosstabModelUtil.updateRPTAggregateOn(crosstab, items.get(i));
                ++i;
            }
            return;
        }
        if (cell == null) {
            cell = measureView.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        }
        if (measureView instanceof ComputedMeasureViewHandle && !CrosstabUtil.isLinkedDataModelMeasureView(measureView)) {
            List<DataItemHandle> items = CrosstabModelUtil.getDataItems(cell);
            int i = 0;
            while (i < items.size()) {
                CrosstabModelUtil.updateRPTAggregateOn(crosstab, items.get(i));
                ++i;
            }
            return;
        }
        if (cell != null) {
            DataItemHandle dataItem;
            ComputedColumnHandle columnHandle;
            String name = CrosstabModelUtil.generateComputedColumnName(measureView, colLevel, rowLevel);
            ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)crosstab.getModelHandle(), (String)name);
            String measureName = CrosstabModelUtil.getMeasureName(crosstab, measureView);
            if (measureName == null || measureName.isEmpty()) {
                return;
            }
            MeasureHandle cubeMeasure = measureView.getCubeMeasure();
            if (cubeMeasure != null && cubeMeasure.getDisplayName() != null) {
                column.setDisplayName(cubeMeasure.getDisplayName());
            }
            String dataType = measureView.getDataType();
            column.setDataType(dataType);
            String expression = CrosstabModelUtil.getMeasureExpression(crosstab, measureName, measureView);
            column.setExpression(expression);
            String defaultFunction = CrosstabModelUtil.getDefaultMeasureAggregationFunction(measureView);
            if ("count".equals(defaultFunction)) {
                dataType = "integer";
                column.setDataType(dataType);
            }
            if (!CrosstabUtil.measureHasItsOwnAggregation(crosstab, cubeMeasure)) {
                column.setAggregateFunction(function != null ? function : defaultFunction);
            }
            if (function != null && !function.equalsIgnoreCase(defaultFunction)) {
                try {
                    IAggrFunction aggFunc = CrosstabModelUtil.getAggregationManager().getAggregation(column.getAggregateFunction());
                    if (aggFunc != null) {
                        if (aggFunc.getType() == 1) {
                            cubeMeasure = measureView.getCubeMeasure();
                            if (!CrosstabUtil.measureHasItsOwnAggregation(crosstab, cubeMeasure)) {
                                column.setAggregateFunction(defaultFunction);
                            }
                        } else {
                            String targetType = DataAdapterUtil.adapterToModelDataType((int)aggFunc.getDataType());
                            if (!"any".equals(targetType)) {
                                column.setDataType(targetType);
                            }
                        }
                    }
                }
                catch (BirtException aggFunc) {
                    // empty catch block
                }
            }
            if (rowLevel != null) {
                column.addAggregateOn(rowLevel);
            }
            if (colLevel != null) {
                column.addAggregateOn(colLevel);
            }
            if ((columnHandle = CrosstabModelUtil.generateAggregation(crosstab, cell, measureView, function, rowDimension, rowLevel, colDimension, colLevel)) == null) {
                return;
            }
            if (cell.getContents().size() == 0) {
                dataItem = crosstab.getModuleHandle().getElementFactory().newDataItem(null);
                dataItem.setResultSetColumn(columnHandle.getName());
                cell.addContent((DesignElementHandle)dataItem);
            } else if (cell.getContents().size() == 1 && cell.getContents().get(0) instanceof DataItemHandle) {
                dataItem = (DataItemHandle)cell.getContents().get(0);
                dataItem.setResultSetColumn(columnHandle.getName());
            } else {
                for (Object item : cell.getContents()) {
                    if (!(item instanceof DataItemHandle)) continue;
                    String bindingName = ((DataItemHandle)item).getResultSetColumn();
                    ComputedColumnHandle binding = ((ReportItemHandle)crosstab.getModelHandle()).findColumnBinding(bindingName);
                    if (binding == null || binding.getAggregateFunction() == null) continue;
                    try {
                        IAggrFunction aggFunc = CrosstabModelUtil.getAggregationManager().getAggregation(binding.getAggregateFunction());
                        if (aggFunc == null || aggFunc.getType() == 1 || !CrosstabModelUtil.isMeasureDataItem(crosstab, measureName, (DataItemHandle)item, binding)) continue;
                        ((DataItemHandle)item).setResultSetColumn(columnHandle.getName());
                        break;
                    }
                    catch (BirtException birtException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static String getMeasureName(CrosstabReportItemHandle crosstab, MeasureViewHandle measureView) {
        if (CrosstabUtil.isBoundToLinkedDataSet(crosstab)) {
            return CrosstabUtil.getRefLinkedDataModelColumnName(measureView);
        }
        return measureView.getCubeMeasureName();
    }

    public static String getMeasureExpression(CrosstabReportItemHandle crosstab, String measureName, MeasureViewHandle measureView) {
        MeasureHandle cubeMeasure;
        String expression = CrosstabUtil.isBoundToLinkedDataSet(crosstab) ? (CrosstabUtil.measureHasItsOwnAggregation(crosstab, cubeMeasure = measureView.getCubeMeasure()) ? ExpressionUtil.createJSMeasureExpression((String)measureName) : ExpressionUtil.createDataSetRowExpression((String)measureName)) : ExpressionUtil.createJSMeasureExpression((String)measureName);
        return expression;
    }

    public static boolean isMeasureDataItem(CrosstabReportItemHandle crosstab, String measureName, DataItemHandle dataItemHandle, ComputedColumnHandle binding) {
        ExpressionHandle expr;
        String exprStr;
        if (crosstab == null || dataItemHandle == null || measureName == null || binding == null) {
            return false;
        }
        String resultSetColumn = dataItemHandle.getResultSetColumn();
        if (resultSetColumn == null) {
            return false;
        }
        String measureBREExpr = "[" + CrosstabModelUtil.escape(measureName) + "]";
        String measureJsExpr = ExpressionUtil.createJSMeasureExpression((String)measureName);
        if (CrosstabUtil.isBoundToLinkedDataSet(crosstab)) {
            measureJsExpr = ExpressionUtil.createDataSetRowExpression((String)measureName);
        }
        String string = exprStr = (expr = CrosstabModelUtil.getExpression(binding)) != null ? expr.getStringExpression() : null;
        return exprStr != null && ("javascript".equalsIgnoreCase(expr.getType()) ? exprStr.contains(measureJsExpr) : exprStr.contains(measureBREExpr));
    }

    private static String escape(String name) {
        name = name.replaceAll("\\'", "''");
        name = name.replace("[", "'['");
        name = name.replace("]", "']'");
        name = name.replace("?", "'?'");
        return name;
    }

    public static ExpressionHandle getExpression(ComputedColumnHandle columnBindingHandle) {
        if (columnBindingHandle == null) {
            return null;
        }
        ExpressionHandle exprHandle = columnBindingHandle.getExpressionProperty("expression");
        if (exprHandle == null || exprHandle.getValue() == null) {
            Iterator it = columnBindingHandle.argumentsIterator();
            while (it.hasNext()) {
                AggregationArgumentHandle ah = (AggregationArgumentHandle)it.next();
                if (!"Expression".equalsIgnoreCase(ah.getName())) continue;
                exprHandle = ah.getExpressionProperty("value");
                break;
            }
        }
        return exprHandle;
    }

    public static ComputedColumnHandle generateAggregation(CrosstabReportItemHandle crosstab, AggregationCellHandle cell, MeasureViewHandle measureView, String function, String rowDimension, String rowLevel, String colDimension, String colLevel) throws SemanticException {
        String name = CrosstabModelUtil.generateComputedColumnName(measureView, colLevel, rowLevel);
        ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)crosstab.getModelHandle(), (String)name);
        String dataField = CrosstabModelUtil.getMeasureName(crosstab, measureView);
        if (dataField == null || dataField.isEmpty()) {
            return null;
        }
        String dataType = measureView.getDataType();
        column.setDataType(dataType);
        String expression = CrosstabModelUtil.getMeasureExpression(crosstab, dataField, measureView);
        column.setExpression(expression);
        String defaultFunction = CrosstabModelUtil.getDefaultMeasureAggregationFunction(measureView);
        MeasureHandle cubeMeasure = measureView.getCubeMeasure();
        if (cubeMeasure != null && cubeMeasure.getDisplayName() != null) {
            column.setDisplayName(cubeMeasure.getDisplayName());
        }
        if (!CrosstabUtil.measureHasItsOwnAggregation(crosstab, cubeMeasure)) {
            column.setAggregateFunction(function != null ? function : defaultFunction);
        }
        if ("count".equals(defaultFunction)) {
            dataType = "integer";
            column.setDataType(dataType);
        }
        if (function != null && !function.equalsIgnoreCase(defaultFunction)) {
            try {
                IAggrFunction aggFunc = CrosstabModelUtil.getAggregationManager().getAggregation(column.getAggregateFunction());
                if (aggFunc != null) {
                    if (aggFunc.getType() == 1) {
                        column.setAggregateFunction(defaultFunction);
                    } else {
                        String targetType = DataAdapterUtil.adapterToModelDataType((int)aggFunc.getDataType());
                        if (!"any".equals(targetType)) {
                            column.setDataType(targetType);
                        }
                    }
                }
            }
            catch (BirtException birtException) {
                // empty catch block
            }
        }
        if (rowLevel != null) {
            column.addAggregateOn(rowLevel);
        }
        if (colLevel != null) {
            column.addAggregateOn(colLevel);
        }
        return ((ReportItemHandle)crosstab.getModelHandle()).addColumnBinding(column, false);
    }

    static AggregationManager getAggregationManager() throws BirtException {
        if (manager == null) {
            DataRequestSession session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            manager = session.getAggregationManager();
            session.shutdown();
        }
        return manager;
    }

    public static String generateComputedColumnName(MeasureViewHandle measureView, String aggregationOnColumn, String aggregationOnRow) {
        String name = "";
        String temp = measureView.getCubeMeasureName();
        if (temp != null && temp.length() > 0) {
            name = String.valueOf(name) + temp;
        }
        if (aggregationOnRow != null && aggregationOnRow.length() > 0) {
            name = name.length() > 0 ? String.valueOf(name) + "_" + aggregationOnRow : String.valueOf(name) + aggregationOnRow;
        }
        if (aggregationOnColumn != null && aggregationOnColumn.length() > 0) {
            name = name.length() > 0 ? String.valueOf(name) + "_" + aggregationOnColumn : String.valueOf(name) + aggregationOnColumn;
        }
        if (name.length() <= 0) {
            name = "measure";
        }
        return name;
    }

    public static String getDefaultMeasureAggregationFunction(MeasureViewHandle mv) {
        if (mv != null) {
            String func = null;
            if (CrosstabUtil.isBoundToLinkedDataSet(mv.getCrosstab())) {
                ComputedColumnHandle columnHandle = CrosstabUtil.getMeasureBindingColumnHandle(mv);
                if (columnHandle != null) {
                    func = columnHandle.getAggregateFunction();
                }
                if (func == null && mv.getCubeMeasure() != null) {
                    func = "count";
                }
                return DataAdapterUtil.getRollUpAggregationName((String)func);
            }
            if (mv.getCubeMeasure() != null && (func = mv.getCubeMeasure().getFunction()) != null) {
                return DataAdapterUtil.getRollUpAggregationName((String)func);
            }
        }
        return "sum";
    }

    public static boolean isNumeric(String dataType) {
        return "integer".equals(dataType) || "float".equals(dataType) || "decimal".equals(dataType);
    }

    public static String getAggregationFunction(CrosstabReportItemHandle crosstab, AggregationCellHandle cell) {
        assert (crosstab != null);
        assert (cell != null);
        assert (cell.getCrosstab() == crosstab);
        ReportItemHandle crosstabModel = (ReportItemHandle)crosstab.getModelHandle();
        List contents = cell.getContents();
        int index = 0;
        while (index < contents.size()) {
            String columnName;
            ComputedColumnHandle columnHandle;
            DesignElementHandle content = (DesignElementHandle)contents.get(index);
            if (content instanceof DataItemHandle && (columnHandle = crosstabModel.findColumnBinding(columnName = ((DataItemHandle)content).getResultSetColumn())) != null && columnHandle.getAggregateFunction() != null) {
                return columnHandle.getAggregateFunction();
            }
            ++index;
        }
        return null;
    }

    public static void setAggregationFunction(CrosstabReportItemHandle crosstab, AggregationCellHandle cell, String function) throws SemanticException {
        assert (crosstab != null);
        assert (cell != null);
        assert (cell.getCrosstab() == crosstab);
        ReportItemHandle crosstabModel = (ReportItemHandle)crosstab.getModelHandle();
        List contents = cell.getContents();
        int index = 0;
        while (index < contents.size()) {
            String columnName;
            ComputedColumnHandle columnHandle;
            DesignElementHandle content = (DesignElementHandle)contents.get(index);
            if (content instanceof DataItemHandle && (columnHandle = crosstabModel.findColumnBinding(columnName = ((DataItemHandle)content).getResultSetColumn())) != null && columnHandle.getAggregateFunction() != null) {
                columnHandle.setAggregateFunction(function);
                try {
                    String targetType = DataAdapterUtil.adapterToModelDataType((int)CrosstabModelUtil.getAggregationManager().getAggregation(function).getDataType());
                    if (!"any".equals(targetType)) {
                        columnHandle.setDataType(targetType);
                    }
                }
                catch (BirtException birtException) {
                    // empty catch block
                }
            }
            ++index;
        }
    }

    public static LevelViewHandle getLevel(CrosstabReportItemHandle crosstab, int overallIndex, int axisType) {
        int dimensionCount = crosstab.getDimensionCount(axisType);
        int totalLevels = 0;
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimensionViewhandle = crosstab.getDimension(axisType, i);
            int levelViewHandleCount = dimensionViewhandle.getLevelCount();
            if (overallIndex < totalLevels + levelViewHandleCount) {
                return dimensionViewhandle.getLevel(overallIndex - totalLevels);
            }
            totalLevels += levelViewHandleCount;
            ++i;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CrosstabCellHandle locateColumnWidthCell(CrosstabReportItemHandle crosstabItem, CrosstabCellHandle cell) {
        if (crosstabItem == null || cell == null || cell.getCrosstab() != crosstabItem) return null;
        boolean isMeasureHorizontal = "horizontal".equals(crosstabItem.getMeasureDirection());
        if (cell instanceof AggregationCellHandle) {
            AggregationCellHandle aggCell = (AggregationCellHandle)cell;
            MeasureViewHandle mv = null;
            if ("detail".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) {
                if (!isMeasureHorizontal) return crosstabItem.getMeasure(0).getCell();
                return ((MeasureViewHandle)cell.getContainer()).getCell();
            }
            mv = isMeasureHorizontal ? (MeasureViewHandle)aggCell.getContainer() : crosstabItem.getMeasure(0);
            String colDimension = aggCell.getDimensionName(1);
            String colLevel = aggCell.getLevelName(1);
            LevelViewHandle colLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1);
            if (colLevelHandle == null) {
                return mv.getCell();
            }
            DimensionViewHandle colDimHandle = (DimensionViewHandle)colLevelHandle.getContainer();
            if (colLevelHandle.getCubeLevelName().equals(colLevel) && colDimHandle.getCubeDimensionName().equals(colDimension)) {
                return mv.getCell();
            }
            String rowDimension = null;
            String rowLevel = null;
            LevelViewHandle rowLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0);
            if (rowLevelHandle == null) return mv.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
            rowDimension = ((DimensionViewHandle)rowLevelHandle.getContainer()).getCubeDimensionName();
            rowLevel = rowLevelHandle.getCubeLevelName();
            return mv.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        }
        if (cell.getContainer() instanceof MeasureViewHandle) {
            if (isMeasureHorizontal) {
                MeasureViewHandle mv = (MeasureViewHandle)cell.getContainer();
                int headerPos = cell.getModelHandle().getIndex();
                if (headerPos <= 0) return mv.getCell();
                List<LevelViewHandle> levels = CrosstabModelUtil.getAllAggregationLevels(crosstabItem, 1);
                Collections.reverse(levels);
                String rowDimension = null;
                String rowLevel = null;
                LevelViewHandle rowLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0);
                if (rowLevelHandle != null) {
                    rowDimension = ((DimensionViewHandle)rowLevelHandle.getContainer()).getCubeDimensionName();
                    rowLevel = rowLevelHandle.getCubeLevelName();
                }
                int realIndex = 1;
                int i = 1;
                while (i < levels.size()) {
                    LevelViewHandle lv = levels.get(i);
                    if (CrosstabModelUtil.isAggregationOn(mv, lv.getCubeLevelName(), 1)) {
                        if (headerPos == realIndex) {
                            String colDimension = ((DimensionViewHandle)lv.getContainer()).getCubeDimensionName();
                            String colLevel = lv.getCubeLevelName();
                            return mv.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
                        }
                        ++realIndex;
                    }
                    ++i;
                }
                return mv.getAggregationCell(rowDimension, rowLevel, null, null);
            }
            if (!"header".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return crosstabItem.getMeasure(0).getCell();
            int i = 0;
            while (i < crosstabItem.getMeasureCount()) {
                MeasureViewHandle mv = crosstabItem.getMeasure(i);
                if (mv.getHeader() != null) {
                    return mv.getHeader();
                }
                ++i;
            }
            return null;
        }
        if (cell.getContainer() instanceof LevelViewHandle) {
            LevelViewHandle lv = (LevelViewHandle)cell.getContainer();
            boolean isRowLevl = "rows".equals(lv.getContainer().getContainer().getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName());
            if (isRowLevl) {
                if (!"aggregationHeader".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return cell;
                return CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0).getCell();
            }
            if (crosstabItem.getMeasureCount() == 0) {
                if (!"aggregationHeader".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1).getCell();
                return cell;
            }
            if (!"aggregationHeader".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return crosstabItem.getMeasure(0).getCell();
            String rowDimension = null;
            String rowLevel = null;
            String colDimension = ((DimensionViewHandle)lv.getContainer()).getCubeDimensionName();
            String colLevel = lv.getCubeLevelName();
            LevelViewHandle rowLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0);
            if (rowLevelHandle != null) {
                rowDimension = ((DimensionViewHandle)rowLevelHandle.getContainer()).getCubeDimensionName();
                rowLevel = rowLevelHandle.getCubeLevelName();
            }
            if (!isMeasureHorizontal) return crosstabItem.getMeasure(0).getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
            int i = 0;
            while (i < crosstabItem.getMeasureCount()) {
                AggregationCellHandle aggCell = crosstabItem.getMeasure(i).getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
                if (aggCell != null) {
                    return aggCell;
                }
                ++i;
            }
            return crosstabItem.getMeasure(0).getCell();
        }
        if (cell.getContainer() instanceof CrosstabViewHandle) {
            boolean isRowGrandTotal = "rows".equals(cell.getContainer().getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName());
            if (isRowGrandTotal) {
                LevelViewHandle rowLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0);
                if (rowLevelHandle == null) return cell;
                return rowLevelHandle.getCell();
            }
            if (crosstabItem.getMeasureCount() == 0) {
                return cell;
            }
            String rowDimension = null;
            String rowLevel = null;
            LevelViewHandle rowLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0);
            if (rowLevelHandle != null) {
                rowDimension = ((DimensionViewHandle)rowLevelHandle.getContainer()).getCubeDimensionName();
                rowLevel = rowLevelHandle.getCubeLevelName();
            }
            if (!isMeasureHorizontal) return crosstabItem.getMeasure(0).getAggregationCell(rowDimension, rowLevel, null, null);
            int i = 0;
            while (i < crosstabItem.getMeasureCount()) {
                AggregationCellHandle aggCell = crosstabItem.getMeasure(i).getAggregationCell(rowDimension, rowLevel, null, null);
                if (aggCell != null) {
                    return aggCell;
                }
                ++i;
            }
            return null;
        }
        if (!(cell.getContainer() instanceof CrosstabReportItemHandle)) return null;
        if (crosstabItem.getHeaderCount() > 1) {
            int levelCount;
            int scan = (isMeasureHorizontal ? 0 : 1) + (levelCount = CrosstabModelUtil.getAllLevelCount(crosstabItem, 0));
            if (scan == 0) {
                return crosstabItem.getHeader();
            }
            int idx = cell.getModelHandle().getIndex();
            if ((idx %= scan) < levelCount) {
                LevelViewHandle rowLevelHandle = CrosstabModelUtil.getLevel(crosstabItem, idx, 0);
                if (rowLevelHandle == null) return cell;
                return rowLevelHandle.getCell();
            }
            if (isMeasureHorizontal) return cell;
            int i = 0;
            while (i < crosstabItem.getMeasureCount()) {
                MeasureViewHandle mv = crosstabItem.getMeasure(i);
                if (mv.getHeader() != null) {
                    return mv.getHeader();
                }
                ++i;
            }
            return cell;
        } else {
            LevelViewHandle rowLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0);
            if (rowLevelHandle != null) {
                return rowLevelHandle.getCell();
            }
            if (isMeasureHorizontal) return cell;
            int i = 0;
            while (i < crosstabItem.getMeasureCount()) {
                MeasureViewHandle mv = crosstabItem.getMeasure(i);
                if (mv.getHeader() != null) {
                    return mv.getHeader();
                }
                ++i;
            }
        }
        return cell;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CrosstabCellHandle locateRowHeightCell(CrosstabReportItemHandle crosstabItem, CrosstabCellHandle cell) {
        if (crosstabItem == null || cell == null || cell.getCrosstab() != crosstabItem) return null;
        boolean isMeasureHorizontal = "horizontal".equals(crosstabItem.getMeasureDirection());
        if (cell instanceof AggregationCellHandle) {
            AggregationCellHandle aggCell = (AggregationCellHandle)cell;
            MeasureViewHandle mv = null;
            if ("detail".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) {
                if (isMeasureHorizontal) return crosstabItem.getMeasure(0).getCell();
                return ((MeasureViewHandle)cell.getContainer()).getCell();
            }
            mv = !isMeasureHorizontal ? (MeasureViewHandle)aggCell.getContainer() : crosstabItem.getMeasure(0);
            String rowDimension = aggCell.getDimensionName(0);
            String rowLevel = aggCell.getLevelName(0);
            LevelViewHandle rowLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0);
            if (rowLevelHandle == null) {
                return mv.getCell();
            }
            DimensionViewHandle rowDimHandle = (DimensionViewHandle)rowLevelHandle.getContainer();
            if (rowLevelHandle.getCubeLevelName().equals(rowLevel) && rowDimHandle.getCubeDimensionName().equals(rowDimension)) {
                return mv.getCell();
            }
            String colDimension = null;
            String colLevel = null;
            LevelViewHandle colLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1);
            if (colLevelHandle == null) return mv.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
            colDimension = ((DimensionViewHandle)colLevelHandle.getContainer()).getCubeDimensionName();
            colLevel = colLevelHandle.getCubeLevelName();
            return mv.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        }
        if (cell.getContainer() instanceof MeasureViewHandle) {
            if (!isMeasureHorizontal) {
                MeasureViewHandle mv = (MeasureViewHandle)cell.getContainer();
                int headerPos = cell.getModelHandle().getIndex();
                if (headerPos <= 0) return mv.getCell();
                List<LevelViewHandle> levels = CrosstabModelUtil.getAllAggregationLevels(crosstabItem, 0);
                Collections.reverse(levels);
                String colDimension = null;
                String colLevel = null;
                LevelViewHandle colLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1);
                if (colLevelHandle != null) {
                    colDimension = ((DimensionViewHandle)colLevelHandle.getContainer()).getCubeDimensionName();
                    colLevel = colLevelHandle.getCubeLevelName();
                }
                int realIndex = 1;
                int i = 1;
                while (i < levels.size()) {
                    LevelViewHandle lv = levels.get(i);
                    if (CrosstabModelUtil.isAggregationOn(mv, lv.getCubeLevelName(), 0)) {
                        if (headerPos == realIndex) {
                            String rowDimension = ((DimensionViewHandle)lv.getContainer()).getCubeDimensionName();
                            String rowLevel = lv.getCubeLevelName();
                            return mv.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
                        }
                        ++realIndex;
                    }
                    ++i;
                }
                return mv.getAggregationCell(null, null, colDimension, colLevel);
            }
            if (!"header".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return crosstabItem.getMeasure(0).getCell();
            int i = 0;
            while (i < crosstabItem.getMeasureCount()) {
                MeasureViewHandle mv = crosstabItem.getMeasure(i);
                if (mv.getHeader() != null) {
                    return mv.getHeader();
                }
                ++i;
            }
            return null;
        }
        if (cell.getContainer() instanceof LevelViewHandle) {
            LevelViewHandle lv = (LevelViewHandle)cell.getContainer();
            boolean isRowLevl = "rows".equals(lv.getContainer().getContainer().getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName());
            if (!isRowLevl) {
                if (!"aggregationHeader".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return cell;
                return CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1).getCell();
            }
            if (crosstabItem.getMeasureCount() == 0) {
                if (!"aggregationHeader".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0).getCell();
                return cell;
            }
            if (!"aggregationHeader".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return crosstabItem.getMeasure(0).getCell();
            String colDimension = null;
            String colLevel = null;
            String rowDimension = ((DimensionViewHandle)lv.getContainer()).getCubeDimensionName();
            String rowLevel = lv.getCubeLevelName();
            LevelViewHandle colLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1);
            if (colLevelHandle != null) {
                colDimension = ((DimensionViewHandle)colLevelHandle.getContainer()).getCubeDimensionName();
                colLevel = colLevelHandle.getCubeLevelName();
            }
            if (isMeasureHorizontal) {
                return crosstabItem.getMeasure(0).getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
            }
            int i = 0;
            while (i < crosstabItem.getMeasureCount()) {
                AggregationCellHandle aggCell = crosstabItem.getMeasure(i).getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
                if (aggCell != null) {
                    return aggCell;
                }
                ++i;
            }
            return crosstabItem.getMeasure(0).getCell();
        }
        if (cell.getContainer() instanceof CrosstabViewHandle) {
            boolean isRowGrandTotal = "rows".equals(cell.getContainer().getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName());
            if (!isRowGrandTotal) {
                LevelViewHandle colLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1);
                if (colLevelHandle == null) return cell;
                return colLevelHandle.getCell();
            }
            if (crosstabItem.getMeasureCount() == 0) {
                return cell;
            }
            String colDimension = null;
            String colLevel = null;
            LevelViewHandle colLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1);
            if (colLevelHandle != null) {
                colDimension = ((DimensionViewHandle)colLevelHandle.getContainer()).getCubeDimensionName();
                colLevel = colLevelHandle.getCubeLevelName();
            }
            if (isMeasureHorizontal) {
                return crosstabItem.getMeasure(0).getAggregationCell(null, null, colDimension, colLevel);
            }
            int i = 0;
            while (i < crosstabItem.getMeasureCount()) {
                AggregationCellHandle aggCell = crosstabItem.getMeasure(i).getAggregationCell(null, null, colDimension, colLevel);
                if (aggCell != null) {
                    return aggCell;
                }
                ++i;
            }
            return null;
        }
        if (!(cell.getContainer() instanceof CrosstabReportItemHandle)) return null;
        if (crosstabItem.getHeaderCount() > 1) {
            int rowLevelCount;
            int colLevelCount = CrosstabModelUtil.getAllLevelCount(crosstabItem, 1);
            if (colLevelCount == 0 && !isMeasureHorizontal) {
                return crosstabItem.getHeader();
            }
            int scan = (isMeasureHorizontal ? 0 : 1) + (rowLevelCount = CrosstabModelUtil.getAllLevelCount(crosstabItem, 0));
            if (scan == 0) {
                scan = 1;
            }
            int idx = cell.getModelHandle().getIndex();
            if ((idx /= scan) < colLevelCount) {
                LevelViewHandle colLevelHandle = CrosstabModelUtil.getLevel(crosstabItem, idx, 1);
                if (colLevelHandle == null) return cell;
                return colLevelHandle.getCell();
            }
            if (!isMeasureHorizontal) return cell;
            int i = 0;
            while (i < crosstabItem.getMeasureCount()) {
                MeasureViewHandle mv = crosstabItem.getMeasure(i);
                if (mv.getHeader() != null) {
                    return mv.getHeader();
                }
                ++i;
            }
            return cell;
        } else {
            LevelViewHandle colLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1);
            if (colLevelHandle != null) {
                return colLevelHandle.getCell();
            }
            if (!isMeasureHorizontal) return cell;
            int i = 0;
            while (i < crosstabItem.getMeasureCount()) {
                MeasureViewHandle mv = crosstabItem.getMeasure(i);
                if (mv.getHeader() != null) {
                    return mv.getHeader();
                }
                ++i;
            }
        }
        return cell;
    }

    public static List<LevelViewHandle> getAllAggregationLevels(CrosstabReportItemHandle crosstab, int axisType) {
        ArrayList<LevelViewHandle> result = new ArrayList<LevelViewHandle>();
        int i = 0;
        while (i < crosstab.getDimensionCount(axisType)) {
            DimensionViewHandle dimensionView = crosstab.getDimension(axisType, i);
            int j = 0;
            while (j < dimensionView.getLevelCount()) {
                LevelViewHandle levelView = dimensionView.getLevel(j);
                if (levelView.getCubeLevelName() != null && (levelView.isInnerMost() || levelView.getAggregationHeader() != null)) {
                    result.add(levelView);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static String getAggregationOnPropName(int axisType) {
        if (axisType == 1) {
            return "aggregationOnColumn";
        }
        if (axisType == 0) {
            return "aggregationOnRow";
        }
        return null;
    }

    public static boolean isAggregationOn(MeasureViewHandle measureView, String levelName, int axisType) {
        if (measureView == null || !CrosstabModelUtil.isValidAxisType(axisType)) {
            return false;
        }
        String propName = CrosstabModelUtil.getAggregationOnPropName(axisType);
        int j = 0;
        while (j < measureView.getAggregationCount()) {
            AggregationCellHandle cell = measureView.getAggregationCell(j);
            String aggregationOn = cell.getModelHandle().getStringProperty(propName);
            if (levelName == null && aggregationOn == null || levelName != null && levelName.equals(aggregationOn)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public static int computeAllMeasureHeaderCount(CrosstabReportItemHandle crosstab, MeasureViewHandle measureView) {
        if (crosstab == null || measureView == null) {
            return 0;
        }
        if (measureView instanceof ComputedMeasureViewHandle && !CrosstabUtil.isLinkedDataModelMeasureView(measureView)) {
            return 1;
        }
        int targetAxis = "vertical".equals(crosstab.getMeasureDirection()) ? 0 : 1;
        List<LevelViewHandle> levels = CrosstabModelUtil.getAllAggregationLevels(crosstab, targetAxis);
        if (levels == null || levels.size() == 0) {
            return 1;
        }
        int count = 0;
        LevelViewHandle innerMost = CrosstabModelUtil.getInnerMostLevel(crosstab, targetAxis);
        int i = 0;
        while (i < levels.size()) {
            LevelViewHandle lv = levels.get(i);
            if (lv == innerMost || CrosstabModelUtil.isAggregationOn(measureView, lv.getCubeLevelName(), targetAxis)) {
                ++count;
            }
            ++i;
        }
        if (CrosstabModelUtil.isAggregationOn(measureView, null, targetAxis)) {
            ++count;
        }
        assert (count > 0);
        return count;
    }

    public static void validateCrosstabHeader(CrosstabReportItemHandle crosstab) {
        int headerCellCount = crosstab.getHeaderCount();
        List<LevelViewHandle> columnLevelList = CrosstabModelUtil.getLevelList(crosstab, 1);
        List<LevelViewHandle> rowLevelList = CrosstabModelUtil.getLevelList(crosstab, 0);
        PropertyHandle headerHandle = crosstab.getModelHandle().getPropertyHandle("header");
        int rowSize = rowLevelList.size();
        int columnSize = columnLevelList.size();
        if (!crosstab.isHideMeasureHeader()) {
            if ("vertical".equals(crosstab.getMeasureDirection())) {
                ++rowSize;
            } else {
                ++columnSize;
            }
        }
        int total = rowSize * columnSize - headerCellCount;
        if (rowLevelList.size() == 0) {
            return;
        }
        if (columnLevelList.size() == 0 && rowLevelList.size() > 0) {
            if (headerCellCount < rowSize) {
                int i = 0;
                while (i < rowSize - headerCellCount) {
                    ExtendedItemHandle cellHandle = null;
                    try {
                        cellHandle = CrosstabExtendedItemFactory.createCrosstabCell(crosstab.getModuleHandle());
                        headerHandle.add((DesignElementHandle)cellHandle);
                    }
                    catch (SemanticException semanticException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            return;
        }
        int i = 0;
        while (i < total) {
            ExtendedItemHandle cellHandle = null;
            try {
                cellHandle = CrosstabExtendedItemFactory.createCrosstabCell(crosstab.getModuleHandle());
                headerHandle.add((DesignElementHandle)cellHandle);
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
            ++i;
        }
    }

    public static List<LevelViewHandle> getLevelList(CrosstabReportItemHandle crosstab, int axisType) {
        ArrayList<LevelViewHandle> retValue = new ArrayList<LevelViewHandle>();
        int dimensionCount = crosstab.getDimensionCount(axisType);
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimensionViewhandle = crosstab.getDimension(axisType, i);
            int leveViewHandleCount = dimensionViewhandle.getLevelCount();
            int j = 0;
            while (j < leveViewHandleCount) {
                retValue.add(dimensionViewhandle.getLevel(j));
                ++j;
            }
            ++i;
        }
        return retValue;
    }

    public static void updateHeaderCell(CrosstabReportItemHandle crosstab, int pos, int axisType) {
        CrosstabModelUtil.updateHeaderCell(crosstab, pos, axisType, false, 0);
    }

    public static void updateHeaderCell(CrosstabReportItemHandle crosstab, int pos, int axisType, boolean removeLevel) {
        CrosstabModelUtil.updateHeaderCell(crosstab, pos, axisType, false, 0, removeLevel);
    }

    public static void updateHeaderCell(CrosstabReportItemHandle crosstab, int pos, int axisType, boolean isMoveDimension, int adjustCount) {
        CrosstabModelUtil.updateHeaderCell(crosstab, pos, axisType, isMoveDimension, adjustCount, false);
    }

    public static void updateHeaderCell(CrosstabReportItemHandle crosstab, int pos, int axisType, boolean isMoveDimension, int adjustCount, boolean removeLevel) {
        int i;
        boolean isAdd;
        HeaderData data = CrosstabModelUtil.calcHeaderData(crosstab);
        List<LevelViewHandle> rowLevelList = CrosstabModelUtil.getLevelList(crosstab, 0);
        if (isMoveDimension) {
            if (1 == axisType) {
                data.rowNumber -= adjustCount;
            } else {
                data.columnNumber -= adjustCount;
            }
        }
        int total = data.rowNumber * data.columnNumber;
        PropertyHandle headerHandle = crosstab.getModelHandle().getPropertyHandle("header");
        if (pos == -1) {
            if ("vertical".equals(crosstab.getMeasureDirection())) {
                pos = total - crosstab.getHeaderCount() > 0 ? data.columnNumber - 1 : data.columnNumber;
                axisType = 0;
            } else {
                pos = total - crosstab.getHeaderCount() > 0 ? data.rowNumber - 1 : data.rowNumber;
                axisType = 1;
            }
        } else if (pos == -2 && !crosstab.isHideMeasureHeader() && crosstab.getMeasureCount() > 0) {
            int i2;
            if (crosstab.getHeaderCount() <= 1) {
                return;
            }
            if ("vertical".equals(crosstab.getMeasureDirection())) {
                if (total - crosstab.getHeaderCount() != data.rowNumber) {
                    i2 = 0;
                    while (i2 < data.columnNumber - 1) {
                        try {
                            int delPos = (data.rowNumber - 1) * (data.columnNumber - 1);
                            if (delPos < crosstab.getHeaderCount()) {
                                headerHandle.removeItem(delPos);
                            }
                        }
                        catch (PropertyValueException delPos) {
                            // empty catch block
                        }
                        ++i2;
                    }
                }
            } else if (total - crosstab.getHeaderCount() != data.columnNumber) {
                i2 = data.rowNumber - 2;
                while (i2 >= 0) {
                    try {
                        int delPos = data.columnNumber - 1;
                        if (i2 == data.rowNumber - 2) {
                            delPos = data.columnNumber;
                        }
                        if ((delPos = i2 * (data.columnNumber + 1) + delPos) < crosstab.getHeaderCount()) {
                            headerHandle.removeItem(delPos);
                        }
                    }
                    catch (PropertyValueException delPos) {
                        // empty catch block
                    }
                    --i2;
                }
            }
            if ("vertical".equals(crosstab.getMeasureDirection())) {
                pos = data.columnNumber - 1;
                axisType = 0;
            } else {
                pos = data.rowNumber - 1;
                axisType = 1;
            }
        }
        boolean bl = isAdd = total - crosstab.getHeaderCount() > 0;
        if (!isMoveDimension && !CrosstabModelUtil.needUpdateHeaderCell(crosstab, removeLevel ? false : isAdd, axisType) || total == crosstab.getHeaderCount()) {
            return;
        }
        if (1 == axisType) {
            i = 0;
            while (i < data.columnNumber) {
                try {
                    if (isAdd) {
                        int insertRow = pos;
                        if (insertRow == data.rowNumber - 1 && rowLevelList.size() != 0) {
                            --insertRow;
                        }
                        ExtendedItemHandle cellHandle = CrosstabExtendedItemFactory.createCrosstabCell(crosstab.getModuleHandle());
                        headerHandle.add((DesignElementHandle)cellHandle, insertRow * data.columnNumber + i);
                    } else {
                        int delPos = (pos == data.rowNumber ? pos - 1 : pos) * data.columnNumber;
                        if (delPos < crosstab.getHeaderCount()) {
                            headerHandle.removeItem(delPos);
                        }
                    }
                }
                catch (SemanticException delPos) {
                    // empty catch block
                }
                ++i;
            }
        } else {
            i = data.rowNumber - 1;
            while (i >= 0) {
                try {
                    if (isAdd) {
                        int insertColumn = pos;
                        if (pos == data.columnNumber - 1 && i != data.rowNumber - 1) {
                            insertColumn = pos - 1;
                        }
                        ExtendedItemHandle cellHandle = CrosstabExtendedItemFactory.createCrosstabCell(crosstab.getModuleHandle());
                        headerHandle.add((DesignElementHandle)cellHandle, i * (data.columnNumber - 1) + insertColumn);
                    } else {
                        int delPos = pos;
                        if (pos == data.columnNumber && i != data.rowNumber - 1) {
                            delPos = pos - 1;
                        }
                        if ((delPos = i * (data.columnNumber + 1) + delPos) < crosstab.getHeaderCount()) {
                            headerHandle.removeItem(delPos);
                        }
                    }
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
                --i;
            }
        }
    }

    private static boolean needUpdateHeaderCell(CrosstabReportItemHandle crosstab, boolean isAdd, int axisType) {
        int value;
        if (crosstab.getHeaderCount() > 1) {
            return true;
        }
        List<LevelViewHandle> columnLevelList = CrosstabModelUtil.getLevelList(crosstab, 1);
        List<LevelViewHandle> rowLevelList = CrosstabModelUtil.getLevelList(crosstab, 0);
        if (columnLevelList.size() == 0 && rowLevelList.size() == 0) {
            return true;
        }
        int n = value = isAdd ? 2 : 1;
        if (columnLevelList.size() == 0) {
            return rowLevelList.size() <= value;
        }
        if (rowLevelList.size() == 0) {
            return columnLevelList.size() <= value;
        }
        if (isAdd) {
            if (1 == axisType && (columnLevelList.size() == value || columnLevelList.size() == 1) && rowLevelList.size() == 1) {
                return true;
            }
            if (axisType == 0 && columnLevelList.size() == 1 && (rowLevelList.size() == value || rowLevelList.size() == 1)) {
                return true;
            }
        }
        return false;
    }

    public static int[] getHeaderRowAndColumnCount(CrosstabReportItemHandle crosstab) {
        HeaderData data = CrosstabModelUtil.calcHeaderData(crosstab);
        return new int[]{data.rowNumber, data.columnNumber};
    }

    private static HeaderData calcHeaderData(CrosstabReportItemHandle crosstab) {
        HeaderData data = new HeaderData();
        List<LevelViewHandle> columnLevelList = CrosstabModelUtil.getLevelList(crosstab, 1);
        List<LevelViewHandle> rowLevelList = CrosstabModelUtil.getLevelList(crosstab, 0);
        if (columnLevelList.size() == 0 && rowLevelList.size() == 0) {
            return data;
        }
        if (columnLevelList.size() == 0) {
            data.columnNumber = CrosstabModelUtil.needCrosstabHeaderCellForMeasureHeader(crosstab, 0) ? rowLevelList.size() + 1 : rowLevelList.size();
            return data;
        }
        if (rowLevelList.size() == 0) {
            data.rowNumber = CrosstabModelUtil.needCrosstabHeaderCellForMeasureHeader(crosstab, 1) ? columnLevelList.size() + 1 : columnLevelList.size();
            return data;
        }
        data.rowNumber = CrosstabModelUtil.needCrosstabHeaderCellForMeasureHeader(crosstab, 1) ? columnLevelList.size() + 1 : columnLevelList.size();
        data.columnNumber = CrosstabModelUtil.needCrosstabHeaderCellForMeasureHeader(crosstab, 0) ? rowLevelList.size() + 1 : rowLevelList.size();
        return data;
    }

    private static boolean needCrosstabHeaderCellForMeasureHeader(CrosstabReportItemHandle crosstab, int axisType) {
        if (crosstab.isHideMeasureHeader() || crosstab.getMeasureCount() == 0) {
            return false;
        }
        return "vertical".equals(crosstab.getMeasureDirection()) ? axisType == 0 : 1 == axisType;
    }

    public static int findPriorLevelCount(DimensionViewHandle viewHandle) {
        int count = 0;
        CrosstabReportItemHandle crosstab = viewHandle.getCrosstab();
        int dimensionCount = crosstab.getDimensionCount(viewHandle.getAxisType());
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle handle = crosstab.getDimension(viewHandle.getAxisType(), i);
            if (handle == viewHandle) break;
            count += handle.getLevelCount();
            ++i;
        }
        return count;
    }

    private static class DefaultCrosstabUpdateContext
    implements ICrosstabUpdateContext {
        private DefaultCrosstabUpdateContext() {
        }

        @Override
        public void performDefaultCreation(int type, Object model, Map<String, Object> extras) throws SemanticException {
        }

        @Override
        public void performDefaultValidation(int type, Object model, Map<String, Object> extras) throws SemanticException {
            if (type == 2 || type == 3) {
                if (!(model instanceof AggregationCellHandle)) {
                    return;
                }
                AggregationCellHandle cell = (AggregationCellHandle)model;
                MeasureViewHandle measureView = (MeasureViewHandle)cell.getContainer();
                if (!CrosstabModelUtil.needUpdateMeasure(measureView)) {
                    return;
                }
                CrosstabReportItemHandle crosstab = cell.getCrosstab();
                LevelHandle rowLevel = cell.getAggregationOnRow();
                LevelHandle colLevel = cell.getAggregationOnColumn();
                String aggregateRowName = rowLevel == null ? null : rowLevel.getQualifiedName();
                String aggregateColumnName = colLevel == null ? null : colLevel.getQualifiedName();
                String function = null;
                if (extras != null) {
                    function = (String)extras.get("function.hint");
                }
                CrosstabModelUtil.addDataItem(crosstab, cell, measureView, function, null, aggregateRowName, null, aggregateColumnName);
            }
        }
    }

    private static class HeaderData {
        public int rowNumber = 1;
        public int columnNumber = 1;

        private HeaderData() {
        }
    }
}

