/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.ReportDesignMarginBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.GraphicsViewModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.IAdvanceModelEventFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportEventRunnable;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Color;

public abstract class AbstractReportEditPart
extends ReportElementEditPart
implements IAdvanceModelEventFactory {
    public static final String MODEL_EVENT_DISPATCH = "model event dipatch";
    public static final String START = "start";
    public static final String END = "end";

    public AbstractReportEditPart(Object model) {
        super(model);
    }

    public Object getAdapter(Class key) {
        if (key == IModelEventProcessor.class) {
            return new GraphicsViewModelEventProcessor(this);
        }
        return super.getAdapter(key);
    }

    @Override
    public Runnable createModelEventRunnable(Object focus, int type, Map args) {
        switch (type) {
            case 0: 
            case 16: 
            case 17: 
            case 24: {
                return new EditpartReportEventRunnable(this, focus, type, args){

                    @Override
                    public void runModelChange() {
                        this.contentChange(this.getFocus(), this.getArgs());
                    }
                };
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 18: {
                return new EditpartReportEventRunnable(this, focus, type, args){

                    @Override
                    public void runModelChange() {
                        this.propertyChange(this.getFocus(), this.getArgs());
                    }
                };
            }
            case 19: 
            case 21: 
            case 25: {
                return new EditpartReportEventRunnable(this, focus, type, args){

                    @Override
                    public void runModelChange() {
                        this.reloadTheChildren();
                    }
                };
            }
        }
        return null;
    }

    protected void propertyChange(Object focus, Map info) {
        if (this.getViewer() == null) {
            return;
        }
        Object obj = this.getViewer().getEditPartRegistry().get(focus);
        if (obj instanceof ReportElementEditPart && !((ReportElementEditPart)obj).isDelete()) {
            ((ReportElementEditPart)obj).propertyChange(info);
        }
        ArrayList temp = new ArrayList();
        this.getEditPartsFormModel(this, focus, temp);
        int size = temp.size();
        int i = 0;
        while (i < size) {
            Object part = temp.get(i);
            if (part instanceof ReportElementEditPart && !((ReportElementEditPart)part).isDelete()) {
                ((ReportElementEditPart)part).propertyChange(info);
            }
            ++i;
        }
    }

    private void getEditPartsFormModel(ReportElementEditPart part, Object model, List list) {
        if (!list.isEmpty()) {
            return;
        }
        List children = part.getChildren();
        int size = children.size();
        int i = 0;
        while (i < size) {
            Object chPart = children.get(i);
            if (chPart instanceof ReportElementEditPart) {
                this.getEditPartsFormModel((ReportElementEditPart)chPart, model, list);
            }
            ++i;
        }
        if (part.isinterest(model)) {
            list.add(part);
        }
    }

    protected void reloadTheChildren() {
        List list = new ArrayList(this.getChildren());
        int size = list.size();
        int i = 0;
        while (i < size) {
            EditPart part = (EditPart)list.get(i);
            this.removeChild(part);
            ++i;
        }
        list = this.getModelChildren();
        size = list.size();
        i = 0;
        while (i < size) {
            Object model = list.get(i);
            this.addChild(this.createChild(model), i);
            ++i;
        }
        this.refreshVisuals();
    }

    protected void contentChange(Object focus, Map info) {
        if (this.getViewer() == null) {
            return;
        }
        Object obj = this.getViewer().getEditPartRegistry().get(focus);
        if (obj instanceof ReportElementEditPart && !((ReportElementEditPart)obj).isDelete()) {
            ((ReportElementEditPart)obj).contentChange(info);
            return;
        }
        ArrayList temp = new ArrayList();
        this.getEditPartsFormModel(this, focus, temp);
        int size = temp.size();
        int i = 0;
        while (i < size) {
            Object part = temp.get(i);
            if (part instanceof ReportElementEditPart && !((ReportElementEditPart)part).isDelete()) {
                ((ReportElementEditPart)part).contentChange(info);
            }
            ++i;
        }
    }

    protected void notifyModelChange(Object focus) {
        Object obj = this.getViewer().getEditPartRegistry().get(focus);
        if (obj instanceof ReportElementEditPart) {
            ((ReportElementEditPart)obj).notifyModelChange();
            return;
        }
        ArrayList temp = new ArrayList();
        this.getEditPartsFormModel(this, focus, temp);
        int size = temp.size();
        int i = 0;
        while (i < size) {
            Object part = temp.get(i);
            if (part instanceof ReportElementEditPart) {
                ((ReportElementEditPart)part).notifyModelChange();
            }
            ++i;
        }
    }

    @Override
    public boolean isDispose() {
        return this.getParent() == null || this.getViewer().getControl().isDisposed();
    }

    @Override
    public void eventDispathStart() {
        this.getViewer().setProperty(MODEL_EVENT_DISPATCH, (Object)START);
    }

    @Override
    public void eventDispathEnd() {
        this.getViewer().setProperty(MODEL_EVENT_DISPATCH, (Object)END);
    }

    protected Color getBackGroundColor(int color) {
        if (color == 25) {
            return ReportColorConstants.ReportBackground;
        }
        if (color == 24) {
            return ReportColorConstants.ReportForeground;
        }
        return ColorManager.getColor((int)color);
    }

    protected void propertyChange(Map info) {
        if (info.get("layoutPreference") != null) {
            this.updateChildrenLayoutPreference((EditPart)this);
            this.getFigure().invalidateTree();
            this.getFigure().revalidate();
        }
        super.propertyChange(info);
    }

    private void updateChildrenLayoutPreference(EditPart part) {
        if (part instanceof ReportElementEditPart) {
            ((ReportElementEditPart)part).updateLayoutPreference();
        }
        List children = part.getChildren();
        int size = children.size();
        int i = 0;
        while (i < size) {
            Object chPart = children.get(i);
            this.updateChildrenLayoutPreference((EditPart)chPart);
            ++i;
        }
    }

    @Override
    public void activate() {
        super.activate();
    }

    public void refreshMarginBorder(ReportDesignMarginBorder border) {
    }

    private abstract class EditpartReportEventRunnable
    extends ReportEventRunnable {
        public EditpartReportEventRunnable(Object focus, int type, Map args) {
            super(focus, type, args);
        }

        @Override
        public void run() {
            if (AbstractReportEditPart.this.isDispose()) {
                return;
            }
            this.runModelChange();
            AbstractReportEditPart.this.notifyModelChange(this.getFocus());
        }

        protected abstract void runModelChange();
    }
}

