/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.rulers;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerProvider;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;

public class EditorRulerEditPart
extends AbstractGraphicalEditPart {
    protected GraphicalViewer diagramViewer;
    private RulerProvider rulerProvider;
    private boolean horizontal;
    private RulerChangeListener listener = new RulerChangeListener.Stub(){

        public void notifyGuideReparented(Object guide) {
            EditorRulerEditPart.this.handleGuideReparented(guide);
        }

        public void notifyUnitsChanged(int newUnit) {
            EditorRulerEditPart.this.handleUnitsChanged(newUnit);
        }
    };

    public EditorRulerEditPart(Object model) {
        this.setModel(model);
    }

    public void activate() {
        this.getRulerProvider().addRulerChangeListener(this.listener);
        this.getRulerFigure().setZoomManager(this.getZoomManager());
        super.activate();
        if (Policy.TRACING_RULER) {
            System.out.println("Ruler >> Activated");
        }
    }

    public DragTracker getDragTracker(Request request) {
        return null;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new EditRulerSelectionPolicy());
    }

    protected IFigure createFigure() {
        EditorRulerFigure ruler = new EditorRulerFigure(this.isHorizontal(), this.getRulerProvider().getUnit());
        if (ruler.getUnit() == 2) {
            ruler.setInterval(100, 2);
        }
        return ruler;
    }

    public void handleUnitsChanged(int newUnit) {
        this.getRulerFigure().setUnit(newUnit);
        ((EditorRulerFigure)this.getFigure()).setLeftSpace(((EditorRulerProvider)this.getRulerProvider()).getLeftSpace());
    }

    public void deactivate() {
        super.deactivate();
        this.getRulerProvider().removeRulerChangeListener(this.listener);
        this.rulerProvider = null;
        this.getRulerFigure().setZoomManager(null);
        if (Policy.TRACING_RULER) {
            System.out.println("Ruler >> Dectivated");
        }
    }

    public GraphicalViewer getDiagramViewer() {
        return this.diagramViewer;
    }

    public IFigure getGuideLayer() {
        LayerManager lm = (LayerManager)this.diagramViewer.getEditPartRegistry().get(LayerManager.ID);
        if (lm != null) {
            return lm.getLayer((Object)"Guide Layer");
        }
        return null;
    }

    protected List getModelChildren() {
        return this.getRulerProvider().getGuides();
    }

    protected EditorRulerFigure getRulerFigure() {
        return (EditorRulerFigure)this.getFigure();
    }

    public RulerProvider getRulerProvider() {
        return this.rulerProvider;
    }

    public EditPart getTargetEditPart(Request request) {
        if (request.getType().equals("move")) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    public ZoomManager getZoomManager() {
        return (ZoomManager)this.diagramViewer.getProperty(ZoomManager.class.toString());
    }

    public void handleGuideReparented(Object guide) {
        this.refreshChildren();
        EditPart guidePart = (EditPart)this.getViewer().getEditPartRegistry().get(guide);
        if (guidePart != null) {
            this.getViewer().select(guidePart);
        }
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setParent(EditPart parent) {
        super.setParent(parent);
        if (this.getParent() != null && this.diagramViewer == null) {
            this.diagramViewer = (GraphicalViewer)this.getViewer().getProperty(GraphicalViewer.class.toString());
            RulerProvider hProvider = (RulerProvider)this.diagramViewer.getProperty("horizontal ruler");
            if (hProvider != null && hProvider.getRuler() == this.getModel()) {
                this.rulerProvider = hProvider;
                this.horizontal = true;
            } else {
                this.rulerProvider = (RulerProvider)this.diagramViewer.getProperty("vertical ruler");
            }
        }
    }

    public static class EditRulerSelectionPolicy
    extends SelectionEditPolicy {
        protected void hideFocus() {
            ((EditorRulerFigure)this.getHostFigure()).setDrawFocus(false);
        }

        protected void hideSelection() {
            ((EditorRulerFigure)this.getHostFigure()).setDrawFocus(false);
        }

        protected void showSelection() {
        }
    }
}

