/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.data.dte.ReportQueryBuilder;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ReportQueryBuilderFactory {
    private static Logger logger = Logger.getLogger(ReportQueryBuilderFactory.class.getName());
    protected static ReportQueryBuilderFactory instance;

    public static synchronized ReportQueryBuilderFactory getInstance() {
        if (instance == null && (instance = ReportQueryBuilderFactory.loadQueryBuilderExtension()) == null) {
            instance = new ReportQueryBuilderFactory();
        }
        return instance;
    }

    private static ReportQueryBuilderFactory loadQueryBuilderExtension() {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.birt.core.FactoryService");
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String type = element.getAttribute("type");
                if ("org.eclipse.birt.report.engine.data.querybuilderfactory".equals(type)) {
                    try {
                        Object factoryObject = element.createExecutableExtension("class");
                        if (factoryObject instanceof ReportQueryBuilderFactory) {
                            return (ReportQueryBuilderFactory)factoryObject;
                        }
                    }
                    catch (CoreException ex) {
                        logger.log(Level.WARNING, "can not load the engine extension factory", ex);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public ReportQueryBuilder createBuilder(Report report, ExecutionContext context, DataRequestSession dteSession) {
        return new ReportQueryBuilder(report, context, dteSession);
    }
}

